"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseBackupController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const database_backup_dto_1 = require("../dtos/database-backup.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const logging_repository_1 = require("../repositories/logging.repository");
const database_backup_service_1 = require("../services/database-backup.service");
const maintenance_service_1 = require("../services/maintenance.service");
const file_1 = require("../utils/file");
const response_1 = require("../utils/response");
const validation_1 = require("../validation");
let DatabaseBackupController = class DatabaseBackupController {
    logger;
    service;
    maintenanceService;
    constructor(logger, service, maintenanceService) {
        this.logger = logger;
        this.service = service;
        this.maintenanceService = maintenanceService;
    }
    listDatabaseBackups() {
        return this.service.listBackups();
    }
    async downloadDatabaseBackup({ filename }, res, next) {
        await (0, file_1.sendFile)(res, next, () => this.service.downloadBackup(filename), this.logger);
    }
    async deleteDatabaseBackup(dto) {
        return this.service.deleteBackup(dto.backups);
    }
    async startDatabaseRestoreFlow(loginDetails, res) {
        const { jwt } = await this.maintenanceService.startRestoreFlow();
        return (0, response_1.respondWithCookie)(res, undefined, {
            isSecure: loginDetails.isSecure,
            values: [{ key: enum_1.ImmichCookie.MaintenanceToken, value: jwt }],
        });
    }
    uploadDatabaseBackup(file) {
        return this.service.uploadBackup(file);
    }
};
exports.DatabaseBackupController = DatabaseBackupController;
__decorate([
    (0, common_1.Get)(),
    (0, decorators_1.Endpoint)({
        summary: 'List database backups',
        description: 'Get the list of the successful and failed backups',
        history: new decorators_1.HistoryBuilder().added('v2.5.0').alpha('v2.5.0'),
    }),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.Maintenance, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/database-backup.dto").DatabaseBackupListResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DatabaseBackupController.prototype, "listDatabaseBackups", null);
__decorate([
    (0, common_1.Get)(':filename'),
    (0, auth_guard_1.FileResponse)(),
    (0, decorators_1.Endpoint)({
        summary: 'Download database backup',
        description: 'Downloads the database backup file',
        history: new decorators_1.HistoryBuilder().added('v2.5.0').alpha('v2.5.0'),
    }),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.BackupDownload, admin: true }),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Next)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.FilenameParamDto, Object, Function]),
    __metadata("design:returntype", Promise)
], DatabaseBackupController.prototype, "downloadDatabaseBackup", null);
__decorate([
    (0, common_1.Delete)(),
    (0, decorators_1.Endpoint)({
        summary: 'Delete database backup',
        description: 'Delete a backup by its filename',
        history: new decorators_1.HistoryBuilder().added('v2.5.0').alpha('v2.5.0'),
    }),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.BackupDelete, admin: true }),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [database_backup_dto_1.DatabaseBackupDeleteDto]),
    __metadata("design:returntype", Promise)
], DatabaseBackupController.prototype, "deleteDatabaseBackup", null);
__decorate([
    (0, common_1.Post)('start-restore'),
    (0, decorators_1.Endpoint)({
        summary: 'Start database backup restore flow',
        description: 'Put Immich into maintenance mode to restore a backup (Immich must not be configured)',
        history: new decorators_1.HistoryBuilder().added('v2.5.0').alpha('v2.5.0'),
    }),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, auth_guard_1.GetLoginDetails)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], DatabaseBackupController.prototype, "startDatabaseRestoreFlow", null);
__decorate([
    (0, common_1.Post)('upload'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.BackupUpload, admin: true }),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({ description: 'Backup Upload', type: database_backup_dto_1.DatabaseBackupUploadDto }),
    (0, decorators_1.Endpoint)({
        summary: 'Upload database backup',
        description: 'Uploads .sql/.sql.gz file to restore backup from',
        history: new decorators_1.HistoryBuilder().added('v2.5.0').alpha('v2.5.0'),
    }),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DatabaseBackupController.prototype, "uploadDatabaseBackup", null);
exports.DatabaseBackupController = DatabaseBackupController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.DatabaseBackups),
    (0, common_1.Controller)('admin/database-backups'),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        database_backup_service_1.DatabaseBackupService,
        maintenance_service_1.MaintenanceService])
], DatabaseBackupController);
//# sourceMappingURL=database-backup.controller.js.map