import { AuthDto } from 'src/dtos/auth.dto';
import { QueueDeleteDto, QueueJobResponseDto, QueueJobSearchDto, QueueNameParamDto, QueueResponseDto, QueueUpdateDto } from 'src/dtos/queue.dto';
import { QueueService } from 'src/services/queue.service';
export declare class QueueController {
    private service;
    constructor(service: QueueService);
    getQueues(auth: AuthDto): Promise<QueueResponseDto[]>;
    getQueue(auth: AuthDto, { name }: QueueNameParamDto): Promise<QueueResponseDto>;
    updateQueue(auth: AuthDto, { name }: QueueNameParamDto, dto: QueueUpdateDto): Promise<QueueResponseDto>;
    getQueueJobs(auth: AuthDto, { name }: QueueNameParamDto, dto: QueueJobSearchDto): Promise<QueueJobResponseDto[]>;
    emptyQueue(auth: AuthDto, { name }: QueueNameParamDto, dto: QueueDeleteDto): Promise<void>;
}
