"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseResponseDto = exports.LicenseKeyDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
class LicenseKeyDto {
    licenseKey;
    activationKey;
    static _OPENAPI_METADATA_FACTORY() {
        return { licenseKey: { required: true, type: () => String, pattern: "/IM(SV|CL)(-[\\dA-Za-z]{4}){8}/" }, activationKey: { required: true, type: () => String } };
    }
}
exports.LicenseKeyDto = LicenseKeyDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'License key (format: IM(SV|CL)(-XXXX){8})' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.Matches)(/IM(SV|CL)(-[\dA-Za-z]{4}){8}/),
    __metadata("design:type", String)
], LicenseKeyDto.prototype, "licenseKey", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Activation key' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], LicenseKeyDto.prototype, "activationKey", void 0);
class LicenseResponseDto extends LicenseKeyDto {
    activatedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { activatedAt: { required: true, type: () => Date } };
    }
}
exports.LicenseResponseDto = LicenseResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Activation date' }),
    __metadata("design:type", Date)
], LicenseResponseDto.prototype, "activatedAt", void 0);
//# sourceMappingURL=license.dto.js.map