"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerFeaturesDto = exports.ServerConfigDto = exports.ServerThemeDto = exports.ServerMediaTypesResponseDto = exports.ServerStatsResponseDto = exports.UsageByUserDto = exports.ServerVersionHistoryResponseDto = exports.ServerVersionResponseDto = exports.ServerStorageResponseDto = exports.ServerApkLinksDto = exports.ServerAboutResponseDto = exports.ServerPingResponse = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const system_config_dto_1 = require("./system-config.dto");
class ServerPingResponse {
    res;
    static _OPENAPI_METADATA_FACTORY() {
        return { res: { required: true, type: () => String } };
    }
}
exports.ServerPingResponse = ServerPingResponse;
__decorate([
    (0, swagger_1.ApiResponseProperty)({ type: String, example: 'pong' }),
    __metadata("design:type", String)
], ServerPingResponse.prototype, "res", void 0);
class ServerAboutResponseDto {
    version;
    versionUrl;
    repository;
    repositoryUrl;
    sourceRef;
    sourceCommit;
    sourceUrl;
    build;
    buildUrl;
    buildImage;
    buildImageUrl;
    nodejs;
    ffmpeg;
    imagemagick;
    libvips;
    exiftool;
    licensed;
    thirdPartySourceUrl;
    thirdPartyBugFeatureUrl;
    thirdPartyDocumentationUrl;
    thirdPartySupportUrl;
    static _OPENAPI_METADATA_FACTORY() {
        return { version: { required: true, type: () => String }, versionUrl: { required: true, type: () => String }, repository: { required: false, type: () => String }, repositoryUrl: { required: false, type: () => String }, sourceRef: { required: false, type: () => String }, sourceCommit: { required: false, type: () => String }, sourceUrl: { required: false, type: () => String }, build: { required: false, type: () => String }, buildUrl: { required: false, type: () => String }, buildImage: { required: false, type: () => String }, buildImageUrl: { required: false, type: () => String }, nodejs: { required: false, type: () => String }, ffmpeg: { required: false, type: () => String }, imagemagick: { required: false, type: () => String }, libvips: { required: false, type: () => String }, exiftool: { required: false, type: () => String }, licensed: { required: true, type: () => Boolean }, thirdPartySourceUrl: { required: false, type: () => String }, thirdPartyBugFeatureUrl: { required: false, type: () => String }, thirdPartyDocumentationUrl: { required: false, type: () => String }, thirdPartySupportUrl: { required: false, type: () => String } };
    }
}
exports.ServerAboutResponseDto = ServerAboutResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Server version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "version", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'URL to version information' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "versionUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Repository name' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "repository", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Repository URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "repositoryUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Source reference (branch/tag)' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "sourceRef", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Source commit hash' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "sourceCommit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Source URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "sourceUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Build identifier' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "build", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Build URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "buildUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Build image name' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "buildImage", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Build image URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "buildImageUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Node.js version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "nodejs", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'FFmpeg version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "ffmpeg", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'ImageMagick version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "imagemagick", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'libvips version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "libvips", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'ExifTool version' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "exiftool", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether the server is licensed' }),
    __metadata("design:type", Boolean)
], ServerAboutResponseDto.prototype, "licensed", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Third-party source URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "thirdPartySourceUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Third-party bug/feature URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "thirdPartyBugFeatureUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Third-party documentation URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "thirdPartyDocumentationUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Third-party support URL' }),
    __metadata("design:type", String)
], ServerAboutResponseDto.prototype, "thirdPartySupportUrl", void 0);
class ServerApkLinksDto {
    arm64v8a;
    armeabiv7a;
    universal;
    x86_64;
    static _OPENAPI_METADATA_FACTORY() {
        return { arm64v8a: { required: true, type: () => String }, armeabiv7a: { required: true, type: () => String }, universal: { required: true, type: () => String }, x86_64: { required: true, type: () => String } };
    }
}
exports.ServerApkLinksDto = ServerApkLinksDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'APK download link for ARM64 v8a architecture' }),
    __metadata("design:type", String)
], ServerApkLinksDto.prototype, "arm64v8a", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'APK download link for ARM EABI v7a architecture' }),
    __metadata("design:type", String)
], ServerApkLinksDto.prototype, "armeabiv7a", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'APK download link for universal architecture' }),
    __metadata("design:type", String)
], ServerApkLinksDto.prototype, "universal", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'APK download link for x86_64 architecture' }),
    __metadata("design:type", String)
], ServerApkLinksDto.prototype, "x86_64", void 0);
class ServerStorageResponseDto {
    diskSize;
    diskUse;
    diskAvailable;
    diskSizeRaw;
    diskUseRaw;
    diskAvailableRaw;
    diskUsagePercentage;
    static _OPENAPI_METADATA_FACTORY() {
        return { diskSize: { required: true, type: () => String }, diskUse: { required: true, type: () => String }, diskAvailable: { required: true, type: () => String }, diskSizeRaw: { required: true, type: () => Number }, diskUseRaw: { required: true, type: () => Number }, diskAvailableRaw: { required: true, type: () => Number }, diskUsagePercentage: { required: true, type: () => Number } };
    }
}
exports.ServerStorageResponseDto = ServerStorageResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Total disk size (human-readable format)' }),
    __metadata("design:type", String)
], ServerStorageResponseDto.prototype, "diskSize", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Used disk space (human-readable format)' }),
    __metadata("design:type", String)
], ServerStorageResponseDto.prototype, "diskUse", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Available disk space (human-readable format)' }),
    __metadata("design:type", String)
], ServerStorageResponseDto.prototype, "diskAvailable", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Total disk size in bytes' }),
    __metadata("design:type", Number)
], ServerStorageResponseDto.prototype, "diskSizeRaw", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Used disk space in bytes' }),
    __metadata("design:type", Number)
], ServerStorageResponseDto.prototype, "diskUseRaw", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Available disk space in bytes' }),
    __metadata("design:type", Number)
], ServerStorageResponseDto.prototype, "diskAvailableRaw", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double', description: 'Disk usage percentage (0-100)' }),
    __metadata("design:type", Number)
], ServerStorageResponseDto.prototype, "diskUsagePercentage", void 0);
class ServerVersionResponseDto {
    major;
    minor;
    patch;
    static fromSemVer(value) {
        return { major: value.major, minor: value.minor, patch: value.patch };
    }
    static _OPENAPI_METADATA_FACTORY() {
        return { major: { required: true, type: () => Number }, minor: { required: true, type: () => Number }, patch: { required: true, type: () => Number } };
    }
}
exports.ServerVersionResponseDto = ServerVersionResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Major version number' }),
    __metadata("design:type", Number)
], ServerVersionResponseDto.prototype, "major", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Minor version number' }),
    __metadata("design:type", Number)
], ServerVersionResponseDto.prototype, "minor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Patch version number' }),
    __metadata("design:type", Number)
], ServerVersionResponseDto.prototype, "patch", void 0);
class ServerVersionHistoryResponseDto {
    id;
    createdAt;
    version;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, version: { required: true, type: () => String } };
    }
}
exports.ServerVersionHistoryResponseDto = ServerVersionHistoryResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Version history entry ID' }),
    __metadata("design:type", String)
], ServerVersionHistoryResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'When this version was first seen', format: 'date-time' }),
    __metadata("design:type", Date)
], ServerVersionHistoryResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Version string' }),
    __metadata("design:type", String)
], ServerVersionHistoryResponseDto.prototype, "version", void 0);
class UsageByUserDto {
    userId;
    userName;
    photos;
    videos;
    usage;
    usagePhotos;
    usageVideos;
    quotaSizeInBytes;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, userName: { required: true, type: () => String }, photos: { required: true, type: () => Number }, videos: { required: true, type: () => Number }, usage: { required: true, type: () => Number }, usagePhotos: { required: true, type: () => Number }, usageVideos: { required: true, type: () => Number }, quotaSizeInBytes: { required: true, type: () => Number, nullable: true } };
    }
}
exports.UsageByUserDto = UsageByUserDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', description: 'User ID' }),
    __metadata("design:type", String)
], UsageByUserDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', description: 'User name' }),
    __metadata("design:type", String)
], UsageByUserDto.prototype, "userName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of photos' }),
    __metadata("design:type", Number)
], UsageByUserDto.prototype, "photos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of videos' }),
    __metadata("design:type", Number)
], UsageByUserDto.prototype, "videos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Total storage usage in bytes' }),
    __metadata("design:type", Number)
], UsageByUserDto.prototype, "usage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage usage for photos in bytes' }),
    __metadata("design:type", Number)
], UsageByUserDto.prototype, "usagePhotos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage usage for videos in bytes' }),
    __metadata("design:type", Number)
], UsageByUserDto.prototype, "usageVideos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'integer',
        format: 'int64',
        nullable: true,
        description: 'User quota size in bytes (null if unlimited)',
    }),
    __metadata("design:type", Object)
], UsageByUserDto.prototype, "quotaSizeInBytes", void 0);
class ServerStatsResponseDto {
    photos = 0;
    videos = 0;
    usage = 0;
    usagePhotos = 0;
    usageVideos = 0;
    usageByUser = [];
    static _OPENAPI_METADATA_FACTORY() {
        return { photos: { required: true, type: () => Object, default: 0 }, videos: { required: true, type: () => Object, default: 0 }, usage: { required: true, type: () => Object, default: 0 }, usagePhotos: { required: true, type: () => Object, default: 0 }, usageVideos: { required: true, type: () => Object, default: 0 }, usageByUser: { required: true, type: () => [require("./server.dto").UsageByUserDto], default: [] } };
    }
}
exports.ServerStatsResponseDto = ServerStatsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total number of photos' }),
    __metadata("design:type", Object)
], ServerStatsResponseDto.prototype, "photos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total number of videos' }),
    __metadata("design:type", Object)
], ServerStatsResponseDto.prototype, "videos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Total storage usage in bytes' }),
    __metadata("design:type", Object)
], ServerStatsResponseDto.prototype, "usage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage usage for photos in bytes' }),
    __metadata("design:type", Object)
], ServerStatsResponseDto.prototype, "usagePhotos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64', description: 'Storage usage for videos in bytes' }),
    __metadata("design:type", Object)
], ServerStatsResponseDto.prototype, "usageVideos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        isArray: true,
        type: UsageByUserDto,
        title: 'Array of usage for each user',
        example: [
            {
                photos: 1,
                videos: 1,
                diskUsageRaw: 2,
                usagePhotos: 1,
                usageVideos: 1,
            },
        ],
    }),
    __metadata("design:type", Array)
], ServerStatsResponseDto.prototype, "usageByUser", void 0);
class ServerMediaTypesResponseDto {
    video;
    image;
    sidecar;
    static _OPENAPI_METADATA_FACTORY() {
        return { video: { required: true, type: () => [String] }, image: { required: true, type: () => [String] }, sidecar: { required: true, type: () => [String] } };
    }
}
exports.ServerMediaTypesResponseDto = ServerMediaTypesResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Supported video MIME types' }),
    __metadata("design:type", Array)
], ServerMediaTypesResponseDto.prototype, "video", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Supported image MIME types' }),
    __metadata("design:type", Array)
], ServerMediaTypesResponseDto.prototype, "image", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Supported sidecar MIME types' }),
    __metadata("design:type", Array)
], ServerMediaTypesResponseDto.prototype, "sidecar", void 0);
class ServerThemeDto extends system_config_dto_1.SystemConfigThemeDto {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
exports.ServerThemeDto = ServerThemeDto;
class ServerConfigDto {
    oauthButtonText;
    loginPageMessage;
    trashDays;
    userDeleteDelay;
    isInitialized;
    isOnboarded;
    externalDomain;
    publicUsers;
    mapDarkStyleUrl;
    mapLightStyleUrl;
    maintenanceMode;
    static _OPENAPI_METADATA_FACTORY() {
        return { oauthButtonText: { required: true, type: () => String }, loginPageMessage: { required: true, type: () => String }, trashDays: { required: true, type: () => Number }, userDeleteDelay: { required: true, type: () => Number }, isInitialized: { required: true, type: () => Boolean }, isOnboarded: { required: true, type: () => Boolean }, externalDomain: { required: true, type: () => String }, publicUsers: { required: true, type: () => Boolean }, mapDarkStyleUrl: { required: true, type: () => String }, mapLightStyleUrl: { required: true, type: () => String }, maintenanceMode: { required: true, type: () => Boolean } };
    }
}
exports.ServerConfigDto = ServerConfigDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OAuth button text' }),
    __metadata("design:type", String)
], ServerConfigDto.prototype, "oauthButtonText", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Login page message' }),
    __metadata("design:type", String)
], ServerConfigDto.prototype, "loginPageMessage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of days before trashed assets are permanently deleted' }),
    __metadata("design:type", Number)
], ServerConfigDto.prototype, "trashDays", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Delay in days before deleted users are permanently removed' }),
    __metadata("design:type", Number)
], ServerConfigDto.prototype, "userDeleteDelay", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether the server has been initialized' }),
    __metadata("design:type", Boolean)
], ServerConfigDto.prototype, "isInitialized", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether the admin has completed onboarding' }),
    __metadata("design:type", Boolean)
], ServerConfigDto.prototype, "isOnboarded", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'External domain URL' }),
    __metadata("design:type", String)
], ServerConfigDto.prototype, "externalDomain", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether public user registration is enabled' }),
    __metadata("design:type", Boolean)
], ServerConfigDto.prototype, "publicUsers", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Map dark style URL' }),
    __metadata("design:type", String)
], ServerConfigDto.prototype, "mapDarkStyleUrl", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Map light style URL' }),
    __metadata("design:type", String)
], ServerConfigDto.prototype, "mapLightStyleUrl", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether maintenance mode is active' }),
    __metadata("design:type", Boolean)
], ServerConfigDto.prototype, "maintenanceMode", void 0);
class ServerFeaturesDto {
    smartSearch;
    duplicateDetection;
    configFile;
    facialRecognition;
    map;
    trash;
    reverseGeocoding;
    importFaces;
    oauth;
    oauthAutoLaunch;
    passwordLogin;
    sidecar;
    search;
    email;
    ocr;
    static _OPENAPI_METADATA_FACTORY() {
        return { smartSearch: { required: true, type: () => Boolean }, duplicateDetection: { required: true, type: () => Boolean }, configFile: { required: true, type: () => Boolean }, facialRecognition: { required: true, type: () => Boolean }, map: { required: true, type: () => Boolean }, trash: { required: true, type: () => Boolean }, reverseGeocoding: { required: true, type: () => Boolean }, importFaces: { required: true, type: () => Boolean }, oauth: { required: true, type: () => Boolean }, oauthAutoLaunch: { required: true, type: () => Boolean }, passwordLogin: { required: true, type: () => Boolean }, sidecar: { required: true, type: () => Boolean }, search: { required: true, type: () => Boolean }, email: { required: true, type: () => Boolean }, ocr: { required: true, type: () => Boolean } };
    }
}
exports.ServerFeaturesDto = ServerFeaturesDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether smart search is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "smartSearch", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether duplicate detection is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "duplicateDetection", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether config file is available' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "configFile", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether facial recognition is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "facialRecognition", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether map feature is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "map", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether trash feature is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "trash", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether reverse geocoding is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "reverseGeocoding", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether face import is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "importFaces", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether OAuth is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "oauth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether OAuth auto-launch is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "oauthAutoLaunch", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether password login is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "passwordLogin", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether sidecar files are supported' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "sidecar", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether search is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "search", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether email notifications are enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether OCR is enabled' }),
    __metadata("design:type", Boolean)
], ServerFeaturesDto.prototype, "ocr", void 0);
//# sourceMappingURL=server.dto.js.map