import { OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit } from '@nestjs/websockets';
import { Server, Socket } from 'socket.io';
import { MaintenanceAuthDto, MaintenanceStatusResponseDto } from 'src/dtos/maintenance.dto';
import { AppRepository } from 'src/repositories/app.repository';
import { AppRestartEvent } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
interface ServerEventMap {
    AppRestart: [AppRestartEvent];
    MaintenanceStatus: [MaintenanceStatusResponseDto];
}
interface ClientEventMap {
    AppRestartV1: [AppRestartEvent];
    MaintenanceStatusV1: [MaintenanceStatusResponseDto];
}
export declare class MaintenanceWebsocketRepository implements OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit {
    private logger;
    private appRepository;
    private authFn?;
    private statusUpdateFn?;
    private server?;
    constructor(logger: LoggingRepository, appRepository: AppRepository);
    afterInit(server: Server): void;
    clientSend<T extends keyof ClientEventMap>(event: T, room: string, ...data: ClientEventMap[T]): void;
    clientBroadcast<T extends keyof ClientEventMap>(event: T, ...data: ClientEventMap[T]): void;
    serverSend<T extends keyof ServerEventMap>(event: T, ...args: ServerEventMap[T]): void;
    handleConnection(client: Socket): Promise<void>;
    handleDisconnect(client: Socket): Promise<void>;
    setAuthFn(fn: (client: Socket) => Promise<MaintenanceAuthDto>): void;
    setStatusUpdateFn(fn: (status: MaintenanceStatusResponseDto) => void): void;
}
export {};
