"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MaintenanceWebsocketRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceWebsocketRepository = void 0;
const common_1 = require("@nestjs/common");
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
const app_repository_1 = require("../repositories/app.repository");
const logging_repository_1 = require("../repositories/logging.repository");
let MaintenanceWebsocketRepository = MaintenanceWebsocketRepository_1 = class MaintenanceWebsocketRepository {
    logger;
    appRepository;
    authFn;
    statusUpdateFn;
    server;
    constructor(logger, appRepository) {
        this.logger = logger;
        this.appRepository = appRepository;
        this.logger.setContext(MaintenanceWebsocketRepository_1.name);
    }
    afterInit(server) {
        this.logger.log('Initialized websocket server');
        server.on('MaintenanceStatus', (status) => this.statusUpdateFn?.(status));
        server.on('AppRestart', (event, ack) => {
            this.logger.log(`Restarting due to event... ${JSON.stringify(event)}`);
            ack?.('ok');
            this.appRepository.exitApp();
        });
    }
    clientSend(event, room, ...data) {
        this.server?.to(room).emit(event, ...data);
    }
    clientBroadcast(event, ...data) {
        this.server?.emit(event, ...data);
    }
    serverSend(event, ...args) {
        this.logger.debug(`Server event: ${event} (send)`);
        this.server?.serverSideEmit(event, ...args);
    }
    async handleConnection(client) {
        try {
            await this.authFn(client);
            await client.join('private');
            this.logger.log(`Websocket Connect:    ${client.id} (private)`);
        }
        catch {
            await client.join('public');
            this.logger.log(`Websocket Connect:    ${client.id} (public)`);
        }
    }
    async handleDisconnect(client) {
        this.logger.log(`Websocket Disconnect: ${client.id}`);
        await Promise.allSettled([client.leave('private'), client.leave('public')]);
    }
    setAuthFn(fn) {
        this.authFn = fn;
    }
    setStatusUpdateFn(fn) {
        this.statusUpdateFn = fn;
    }
};
exports.MaintenanceWebsocketRepository = MaintenanceWebsocketRepository;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], MaintenanceWebsocketRepository.prototype, "server", void 0);
exports.MaintenanceWebsocketRepository = MaintenanceWebsocketRepository = MaintenanceWebsocketRepository_1 = __decorate([
    (0, websockets_1.WebSocketGateway)({
        cors: true,
        path: '/api/socket.io',
        transports: ['websocket'],
    }),
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        app_repository_1.AppRepository])
], MaintenanceWebsocketRepository);
//# sourceMappingURL=maintenance-websocket.repository.js.map