"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ErrorInterceptor_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorInterceptor = void 0;
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const logging_repository_1 = require("../repositories/logging.repository");
const logger_1 = require("../utils/logger");
const misc_1 = require("../utils/misc");
let ErrorInterceptor = ErrorInterceptor_1 = class ErrorInterceptor {
    logger;
    constructor(logger) {
        this.logger = logger;
        this.logger.setContext(ErrorInterceptor_1.name);
    }
    intercept(context, next) {
        return next.handle().pipe((0, rxjs_1.catchError)((error) => (0, rxjs_1.throwError)(() => {
            if (error instanceof common_1.HttpException) {
                return error;
            }
            (0, logger_1.logGlobalError)(this.logger, error);
            const message = (0, misc_1.routeToErrorMessage)(context.getHandler().name);
            return new common_1.InternalServerErrorException(message);
        })));
    }
};
exports.ErrorInterceptor = ErrorInterceptor;
exports.ErrorInterceptor = ErrorInterceptor = ErrorInterceptor_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository])
], ErrorInterceptor);
//# sourceMappingURL=error.interceptor.js.map