import { SchedulerRegistry } from '@nestjs/schedule';
import { LoggingRepository } from 'src/repositories/logging.repository';
type CronBase = {
    name: string;
    start?: boolean;
};
export type CronCreate = CronBase & {
    expression: string;
    onTick: () => void;
};
export type CronUpdate = CronBase & {
    expression?: string;
};
export declare class CronRepository {
    private schedulerRegistry;
    private logger;
    constructor(schedulerRegistry: SchedulerRegistry, logger: LoggingRepository);
    create({ name, expression, onTick, start }: CronCreate): void;
    update({ name, expression, start }: CronUpdate): void;
}
export {};
