import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { PartnerTable } from 'src/schema/tables/partner.table';
export interface PartnerIds {
    sharedById: string;
    sharedWithId: string;
}
export declare enum PartnerDirection {
    SharedBy = "shared-by",
    SharedWith = "shared-with"
}
export declare class PartnerRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(userId: string): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        createId: string;
        sharedById: string;
        sharedWithId: string;
        inTimeline: boolean;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedBy: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedBy", "avatarColor">;
            profileChangedAt: Date;
        } | null;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedWith: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedWith", "avatarColor">;
            profileChangedAt: Date;
        } | null;
    }[]>;
    get({ sharedWithId, sharedById }: PartnerIds): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        createId: string;
        sharedById: string;
        sharedWithId: string;
        inTimeline: boolean;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedBy: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedBy", "avatarColor">;
            profileChangedAt: Date;
        } | null;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedWith: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedWith", "avatarColor">;
            profileChangedAt: Date;
        } | null;
    } | undefined>;
    create(values: Insertable<PartnerTable>): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        createId: string;
        sharedById: string;
        sharedWithId: string;
        inTimeline: boolean;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedBy: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedBy", "avatarColor">;
            profileChangedAt: Date;
        };
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedWith: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedWith", "avatarColor">;
            profileChangedAt: Date;
        };
    }>;
    update({ sharedWithId, sharedById }: PartnerIds, values: Updateable<PartnerTable>): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        createId: string;
        sharedById: string;
        sharedWithId: string;
        inTimeline: boolean;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedBy: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedBy", "avatarColor">;
            profileChangedAt: Date;
        };
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB & {
                sharedWith: import("../schema/tables/user.table").UserTable;
            }, "partner" | "sharedWith", "avatarColor">;
            profileChangedAt: Date;
        };
    }>;
    remove({ sharedWithId, sharedById }: PartnerIds): Promise<void>;
    private builder;
}
