import { Insertable, Kysely, Selectable, Updateable } from 'kysely';
import { AssetFace } from 'src/database';
import { AssetVisibility, SourceType } from 'src/enum';
import { DB } from 'src/schema';
import { AssetFaceTable } from 'src/schema/tables/asset-face.table';
import { FaceSearchTable } from 'src/schema/tables/face-search.table';
import { PersonTable } from 'src/schema/tables/person.table';
import { PaginationOptions } from 'src/utils/pagination';
export interface PersonSearchOptions {
    minimumFaceCount: number;
    withHidden: boolean;
    closestFaceAssetId?: string;
}
export interface PersonNameSearchOptions {
    withHidden?: boolean;
}
export interface PersonNameResponse {
    id: string;
    name: string;
}
export interface AssetFaceId {
    assetId: string;
    personId: string;
}
export interface UpdateFacesData {
    oldPersonId?: string;
    faceIds?: string[];
    newPersonId: string;
}
export interface PersonStatistics {
    assets: number;
}
export interface DeleteFacesOptions {
    sourceType: SourceType;
}
export interface GetAllPeopleOptions {
    ownerId?: string;
    thumbnailPath?: string;
    faceAssetId?: string | null;
    isHidden?: boolean;
}
export interface GetAllFacesOptions {
    personId?: string | null;
    assetId?: string;
    sourceType?: SourceType;
}
export type UnassignFacesOptions = DeleteFacesOptions;
export type SelectFaceOptions = (keyof Selectable<AssetFaceTable>)[];
export declare class PersonRepository {
    private db;
    constructor(db: Kysely<DB>);
    reassignFaces({ oldPersonId, faceIds, newPersonId }: UpdateFacesData): Promise<number>;
    unassignFaces({ sourceType }: UnassignFacesOptions): Promise<void>;
    delete(ids: string[]): Promise<void>;
    deleteFaces({ sourceType }: DeleteFacesOptions): Promise<void>;
    getAllFaces(options?: GetAllFacesOptions): AsyncIterableIterator<{
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        isVisible: boolean;
    } & Partial<Omit<unknown, "id" | "assetId" | "updatedAt" | "deletedAt" | "updateId" | "personId" | "imageWidth" | "imageHeight" | "boundingBoxX1" | "boundingBoxY1" | "boundingBoxX2" | "boundingBoxY2" | "sourceType" | "isVisible">>>;
    getAll(options?: GetAllPeopleOptions): AsyncIterableIterator<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    } & Partial<Omit<unknown, "name" | "id" | "updatedAt" | "createdAt" | "updateId" | "ownerId" | "isFavorite" | "thumbnailPath" | "isHidden" | "birthDate" | "faceAssetId" | "color">>>;
    getFileSamples(): Promise<{
        id: string;
        thumbnailPath: string;
    }[]>;
    getAllForUser(pagination: PaginationOptions, userId: string, options?: PersonSearchOptions): Promise<import("src/utils/pagination").PaginationResult<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }>>;
    getAllWithoutFaces(): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }[]>;
    getFaces(assetId: string, options?: {
        isVisible?: boolean;
    }): Promise<{
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        isVisible: boolean;
        person: {
            name: string;
            id: string;
            updatedAt: Date;
            createdAt: Date;
            updateId: string;
            ownerId: string;
            isFavorite: boolean;
            thumbnailPath: string;
            isHidden: boolean;
            birthDate: Date | null;
            faceAssetId: string | null;
            color: string | null;
        } | null;
    }[]>;
    getFaceById(id: string): Promise<{
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        isVisible: boolean;
        person: {
            name: string;
            id: string;
            updatedAt: Date;
            createdAt: Date;
            updateId: string;
            ownerId: string;
            isFavorite: boolean;
            thumbnailPath: string;
            isHidden: boolean;
            birthDate: Date | null;
            faceAssetId: string | null;
            color: string | null;
        } | null;
    }>;
    getFaceForFacialRecognitionJob(id: string): Promise<{
        id: string;
        personId: string | null;
        sourceType: SourceType;
        asset: {
            ownerId: string;
            fileCreatedAt: Date;
            visibility: AssetVisibility;
        } | null;
        faceSearch: {
            embedding: string;
            faceId: string;
        } | null;
    } | undefined>;
    getDataForThumbnailGenerationJob(id: string): Promise<{
        type: import("src/enum").AssetType;
        originalPath: string;
        ownerId: string;
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        oldWidth: number;
        oldHeight: number;
        exifOrientation: string | null;
        previewPath: string | null;
    } | undefined>;
    reassignFace(assetFaceId: string, newPersonId: string): Promise<number>;
    getById(personId: string): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    } | undefined>;
    getByName(userId: string, personName: string, { withHidden }: PersonNameSearchOptions): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }[]>;
    getDistinctNames(userId: string, { withHidden }: PersonNameSearchOptions): Promise<PersonNameResponse[]>;
    getStatistics(personId: string): Promise<PersonStatistics>;
    getNumberOfPeople(userId: string): Promise<{
        total: number;
        hidden: number;
    }>;
    create(person: Insertable<PersonTable>): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }>;
    createAll(people: Insertable<PersonTable>[]): Promise<string[]>;
    refreshFaces(facesToAdd: (Insertable<AssetFaceTable> & {
        assetId: string;
    })[], faceIdsToRemove: string[], embeddingsToAdd?: Insertable<FaceSearchTable>[]): Promise<void>;
    update(person: Updateable<PersonTable> & {
        id: string;
    }): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        thumbnailPath: string;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }>;
    updateAll(people: Insertable<PersonTable>[]): Promise<void>;
    getFacesByIds(ids: AssetFaceId[]): Promise<{
        asset: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            width: number | null;
            height: number | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: AssetVisibility;
            isEdited: boolean;
        };
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        isVisible: boolean;
        person: {
            name: string;
            id: string;
            updatedAt: Date;
            createdAt: Date;
            updateId: string;
            ownerId: string;
            isFavorite: boolean;
            thumbnailPath: string;
            isHidden: boolean;
            birthDate: Date | null;
            faceAssetId: string | null;
            color: string | null;
        } | null;
    }[]>;
    getRandomFace(personId: string): Promise<{
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        isVisible: boolean;
    } | undefined>;
    getLatestFaceDate(): Promise<string | undefined>;
    createAssetFace(face: Insertable<AssetFaceTable>): Promise<void>;
    deleteAssetFace(id: string): Promise<void>;
    softDeleteAssetFaces(id: string): Promise<void>;
    vacuum({ reindexVectors }: {
        reindexVectors: boolean;
    }): Promise<void>;
    getForPeopleDelete(ids: string[]): Promise<{
        id: string;
        thumbnailPath: string;
    }[]>;
    updateVisibility(visible: AssetFace[], hidden: AssetFace[]): Promise<void>;
}
