import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { SessionTable } from 'src/schema/tables/session.table';
export type SessionSearchOptions = {
    updatedBefore: Date;
};
export declare class SessionRepository {
    private db;
    constructor(db: Kysely<DB>);
    cleanup(): Promise<{
        id: string;
        deviceType: string;
        deviceOS: string;
    }[]>;
    get(id: string): Promise<{
        id: string;
        expiresAt: Date | null;
        pinExpiresAt: Date | null;
    } | undefined>;
    isPendingSyncReset(id: string): Promise<boolean>;
    getByToken(token: string): Promise<{
        id: string;
        updatedAt: Date;
        pinExpiresAt: Date | null;
        appVersion: string | null;
        user: {
            name: string;
            id: string;
            email: string;
            isAdmin: boolean;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
        } | null;
    } | undefined>;
    getByUserId(userId: string): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        pinExpiresAt: Date | null;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        token: string;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        appVersion: string | null;
        isPendingSyncReset: boolean;
    }[]>;
    create(dto: Insertable<SessionTable>): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        pinExpiresAt: Date | null;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        token: string;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        appVersion: string | null;
        isPendingSyncReset: boolean;
    }>;
    update(id: string, dto: Updateable<SessionTable>): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        pinExpiresAt: Date | null;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        token: string;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        appVersion: string | null;
        isPendingSyncReset: boolean;
    }>;
    delete(id: string): Promise<void>;
    invalidate({ userId, excludeId }: {
        userId: string;
        excludeId?: string;
    }): Promise<void>;
    lockAll(userId: string): Promise<void>;
    resetSyncProgress(sessionId: string): Promise<void>;
}
