"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "sessions" ADD "expiredAt" timestamp with time zone;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "sessions" ADD "parentId" uuid;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "sessions" ADD CONSTRAINT "FK_afbbabbd7daf5b91de4dca84de8" FOREIGN KEY ("parentId") REFERENCES "sessions" ("id") ON UPDATE CASCADE ON DELETE CASCADE;`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_afbbabbd7daf5b91de4dca84de" ON "sessions" ("parentId")`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP INDEX "IDX_afbbabbd7daf5b91de4dca84de";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "sessions" DROP CONSTRAINT "FK_afbbabbd7daf5b91de4dca84de8";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "sessions" DROP COLUMN "expiredAt";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "sessions" DROP COLUMN "parentId";`.execute(db);
}
//# sourceMappingURL=1747329504572-AddNewSessionColumns.js.map