import { NextFunction, Request, Response } from 'express';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AuthService } from 'src/services/auth.service';
import { SharedLinkService } from 'src/services/shared-link.service';
import { VersionService } from 'src/services/version.service';
import { OpenGraphTags } from 'src/utils/misc';
export declare const render: (index: string, meta: OpenGraphTags) => string;
export declare class ApiService {
    private authService;
    private sharedLinkService;
    private versionService;
    private configRepository;
    private logger;
    constructor(authService: AuthService, sharedLinkService: SharedLinkService, versionService: VersionService, configRepository: ConfigRepository, logger: LoggingRepository);
    onVersionCheck(): Promise<void>;
    ssr(excludePaths: string[]): (request: Request, res: Response, next: NextFunction) => Promise<void>;
}
