import { AuthDto } from 'src/dtos/auth.dto';
import { SessionCreateDto, SessionCreateResponseDto, SessionResponseDto, SessionUpdateDto } from 'src/dtos/session.dto';
import { JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class SessionService extends BaseService {
    handleCleanup(): Promise<JobStatus>;
    create(auth: AuthDto, dto: SessionCreateDto): Promise<SessionCreateResponseDto>;
    getAll(auth: AuthDto): Promise<SessionResponseDto[]>;
    update(auth: AuthDto, id: string, dto: SessionUpdateDto): Promise<SessionResponseDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    deleteAll(auth: AuthDto): Promise<void>;
    lock(auth: AuthDto, id: string): Promise<void>;
    onAuthChangePassword({ userId, currentSessionId }: ArgOf<'AuthChangePassword'>): Promise<void>;
}
