import { AssetIdsResponseDto } from 'src/dtos/asset-ids.response.dto';
import { AssetIdsDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { SharedLinkCreateDto, SharedLinkEditDto, SharedLinkPasswordDto, SharedLinkResponseDto, SharedLinkSearchDto } from 'src/dtos/shared-link.dto';
import { BaseService } from 'src/services/base.service';
import { OpenGraphTags } from 'src/utils/misc';
export declare class SharedLinkService extends BaseService {
    getAll(auth: AuthDto, { id, albumId }: SharedLinkSearchDto): Promise<SharedLinkResponseDto[]>;
    getMine(auth: AuthDto, dto: SharedLinkPasswordDto): Promise<SharedLinkResponseDto>;
    get(auth: AuthDto, id: string): Promise<SharedLinkResponseDto>;
    create(auth: AuthDto, dto: SharedLinkCreateDto): Promise<SharedLinkResponseDto>;
    private handleError;
    update(auth: AuthDto, id: string, dto: SharedLinkEditDto): Promise<SharedLinkResponseDto>;
    remove(auth: AuthDto, id: string): Promise<void>;
    private findOrFail;
    addAssets(auth: AuthDto, id: string, dto: AssetIdsDto): Promise<AssetIdsResponseDto[]>;
    removeAssets(auth: AuthDto, id: string, dto: AssetIdsDto): Promise<AssetIdsResponseDto[]>;
    getMetadataTags(auth: AuthDto, defaultDomain?: string): Promise<null | OpenGraphTags>;
    private validateAndRefreshToken;
}
