"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TelemetryService = void 0;
const lodash_1 = require("lodash");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
class TelemetryService extends base_service_1.BaseService {
    async onBootstrap() {
        const userCount = await this.userRepository.getCount();
        this.telemetryRepository.api.addToGauge('immich.users.total', userCount);
    }
    onUserCreate() {
        this.telemetryRepository.api.addToGauge(`immich.users.total`, 1);
    }
    onUserTrash() {
        this.telemetryRepository.api.addToGauge(`immich.users.total`, -1);
    }
    onUserRestore() {
        this.telemetryRepository.api.addToGauge(`immich.users.total`, 1);
    }
    onJobStart(...[queueName]) {
        const queueMetric = `immich.queues.${(0, lodash_1.snakeCase)(queueName)}.active`;
        this.telemetryRepository.jobs.addToGauge(queueMetric, 1);
    }
    onJobSuccess({ job, response }) {
        if (response && Object.values(enum_1.JobStatus).includes(response)) {
            const jobMetric = `immich.jobs.${(0, lodash_1.snakeCase)(job.name)}.${response}`;
            this.telemetryRepository.jobs.addToCounter(jobMetric, 1);
        }
    }
    onJobError({ job }) {
        const jobMetric = `immich.jobs.${(0, lodash_1.snakeCase)(job.name)}.${enum_1.JobStatus.Failed}`;
        this.telemetryRepository.jobs.addToCounter(jobMetric, 1);
    }
    onJobComplete(...[queueName]) {
        const queueMetric = `immich.queues.${(0, lodash_1.snakeCase)(queueName)}.active`;
        this.telemetryRepository.jobs.addToGauge(queueMetric, -1);
    }
    onQueueStart({ name }) {
        this.telemetryRepository.jobs.addToCounter(`immich.queues.${(0, lodash_1.snakeCase)(name)}.started`, 1);
    }
}
exports.TelemetryService = TelemetryService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'AppBootstrap', workers: [enum_1.ImmichWorker.Api] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TelemetryService.prototype, "onBootstrap", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'UserCreate' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onUserCreate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'UserTrash' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onUserTrash", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'UserRestore' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onUserRestore", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'JobStart' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onJobStart", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'JobSuccess' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onJobSuccess", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'JobError' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onJobError", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'JobComplete' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onJobComplete", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'QueueStart' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], TelemetryService.prototype, "onQueueStart", null);
//# sourceMappingURL=telemetry.service.js.map