import { BaseContext } from 'src/sql-tools/contexts/base-context';
import { ColumnOptions } from 'src/sql-tools/decorators/column.decorator';
import { TableOptions } from 'src/sql-tools/decorators/table.decorator';
import { DatabaseColumn, DatabaseTable, SchemaFromCodeOptions } from 'src/sql-tools/types';
type TableMetadata = {
    options: TableOptions;
    object: Function;
    methodToColumn: Map<string | symbol, DatabaseColumn>;
};
export declare class ProcessorContext extends BaseContext {
    options: SchemaFromCodeOptions;
    constructor(options: SchemaFromCodeOptions);
    classToTable: WeakMap<Function, DatabaseTable>;
    tableToMetadata: WeakMap<DatabaseTable, TableMetadata>;
    getTableByObject(object: Function): DatabaseTable | undefined;
    getTableMetadata(table: DatabaseTable): TableMetadata;
    addTable(table: DatabaseTable, options: TableOptions, object: Function): void;
    getColumnByObjectAndPropertyName(object: object, propertyName: string | symbol): {
        table?: DatabaseTable;
        column?: DatabaseColumn;
    };
    addColumn(table: DatabaseTable, column: DatabaseColumn, options: ColumnOptions, propertyName: string | symbol): void;
    warnMissingTable(context: string, object: object, propertyName?: symbol | string): void;
    warnMissingColumn(context: string, object: object, propertyName?: symbol | string): void;
}
export {};
