"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessorContext = void 0;
const base_context_1 = require("./base-context");
class ProcessorContext extends base_context_1.BaseContext {
    options;
    constructor(options) {
        options.createForeignKeyIndexes = options.createForeignKeyIndexes ?? true;
        options.overrides = options.overrides ?? false;
        super(options);
        this.options = options;
    }
    classToTable = new WeakMap();
    tableToMetadata = new WeakMap();
    getTableByObject(object) {
        return this.classToTable.get(object);
    }
    getTableMetadata(table) {
        const metadata = this.tableToMetadata.get(table);
        if (!metadata) {
            throw new Error(`Table metadata not found for table: ${table.name}`);
        }
        return metadata;
    }
    addTable(table, options, object) {
        this.tables.push(table);
        this.classToTable.set(object, table);
        this.tableToMetadata.set(table, { options, object, methodToColumn: new Map() });
    }
    getColumnByObjectAndPropertyName(object, propertyName) {
        const table = this.getTableByObject(object.constructor);
        if (!table) {
            return {};
        }
        const tableMetadata = this.tableToMetadata.get(table);
        if (!tableMetadata) {
            return {};
        }
        const column = tableMetadata.methodToColumn.get(propertyName);
        return { table, column };
    }
    addColumn(table, column, options, propertyName) {
        table.columns.push(column);
        const tableMetadata = this.getTableMetadata(table);
        tableMetadata.methodToColumn.set(propertyName, column);
    }
    warnMissingTable(context, object, propertyName) {
        const label = object.constructor.name + (propertyName ? '.' + String(propertyName) : '');
        this.warn(context, `Unable to find table (${label})`);
    }
    warnMissingColumn(context, object, propertyName) {
        const label = object.constructor.name + (propertyName ? '.' + String(propertyName) : '');
        this.warn(context, `Unable to find column (${label})`);
    }
}
exports.ProcessorContext = ProcessorContext;
//# sourceMappingURL=processor-context.js.map