"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readExtensions = void 0;
const readExtensions = async (ctx, db) => {
    const extensions = await db
        .selectFrom('pg_catalog.pg_extension')
        .select(['extname as name', 'extversion as version'])
        .execute();
    for (const { name } of extensions) {
        ctx.extensions.push({ name, synchronize: true });
    }
};
exports.readExtensions = readExtensions;
//# sourceMappingURL=extension.reader.js.map