export type JSONSchemaType = 'string' | 'number' | 'integer' | 'boolean' | 'object' | 'array' | 'null';
export interface JSONSchemaProperty {
    type?: JSONSchemaType | JSONSchemaType[];
    description?: string;
    default?: any;
    enum?: any[];
    items?: JSONSchemaProperty;
    properties?: Record<string, JSONSchemaProperty>;
    required?: string[];
    additionalProperties?: boolean | JSONSchemaProperty;
}
export interface JSONSchema {
    type: 'object';
    properties?: Record<string, JSONSchemaProperty>;
    required?: string[];
    additionalProperties?: boolean;
    description?: string;
}
export type ConfigValue = string | number | boolean | null | ConfigValue[] | {
    [key: string]: ConfigValue;
};
export interface FilterConfig {
    [key: string]: ConfigValue;
}
export interface ActionConfig {
    [key: string]: ConfigValue;
}
