import { LogLevel, MemoryOptions, type PluginConfig, PluginOutput, LogLevelPriority } from './interfaces.ts';
export declare const BEGIN: unique symbol;
export declare const END: unique symbol;
export declare const ENV: unique symbol;
export declare const SET_HOST_CONTEXT: unique symbol;
export declare const GET_BLOCK: unique symbol;
export declare const IMPORT_STATE: unique symbol;
export declare const EXPORT_STATE: unique symbol;
export declare const STORE: unique symbol;
export declare const RESET: unique symbol;
export declare class Block {
    buffer: ArrayBufferLike;
    view: DataView;
    local: boolean;
    get byteLength(): number;
    constructor(arrayBuffer: ArrayBufferLike, local: boolean);
    static indexToAddress(idx: bigint | number): bigint;
    static addressToIndex(addr: bigint | number): number;
    static maskAddress(addr: bigint | number): number;
}
export type CallState = {
    blocks: [ArrayBufferLike | null, number][];
    stack: [number | null, number | null, number | null][];
};
export declare class CallContext {
    #private;
    /** @hidden */
    constructor(type: {
        new (size: number): ArrayBufferLike;
    }, logger: Console, logLevel: LogLevelPriority, config: PluginConfig, memoryOptions: MemoryOptions);
    hostContext<T = any>(): T;
    /**
     * Allocate a chunk of host memory visible to plugins via other extism host functions.
     * Returns the start address of the block.
     */
    alloc(size: bigint | number): bigint;
    /**
     * Read a variable from extism memory by name.
     *
     * @returns {@link PluginOutput}
     */
    getVariable(name: string): PluginOutput | null;
    /**
     * Set a variable to a given string or byte array value.
     */
    setVariable(name: string, value: string | Uint8Array): void;
    /**
     * Delete a variable if present.
     */
    deleteVariable(name: string): void;
    /**
     * Given an address in extism memory, return a {@link PluginOutput} that represents
     * a view of that memory. Returns null if the address is invalid.
     *
     * @returns bigint
     */
    read(addr: bigint | number): PluginOutput | null;
    /**
     * Store a string or Uint8Array value in extism memory.
     *
     * @returns bigint
     */
    store(input: string | Uint8Array): bigint;
    length(addr: bigint): bigint;
    setError(err?: string | Error | null): void;
    get logLevel(): LogLevel;
    set logLevel(v: LogLevel);
    /** @hidden */
    [ENV]: Record<string, CallableFunction>;
    /** @hidden */
    [RESET](): void;
    /** @hidden */
    [GET_BLOCK](index: number): Block;
    /** @hidden */
    [IMPORT_STATE](state: CallState, copy?: boolean): void;
    /** @hidden */
    [EXPORT_STATE](): CallState;
    /** @hidden */
    [STORE](input?: string | Uint8Array): number | null;
    /** @hidden */
    [SET_HOST_CONTEXT](hostContext: any): void;
    /** @hidden */
    [BEGIN](input: number | null): void;
    /** @hidden */
    [END](): [number | null, number | null];
}
