"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryEach = tryEach;
exports.cleanError = cleanError;
exports.asError = asError;
const String_1 = require("./String");
/**
 * When we wrap errors, an Error always prefixes the toString() and stack with
 * "Error: ", so we can remove that prefix.
 */
function tryEach(arr) {
    for (const f of arr) {
        try {
            f();
        }
        catch {
            //
        }
    }
}
function cleanError(s) {
    return String(s)
        .trim()
        .replace(/^error: /i, "");
}
function asError(err) {
    return err instanceof Error
        ? err
        : new Error((0, String_1.toNotBlank)(err != null && typeof err === "object" && "message" in err
            ? err?.message
            : undefined) ??
            (0, String_1.toNotBlank)(err) ??
            "(unknown)");
}
//# sourceMappingURL=Error.js.map