"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retryOnReject = retryOnReject;
function retryOnReject(f, maxRetries) {
    let retries = 0;
    const g = async () => {
        try {
            return await f();
        }
        catch (err) {
            if (retries < maxRetries) {
                retries++;
                return g();
            }
            else {
                throw err;
            }
        }
    };
    return g();
}
//# sourceMappingURL=AsyncRetry.js.map