"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isString = isString;
exports.blank = blank;
exports.notBlank = notBlank;
exports.notBlankString = notBlankString;
exports.toNotBlank = toNotBlank;
exports.compactBlanks = compactBlanks;
exports.toS = toS;
exports.leftPad = leftPad;
exports.pad2 = pad2;
exports.pad3 = pad3;
exports.stripPrefix = stripPrefix;
exports.stripSuffix = stripSuffix;
exports.splitLines = splitLines;
const Number_1 = require("./Number");
function isString(o) {
    return typeof o === "string";
}
function blank(s) {
    return s == null || String(s).trim().length === 0;
}
function notBlank(s) {
    return !blank(s);
}
/**
 * @returns true iff `s` is a string with at least one non-whitespace character.
 */
function notBlankString(s) {
    return isString(s) && s.trim().length > 0;
}
function toNotBlank(s) {
    if (s == null)
        return;
    s = String(s).trim();
    return s.length === 0 ? undefined : s;
}
function compactBlanks(arr) {
    return arr.filter(notBlank);
}
function padding(padChar, count) {
    return count <= 0 ? "" : padChar.repeat(count);
}
function toS(s) {
    return s == null ? "" : String(s);
}
function leftPad(i, minLen, padChar) {
    if (i == null || ((0, Number_1.isNumber)(i) && isNaN(i)))
        i = 0;
    const s = String(i);
    if ((0, Number_1.isNumber)(i) && i < 0 && padChar === "0") {
        // avoid "000-1":
        return "-" + padding(padChar, minLen - s.length) + Math.abs(i);
    }
    else {
        return padding(padChar, minLen - s.length) + s;
    }
}
function pad2(...numbers) {
    return numbers.map((i) => leftPad(i, 2, "0"));
}
function pad3(...numbers) {
    return numbers.map((i) => leftPad(i, 3, "0"));
}
/**
 * NOT FOR GENERAL USE, as this is latin-case-insensitive
 */
function stripPrefix(s, prefix) {
    return toS(s).toLowerCase().startsWith(prefix.toLowerCase())
        ? s.slice(prefix.length)
        : s;
}
function stripSuffix(s, suffix) {
    const str = toS(s);
    return str.endsWith(suffix) ? str.slice(0, -suffix.length) : str;
}
/**
 * @returns `arr` with all empty strings removed and all non-empty strings trimmed.
 */
function splitLines(...arr) {
    return arr
        .join("\n")
        .split(/\r?\n/)
        .map((ea) => ea.trim())
        .filter((ea) => ea.length > 0);
}
//# sourceMappingURL=String.js.map