"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var ClsModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsModule = void 0;
const common_1 = require("@nestjs/common");
const cls_plugin_manager_1 = require("../plugin/cls-plugin-manager");
const proxy_provider_manager_1 = require("../proxy-provider/proxy-provider-manager");
const cls_common_module_1 = require("./cls-common.module");
const cls_root_module_1 = require("./cls-root.module");
/**
 * ClsModule is the main entry point for configuring the CLS module.
 */
let ClsModule = ClsModule_1 = class ClsModule {
    /**
     * Configures the CLS module for root.
     *
     * Provides the `ClsService` and registered Proxy Providers for injection.
     */
    static forRoot(options) {
        return {
            module: ClsModule_1,
            imports: [cls_root_module_1.ClsRootModule.forRoot(options)],
            global: options?.global,
        };
    }
    /**
     * Configures the CLS module in the root with asynchronously provided configuration.
     *
     * Provides the `ClsService` and registered Proxy Providers for injection.
     */
    static forRootAsync(asyncOptions) {
        return {
            module: ClsModule_1,
            imports: [cls_root_module_1.ClsRootModule.forRootAsync(asyncOptions)],
            global: asyncOptions?.global,
        };
    }
    static forFeature(...proxyProviderClasses) {
        const proxyProviders = cls_root_module_1.ClsRootModule.createProxyClassProviders(proxyProviderClasses);
        return {
            module: ClsModule_1,
            providers: proxyProviders,
            exports: proxyProviders.map((p) => p.provide),
        };
    }
    /**
     * Registers the given Class or Factory proxy providers in the module along with `ClsService`.
     *
     * If used with `global: true`, makes the proxy provider available globally.
     */
    static forFeatureAsync(options) {
        const proxyProvider = proxy_provider_manager_1.ProxyProviderManager.createProxyProvider(options);
        const providers = [...(options.extraProviders ?? [])];
        return {
            module: ClsModule_1,
            imports: options.imports ?? [],
            providers: [...providers, proxyProvider],
            exports: [proxyProvider.provide],
            global: options.global,
        };
    }
    /**
     * Registers the given Plugins the module along with `ClsService`.
     */
    static registerPlugins(plugins) {
        return {
            module: ClsModule_1,
            imports: cls_plugin_manager_1.ClsPluginManager.registerPlugins(plugins),
        };
    }
};
exports.ClsModule = ClsModule;
exports.ClsModule = ClsModule = ClsModule_1 = __decorate([
    (0, common_1.Module)({
        imports: [cls_common_module_1.ClsCommonModule],
        exports: [cls_common_module_1.ClsCommonModule],
    })
], ClsModule);
//# sourceMappingURL=cls.module.js.map