"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsDecoratorOptions = exports.ClsInterceptorOptions = exports.ClsGuardOptions = exports.ClsMiddlewareOptions = exports.ClsInitializerCommonOptions = exports.ClsContextOptions = exports.ClsModuleOptions = void 0;
const getRandomString = () => Math.random().toString(36).slice(-8);
class ClsModuleOptions {
    constructor() {
        /**
         * whether to make the module global, so you don't need
         * to import ClsModule.forFeature()` in other modules
         */
        this.global = false;
    }
}
exports.ClsModuleOptions = ClsModuleOptions;
class ClsContextOptions {
    constructor() {
        /**
         * Sets the behavior of nested CLS context creation. Has no effect if no parent context exists.
         *
         * `inherit` (default) - Run the callback with a shallow copy of the parent context.
         * Assignments to top-level properties will not be reflected in the parent context.
         *
         * `reuse` - Reuse existing context without creating a new one.
         *
         * `override` - Run the callback with an new empty context.
         * Warning: No values from the parent context will be accessible.
         */
        this.ifNested = 'inherit';
    }
}
exports.ClsContextOptions = ClsContextOptions;
class ClsInitializerCommonOptions {
    constructor() {
        /**
         * whether to automatically generate request ids
         *
         * Default: `false`
         */
        this.generateId = false;
        /**
         * Whether to resolve proxy providers as a part
         * of the CLS context registration
         *
         * Default: `true`
         */
        this.resolveProxyProviders = true;
        /**
         * Whether to run the initialization hooks for plugins as a part
         * of the CLS context registration in this initializer
         *
         * Default: `true`
         */
        this.initializePlugins = true;
    }
}
exports.ClsInitializerCommonOptions = ClsInitializerCommonOptions;
class ClsMiddlewareOptions extends ClsInitializerCommonOptions {
    constructor() {
        super(...arguments);
        /**
         * whether to mount the middleware to every route
         *
         * Default: `false`
         */
        this.mount = false;
        /**
         * the function to generate request ids for the CLS context
         */
        this.idGenerator = getRandomString;
        /**
         * Whether to store the Request object to the CLS
         * It will be available under the CLS_REQ key
         */
        this.saveReq = true;
        /**
         * Whether to store the Response object to the CLS
         * It will be available under the CLS_RES key
         */
        this.saveRes = false;
        /**
         * Set to true to set up the context using a call to
         * `AsyncLocalStorage#enterWith` instead of wrapping the
         * `next()` call with the safer `AsyncLocalStorage#run`
         *
         * Most of the time this should not be necessary, but
         * some frameworks are known to lose the context wih `run`.
         */
        this.useEnterWith = false;
    }
}
exports.ClsMiddlewareOptions = ClsMiddlewareOptions;
class ClsGuardOptions extends ClsInitializerCommonOptions {
    constructor() {
        super(...arguments);
        /**
         * whether to mount the guard globally
         *
         * Default: `false`
         */
        this.mount = false;
        /**
         * the function to generate request ids inside the guard
         */
        this.idGenerator = getRandomString;
        /**
         * Whether to store the ExecutionContext object to the CLS
         * It will be available under the CLS_CTX key
         *
         * Default: `true`
         */
        this.saveCtx = true;
    }
}
exports.ClsGuardOptions = ClsGuardOptions;
class ClsInterceptorOptions extends ClsInitializerCommonOptions {
    constructor() {
        super(...arguments);
        /**
         * whether to mount the interceptor globally
         *
         * Default: `false`
         */
        this.mount = false;
        /**
         * the function to generate request ids inside the interceptor
         */
        this.idGenerator = getRandomString;
        /**
         * Whether to store the ExecutionContext object to the CLS
         * It will be available under the CLS_CTX key
         *
         * Default: `true`
         */
        this.saveCtx = true;
    }
}
exports.ClsInterceptorOptions = ClsInterceptorOptions;
class ClsDecoratorOptions extends ClsInitializerCommonOptions {
    constructor() {
        super(...arguments);
        /**
         * The function to generate request ids inside the interceptor.
         *
         * Takes the same parameters in the same order as the decorated function.
         *
         * If you use a `function` expression, it will executed with the `this` context of the decorated class instance.
         * to get type safety, use:
         *
         * `idGenerator: function (this: MyClass, ...args) { ... }`
         *
         * Note: To avoid type errors, you must list all parameters, even if they're not used,
         * or type the decorator as:
         *
         * `@UseCls<[arg1: Type1, arg2: Type2]>()`
         */
        this.idGenerator = getRandomString;
    }
}
exports.ClsDecoratorOptions = ClsDecoratorOptions;
//# sourceMappingURL=cls.options.js.map