"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValueFromPath = getValueFromPath;
exports.setValueFromPath = setValueFromPath;
function getValueFromPath(obj, path) {
    const pathSegments = path.split('.');
    return pathSegments.reduce((acc, curr) => acc?.[curr], obj);
}
function setValueFromPath(obj, path, value) {
    const pathSegments = path.split('.');
    const leaf = pathSegments.slice(0, -1).reduce((acc, curr) => {
        acc[curr] ?? (acc[curr] = {});
        return acc[curr];
    }, obj ?? {});
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    leaf[pathSegments.at(-1)] = value;
    return obj;
}
//# sourceMappingURL=value-from-path.js.map