[ -n "${JQ_SH-}" ] && return

# shellcheck disable=SC2034
readonly JQ_SH='1.0.1'

jq_get() (
    if [ -t 0 ] || input="$(ifne sh -c "cat && exit 1")"; then
        input="${1:?"jq_get requires at least one argument when no data is supplied via stdin"}"
        shift
    fi
    printf '%s' "$input" | "${JQ:-jq}" "$@"
)

readonly JQ_READ_NO_FILE=101
readonly JQ_READ_ERROR=102
jq_read() {
    if [ -f "${1:?"jq_read requires at least one argument"}" ]; then
        if ! "${JQ:-jq}" < "$1"; then
            return "$JQ_READ_ERROR"
        fi
    else
        return "$JQ_READ_NO_FILE"
    fi
}

jq_test() {
    jq_get "$@" | jq -e > /dev/null
}

jq_seq() {
    jq_get "$@" | jq 'range(length)'
}

jq_merge() {
    {
        if [ -t 0 ] || ifne sh -c "cat && exit 1"; then
            : "${1:?"jq_merge requires at least one argument when no data is supplied via stdin"}"
        fi
        while [ $# -gt 0 ]; do
            jq_get "$1"
            shift
        done
    } | jq -s 'reduce .[] as $item ({}; . * $item)'
}

jq_eval() {
    eval "$(jq_get "$@" | jq -r '@sh')"
}

eval "$(jq -nr '
    reduce ("yq", "xq", "tomlq") as $cmd ("";
        . + reduce ("get", "read", "test", "seq", "merge", "eval") as $name ("if command -v \($cmd) > /dev/null; then ";
            . + "\($cmd)_\($name)() { JQ=\($cmd) jq_\($name) \"$@\"; }; "
        ) + "fi; "
    )
')"

eval "$(jq -nr '
    reduce ("jq", "yq", "xq", "tomlq") as $in ("";
        . + reduce ((["jq"], ["yq", "-y"], ["tomlq", "-t"]) | select(.[0] != $in)) as $out ("if command -v \($in) > /dev/null; then ";
            . + "if command -v \($out[0]) > /dev/null; then \($in)_to_\($out[0])() { \($out | @sh) -n --argjson in \"$(\($in)_get \"${1-}\")\" '\''$in'\''; }; fi; "
        ) + "fi; "
    )
')"
