/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.model;

import com.ibm.icu.util.ULocale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u000f\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R)\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/gotson/komga/domain/model/BCP47TagValidator;", "", "<init>", "()V", "languages", "", "", "kotlin.jvm.PlatformType", "getLanguages", "()Ljava/util/Set;", "languages$delegate", "Lkotlin/Lazy;", "isValid", "", "value", "normalize", "komga"})
public final class BCP47TagValidator {
    @NotNull
    public static final BCP47TagValidator INSTANCE = new BCP47TagValidator();
    @NotNull
    private static final Lazy languages$delegate = LazyKt.lazy(BCP47TagValidator::languages_delegate$lambda$0);

    private BCP47TagValidator() {
    }

    private final Set<String> getLanguages() {
        Lazy lazy = languages$delegate;
        return (Set)lazy.getValue();
    }

    public final boolean isValid(@Nullable String value) {
        if (value == null) {
            return false;
        }
        ULocale it = ULocale.forLanguageTag((String)value);
        boolean bl = false;
        String string = it.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        return !StringsKt.isBlank((CharSequence)string) && INSTANCE.getLanguages().contains(it.getLanguage());
    }

    @NotNull
    public final String normalize(@Nullable String value) {
        CharSequence charSequence = value;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "";
        }
        try {
            charSequence = ULocale.forLanguageTag((String)value).toLanguageTag();
            Intrinsics.checkNotNull((Object)charSequence);
        }
        catch (Exception e) {
            charSequence = "";
        }
        return charSequence;
    }

    private static final Set languages_delegate$lambda$0() {
        String[] stringArray = ULocale.getISOLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getISOLanguages(...)");
        return ArraysKt.toSet((Object[])stringArray);
    }
}

