/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookAction;
import org.gotson.komga.domain.model.BookConversionException;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookPageKt;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookPageEditorKt;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J \u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gotson/komga/domain/service/BookPageEditor;", "", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "pageHashRepository", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "<init>", "(Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/PageHashRepository;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;)V", "convertibleTypes", "", "", "failedPageRemoval", "", "removeHashedPages", "Lorg/gotson/komga/domain/model/BookAction;", "book", "Lorg/gotson/komga/domain/model/Book;", "pagesToDelete", "", "Lorg/gotson/komga/domain/model/BookPageNumbered;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookPageEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookPageEditor.kt\norg/gotson/komga/domain/service/BookPageEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n785#2:181\n796#2:182\n1878#2,2:183\n797#2,2:185\n1880#2:187\n799#2:188\n1563#2:189\n1634#2,3:190\n1563#2:193\n1634#2,3:194\n1869#2,2:197\n1563#2:199\n1634#2,3:200\n1563#2:203\n1634#2,3:204\n1563#2:207\n1634#2,3:208\n1563#2:211\n1634#2,3:212\n1869#2,2:215\n1761#2,3:217\n1617#2,9:220\n1869#2:229\n1870#2:231\n1626#2:232\n1869#2,2:233\n1#3:230\n*S KotlinDebug\n*F\n+ 1 BookPageEditor.kt\norg/gotson/komga/domain/service/BookPageEditor\n*L\n82#1:181\n82#1:182\n82#1:183,2\n82#1:185,2\n82#1:187\n82#1:188\n107#1:189\n107#1:190,3\n108#1:193\n108#1:194,3\n109#1:197,2\n138#1:199\n138#1:200,3\n139#1:203\n139#1:204,3\n143#1:207\n143#1:208,3\n144#1:211\n144#1:212,3\n174#1:215,2\n177#1:217,3\n170#1:220,9\n170#1:229\n170#1:231\n170#1:232\n171#1:233,2\n170#1:230\n*E\n"})
public class BookPageEditor {
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final PageHashRepository pageHashRepository;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final List<String> convertibleTypes;
    @NotNull
    private final List<String> failedPageRemoval;

    public BookPageEditor(@NotNull BookAnalyzer bookAnalyzer, @NotNull FileSystemScanner fileSystemScanner, @NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull LibraryRepository libraryRepository, @NotNull PageHashRepository pageHashRepository, @NotNull TransactionTemplate transactionTemplate, @NotNull ApplicationEventPublisher eventPublisher, @NotNull HistoricalEventRepository historicalEventRepository) {
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)pageHashRepository, (String)"pageHashRepository");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        this.bookAnalyzer = bookAnalyzer;
        this.fileSystemScanner = fileSystemScanner;
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.libraryRepository = libraryRepository;
        this.pageHashRepository = pageHashRepository;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.historicalEventRepository = historicalEventRepository;
        this.convertibleTypes = CollectionsKt.listOf((Object)MediaType.ZIP.getType());
        this.failedPageRemoval = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public BookAction removeHashedPages(@NotNull Book book, @NotNull Collection<BookPageNumbered> pagesToDelete) {
        boolean bl;
        block36: {
            Iterable $this$mapTo$iv$iv;
            CopyOption[] destination$iv$iv;
            Iterable $this$forEach$iv;
            Object zipStream;
            Throwable $this$filterIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter(pagesToDelete, (String)"pagesToDelete");
            if (this.failedPageRemoval.contains(book.getId())) {
                BookPageEditorKt.access$getLogger$p().info(BookPageEditor::removeHashedPages$lambda$0);
                return null;
            }
            Book book2 = this.fileSystemScanner.scanFile(book.getPath());
            if (book2 != null) {
                Book scannedBook = book2;
                boolean bl2 = false;
                if (LanguageUtilsKt.notEquals$default((LocalDateTime)scannedBook.getFileLastModified(), (LocalDateTime)book.getFileLastModified(), null, (int)2, null)) {
                    BookPageEditorKt.access$getLogger$p().info(() -> BookPageEditor.removeHashedPages$lambda$2$lambda$1(book, scannedBook));
                    return null;
                }
            } else {
                throw new FileNotFoundException("File not found: " + book.getPath());
            }
            Media media = this.mediaRepository.findById(book.getId());
            if (!CollectionsKt.contains((Iterable)this.convertibleTypes, (Object)media.getMediaType())) {
                throw new MediaUnsupportedException(media.getMediaType() + " cannot be converted. Must be one of " + this.convertibleTypes, null, 2, null);
            }
            if (media.getStatus() != Media.Status.READY) {
                throw new MediaNotReadyException();
            }
            Iterable $this$filterIndexed$iv = media.getPages();
            boolean $i$f$filterIndexed22 = false;
            Iterable bl2 = $this$filterIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            Iterable $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Object v1;
                void element$iv$iv;
                block34: {
                    int n;
                    if ((n = index$iv$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl3 = false;
                    BookPage bookPage = (BookPage)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl4 = false;
                    Iterable iterable = pagesToDelete;
                    for (Object t2 : iterable) {
                        void page;
                        BookPageNumbered candidate = (BookPageNumbered)t2;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual((Object)candidate.getFileHash(), (Object)page.getFileHash()) && Intrinsics.areEqual((Object)candidate.getMediaType(), (Object)page.getMediaType()) && Intrinsics.areEqual((Object)candidate.getFileName(), (Object)page.getFileName()) && candidate.getPageNumber() == index + 1)) continue;
                        v1 = t2;
                        break block34;
                    }
                    v1 = null;
                }
                boolean bl6 = v1 == null;
                if (!bl6) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List pagesToKeep = (List)destination$iv$iv2;
            if (media.getPages().size() != pagesToKeep.size() + pagesToDelete.size()) {
                BookPageEditorKt.access$getLogger$p().info(() -> BookPageEditor.removeHashedPages$lambda$5(pagesToDelete));
                return null;
            }
            BookPageEditorKt.access$getLogger$p().info(() -> BookPageEditor.removeHashedPages$lambda$6(pagesToDelete, book));
            BookPageEditorKt.access$getLogger$p().debug(() -> BookPageEditor.removeHashedPages$lambda$7(media));
            BookPageEditorKt.access$getLogger$p().debug(() -> BookPageEditor.removeHashedPages$lambda$8(pagesToDelete));
            BookPageEditorKt.access$getLogger$p().debug(() -> BookPageEditor.removeHashedPages$lambda$9(pagesToKeep));
            Path tempFile = File.createTempFile("komga_page_removal_", ".tmp", book.getPath().getParent().toFile()).toPath();
            BookPageEditorKt.access$getLogger$p().info(() -> BookPageEditor.removeHashedPages$lambda$10(tempFile));
            Intrinsics.checkNotNull((Object)tempFile);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(tempFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable $i$f$filterIndexed22 = (Closeable)new ZipArchiveOutputStream(outputStream);
            $this$filterIndexedTo$iv$iv = null;
            try {
                Object item$iv$iv;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                zipStream = (ZipArchiveOutputStream)$i$f$filterIndexed22;
                boolean bl7 = false;
                zipStream.setMethod(8);
                zipStream.setLevel(0);
                $this$forEachIndexed$iv$iv$iv = pagesToKeep;
                boolean $i$f$map = false;
                void index$iv$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    item$iv$iv = iterator.next();
                    BookPage index$iv$iv = (BookPage)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    collection.add(it.getFileName());
                }
                $this$map$iv = media.getFiles();
                Iterable iterable = (List)destination$iv$iv3;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    MediaFile it = (MediaFile)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl9 = false;
                    collection.add(it.getFileName());
                }
                $this$map$iv = CollectionsKt.union((Iterable)iterable, (Iterable)((List)destination$iv$iv3));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String entry = (String)element$iv;
                    boolean bl10 = false;
                    zipStream.putArchiveEntry(new ZipArchiveEntry(entry));
                    zipStream.write(this.bookAnalyzer.getFileContent(new BookWithMedia(book, media), entry));
                    zipStream.closeArchiveEntry();
                }
                zipStream = Unit.INSTANCE;
            }
            catch (Throwable bl7) {
                $this$filterIndexedTo$iv$iv = bl7;
                throw bl7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$filterIndexed22, (Throwable)$this$filterIndexedTo$iv$iv);
            }
            $this$filterIndexedTo$iv$iv = this.fileSystemScanner.scanFile(tempFile);
            if ($this$filterIndexedTo$iv$iv == null || (zipStream = Book.copy$default((Book)$this$filterIndexedTo$iv$iv, null, null, null, (long)0L, null, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)15487, null)) == null) {
                throw new IllegalStateException("Newly created book could not be scanned: " + tempFile);
            }
            ZipArchiveOutputStream createdBook = zipStream;
            Media createdMedia = this.bookAnalyzer.analyze((Book)createdBook, this.libraryRepository.findById(book.getLibraryId()).getAnalyzeDimensions());
            try {
                CopyOption[] copyOptionArray;
                Collection<String> collection;
                Iterable $this$map$iv;
                if (createdMedia.getStatus() != Media.Status.READY) {
                    throw new BookConversionException("Created file could not be analyzed, aborting page removal");
                }
                if (!Intrinsics.areEqual((Object)createdMedia.getMediaType(), (Object)MediaType.ZIP.getType())) {
                    throw new BookConversionException("Created file is not a zip file, aborting page removal");
                }
                zipStream = createdMedia.getPages();
                boolean $i$f$map = false;
                $this$forEach$iv = $this$map$iv;
                destination$iv$iv = (CopyOption[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BookPage bl10 = (BookPage)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl11 = false;
                    collection.add((String)TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
                }
                $this$map$iv = pagesToKeep;
                collection = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    BookPage it = (BookPage)item$iv$iv;
                    copyOptionArray = destination$iv$iv;
                    boolean bl12 = false;
                    copyOptionArray.add(TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
                }
                if (!collection.containsAll((List)destination$iv$iv)) {
                    throw new BookConversionException("Created file does not contain all pages to keep from existing file, aborting conversion");
                }
                $this$map$iv = createdMedia.getFiles();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MediaFile it = (MediaFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl13 = false;
                    collection.add(FilenameUtils.getName((String)it.getFileName()));
                }
                $this$map$iv = media.getFiles();
                collection = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MediaFile it = (MediaFile)item$iv$iv;
                    copyOptionArray = destination$iv$iv;
                    boolean bl14 = false;
                    copyOptionArray.add(FilenameUtils.getName((String)it.getFileName()));
                }
                if (!collection.containsAll((List)destination$iv$iv)) {
                    throw new BookConversionException("Created file does not contain all files from existing file, aborting page removal");
                }
            }
            catch (BookConversionException e) {
                Files.deleteIfExists(tempFile);
                ((Collection)this.failedPageRemoval).add(book.getId());
                throw e;
            }
            Path e = tempFile;
            Path $i$f$map = book.getPath();
            destination$iv$iv = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray = destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(e, $i$f$map, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
            $i$f$map = this.fileSystemScanner.scanFile(book.getPath());
            if ($i$f$map == null || ($this$mapTo$iv$iv = Book.copy$default((Book)$i$f$map, null, null, null, (long)0L, null, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)15487, null)) == null) {
                throw new IllegalStateException("Newly created book could not be scanned after replacing existing one: " + book.getPath());
            }
            Iterable newBook = $this$mapTo$iv$iv;
            Media mediaWithHashes = Media.copy$default((Media)createdMedia, null, null, (List)BookPageKt.restoreHashFrom((Collection)createdMedia.getPages(), (Collection)media.getPages()), (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4091, null);
            this.transactionTemplate.executeWithoutResult(arg_0 -> BookPageEditor.removeHashedPages$lambda$21(this, (Book)newBook, mediaWithHashes, pagesToDelete, arg_0));
            $this$forEach$iv = pagesToDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookPageNumbered it = (BookPageNumbered)element$iv;
                boolean bl15 = false;
                this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.DuplicatePageDeleted(book, it));
            }
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated((Book)newBook));
            Iterable $this$any$iv = pagesToDelete;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BookPageNumbered it = (BookPageNumbered)element$iv;
                    boolean bl16 = false;
                    if (!(it.getPageNumber() == 1)) continue;
                    bl = true;
                    break block36;
                }
                bl = false;
            }
        }
        return bl ? BookAction.GENERATE_THUMBNAIL : null;
    }

    private static final Object removeHashedPages$lambda$0() {
        return "Book page removal already failed before, skipping";
    }

    private static final Object removeHashedPages$lambda$2$lambda$1(Book $book, Book $scannedBook) {
        return "Book has changed on disk, skipping. Db: " + $book.getFileLastModified() + ". Scanned: " + $scannedBook.getFileLastModified();
    }

    private static final Object removeHashedPages$lambda$5(Collection $pagesToDelete) {
        return "Should be removing " + $pagesToDelete.size() + " pages from book, but count doesn't add up, skipping";
    }

    private static final Object removeHashedPages$lambda$6(Collection $pagesToDelete, Book $book) {
        return "Start removal of " + $pagesToDelete.size() + " pages for book: " + $book;
    }

    private static final Object removeHashedPages$lambda$7(Media $media) {
        return "Pages: " + $media.getPages();
    }

    private static final Object removeHashedPages$lambda$8(Collection $pagesToDelete) {
        return "Pages to delete: " + $pagesToDelete;
    }

    private static final Object removeHashedPages$lambda$9(List $pagesToKeep) {
        return "Pages to keep: " + $pagesToKeep;
    }

    private static final Object removeHashedPages$lambda$10(Path $tempFile) {
        return "Creating new file: " + $tempFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeHashedPages$lambda$21(BookPageEditor this$0, Book $newBook, Media $mediaWithHashes, Collection $pagesToDelete, TransactionStatus it) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        this$0.bookRepository.update($newBook);
        this$0.mediaRepository.update($mediaWithHashes);
        Iterable iterable = $pagesToDelete;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PageHashKnown it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BookPageNumbered it2 = (BookPageNumbered)element$iv$iv;
            boolean bl2 = false;
            if (this$0.pageHashRepository.findKnown(it2.getFileHash()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PageHashKnown it3 = (PageHashKnown)element$iv;
            boolean bl = false;
            this$0.pageHashRepository.update(PageHashKnown.copy$default((PageHashKnown)it3, null, null, null, (int)(it3.getDeleteCount() + 1), (int)0, (int)23, null));
        }
    }
}

