/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.UserEmailAlreadyExistsException;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SyncPointRepository;
import org.gotson.komga.domain.service.KomgaUserLifecycleKt;
import org.gotson.komga.infrastructure.jooq.main.ClientSettingsDtoDao;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.security.TokenEncoder;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "authenticationActivityRepository", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "syncPointRepository", "Lorg/gotson/komga/domain/persistence/SyncPointRepository;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "tokenEncoder", "Lorg/gotson/komga/infrastructure/security/TokenEncoder;", "sessionRegistry", "Lorg/springframework/security/core/session/SessionRegistry;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "apiKeyGenerator", "Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyGenerator;", "clientSettingsDtoDao", "Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;", "<init>", "(Lorg/gotson/komga/domain/persistence/KomgaUserRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;Lorg/gotson/komga/domain/persistence/SyncPointRepository;Lorg/springframework/security/crypto/password/PasswordEncoder;Lorg/gotson/komga/infrastructure/security/TokenEncoder;Lorg/springframework/security/core/session/SessionRegistry;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyGenerator;Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;)V", "updatePassword", "", "user", "Lorg/gotson/komga/domain/model/KomgaUser;", "newPassword", "", "expireSessions", "", "updateUser", "countUsers", "", "createUser", "komgaUser", "deleteUser", "createApiKey", "Lorg/gotson/komga/domain/model/ApiKey;", "comment", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUserLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUserLifecycle.kt\norg/gotson/komga/domain/service/KomgaUserLifecycle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1#2:140\n1869#3,2:141\n*S KotlinDebug\n*F\n+ 1 KomgaUserLifecycle.kt\norg/gotson/komga/domain/service/KomgaUserLifecycle\n*L\n105#1:141,2\n*E\n"})
public class KomgaUserLifecycle {
    @NotNull
    private final KomgaUserRepository userRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final AuthenticationActivityRepository authenticationActivityRepository;
    @NotNull
    private final SyncPointRepository syncPointRepository;
    @NotNull
    private final PasswordEncoder passwordEncoder;
    @NotNull
    private final TokenEncoder tokenEncoder;
    @NotNull
    private final SessionRegistry sessionRegistry;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ApiKeyGenerator apiKeyGenerator;
    @NotNull
    private final ClientSettingsDtoDao clientSettingsDtoDao;

    public KomgaUserLifecycle(@NotNull KomgaUserRepository userRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull AuthenticationActivityRepository authenticationActivityRepository, @NotNull SyncPointRepository syncPointRepository, @NotNull PasswordEncoder passwordEncoder, @NotNull TokenEncoder tokenEncoder, @NotNull SessionRegistry sessionRegistry, @NotNull TransactionTemplate transactionTemplate, @NotNull ApplicationEventPublisher eventPublisher, @NotNull ApiKeyGenerator apiKeyGenerator, @NotNull ClientSettingsDtoDao clientSettingsDtoDao) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)authenticationActivityRepository, (String)"authenticationActivityRepository");
        Intrinsics.checkNotNullParameter((Object)syncPointRepository, (String)"syncPointRepository");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        Intrinsics.checkNotNullParameter((Object)tokenEncoder, (String)"tokenEncoder");
        Intrinsics.checkNotNullParameter((Object)sessionRegistry, (String)"sessionRegistry");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)apiKeyGenerator, (String)"apiKeyGenerator");
        Intrinsics.checkNotNullParameter((Object)clientSettingsDtoDao, (String)"clientSettingsDtoDao");
        this.userRepository = userRepository;
        this.readProgressRepository = readProgressRepository;
        this.authenticationActivityRepository = authenticationActivityRepository;
        this.syncPointRepository = syncPointRepository;
        this.passwordEncoder = passwordEncoder;
        this.tokenEncoder = tokenEncoder;
        this.sessionRegistry = sessionRegistry;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.apiKeyGenerator = apiKeyGenerator;
        this.clientSettingsDtoDao = clientSettingsDtoDao;
    }

    public void updatePassword(@NotNull KomgaUser user, @NotNull String newPassword, boolean expireSessions) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.updatePassword$lambda$0(user));
        String string = this.passwordEncoder.encode((CharSequence)newPassword);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        KomgaUser updatedUser = KomgaUser.copy$default((KomgaUser)user, null, (String)string, null, null, (boolean)false, null, null, null, null, (int)509, null);
        this.userRepository.update(updatedUser);
        if (expireSessions) {
            this.expireSessions(updatedUser);
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.UserUpdated(updatedUser, expireSessions));
    }

    public void updateUser(@NotNull KomgaUser user) {
        boolean expireSessions;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        KomgaUser existing = this.userRepository.findByIdOrNull(user.getId());
        if (existing == null) {
            boolean $i$a$-requireNotNull-KomgaUserLifecycle$updateUser$22 = false;
            String $i$a$-requireNotNull-KomgaUserLifecycle$updateUser$22 = "User doesn't exist, cannot update: " + user;
            throw new IllegalArgumentException($i$a$-requireNotNull-KomgaUserLifecycle$updateUser$22.toString());
        }
        KomgaUser toUpdate = KomgaUser.copy$default((KomgaUser)user, null, (String)existing.getPassword(), null, null, (boolean)false, null, null, null, null, (int)509, null);
        KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.updateUser$lambda$2(toUpdate));
        this.userRepository.update(toUpdate);
        boolean bl = expireSessions = !Intrinsics.areEqual((Object)existing.getRoles(), (Object)user.getRoles()) || !Intrinsics.areEqual((Object)existing.getRestrictions(), (Object)user.getRestrictions()) || existing.getSharedAllLibraries() != user.getSharedAllLibraries() || !Intrinsics.areEqual((Object)existing.getSharedLibrariesIds(), (Object)user.getSharedLibrariesIds());
        if (expireSessions) {
            this.expireSessions(toUpdate);
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.UserUpdated(toUpdate, expireSessions));
    }

    public long countUsers() {
        return this.userRepository.count();
    }

    @NotNull
    public KomgaUser createUser(@NotNull KomgaUser komgaUser) throws UserEmailAlreadyExistsException {
        Intrinsics.checkNotNullParameter((Object)komgaUser, (String)"komgaUser");
        if (this.userRepository.existsByEmailIgnoreCase(komgaUser.getEmail())) {
            throw new UserEmailAlreadyExistsException("A user with the same email already exists: " + komgaUser.getEmail(), null, 2, null);
        }
        String string = this.passwordEncoder.encode((CharSequence)komgaUser.getPassword());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        this.userRepository.insert(KomgaUser.copy$default((KomgaUser)komgaUser, null, (String)string, null, null, (boolean)false, null, null, null, null, (int)509, null));
        KomgaUser komgaUser2 = this.userRepository.findByIdOrNull(komgaUser.getId());
        Intrinsics.checkNotNull((Object)komgaUser2);
        KomgaUser createdUser = komgaUser2;
        KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.createUser$lambda$3(createdUser));
        return createdUser;
    }

    public void deleteUser(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.deleteUser$lambda$4(user));
        this.transactionTemplate.executeWithoutResult(arg_0 -> KomgaUserLifecycle.deleteUser$lambda$5(this, user, arg_0));
        this.expireSessions(user);
        this.eventPublisher.publishEvent((Object)new DomainEvent.UserUpdated(user, true));
    }

    public void expireSessions(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.expireSessions$lambda$6(user));
        List list = this.sessionRegistry.getAllSessions((Object)new KomgaPrincipal(user, null, null, null, null, 30, null), false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSessions(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SessionInformation it = (SessionInformation)element$iv;
            boolean bl = false;
            KomgaUserLifecycleKt.access$getLogger$p().info(() -> KomgaUserLifecycle.expireSessions$lambda$8$lambda$7(it));
            it.expireNow();
        }
    }

    @Nullable
    public ApiKey createApiKey(@NotNull KomgaUser user, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        String commentTrimmed = ((Object)StringsKt.trim((CharSequence)comment)).toString();
        if (this.userRepository.existsApiKeyByCommentAndUserId(commentTrimmed, user.getId())) {
            throw new DuplicateNameException("api key comment already exists for this user", "ERR_1034");
        }
        for (int attempt = 1; attempt < 11; ++attempt) {
            try {
                ApiKey plainTextKey = new ApiKey(null, user.getId(), this.apiKeyGenerator.generate(), commentTrimmed, null, null, 49, null);
                this.userRepository.insert(ApiKey.copy$default((ApiKey)plainTextKey, null, null, (String)this.tokenEncoder.encode(plainTextKey.getKey()), null, null, null, (int)59, null));
                return plainTextKey;
            }
            catch (Exception e) {
                KomgaUserLifecycleKt.access$getLogger$p().debug(() -> KomgaUserLifecycle.createApiKey$lambda$9(attempt));
                continue;
            }
        }
        return null;
    }

    private static final Object updatePassword$lambda$0(KomgaUser $user) {
        return "Changing password for user " + $user.getEmail();
    }

    private static final Object updateUser$lambda$2(KomgaUser $toUpdate) {
        return "Update user: " + $toUpdate;
    }

    private static final Object createUser$lambda$3(KomgaUser $createdUser) {
        return "User created: " + $createdUser;
    }

    private static final Object deleteUser$lambda$4(KomgaUser $user) {
        return "Deleting user: " + $user;
    }

    private static final void deleteUser$lambda$5(KomgaUserLifecycle this$0, KomgaUser $user, TransactionStatus it) {
        this$0.clientSettingsDtoDao.deleteByUserId($user.getId());
        this$0.readProgressRepository.deleteByUserId($user.getId());
        this$0.authenticationActivityRepository.deleteByUser($user);
        this$0.syncPointRepository.deleteByUserId($user.getId());
        this$0.userRepository.delete($user.getId());
    }

    private static final Object expireSessions$lambda$6(KomgaUser $user) {
        return "Expiring all sessions for user: " + $user.getEmail();
    }

    private static final Object expireSessions$lambda$8$lambda$7(SessionInformation $it) {
        return "Expiring session: " + $it.getSessionId();
    }

    private static final Object createApiKey$lambda$9(int $attempt) {
        return "Failed to generate unique api key, attempt #" + $attempt;
    }
}

