/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.domain.service.SeriesCollectionLifecycle;
import org.gotson.komga.domain.service.SeriesCollectionLifecycleKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.infrastructure.image.MosaicGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0017J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0019H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;", "", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "thumbnailSeriesCollectionRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "mosaicGenerator", "Lorg/gotson/komga/infrastructure/image/MosaicGenerator;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "<init>", "(Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/infrastructure/image/MosaicGenerator;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;)V", "addCollection", "Lorg/gotson/komga/domain/model/SeriesCollection;", "collection", "updateCollection", "", "toUpdate", "deleteCollection", "addSeriesToCollection", "collectionName", "", "series", "Lorg/gotson/komga/domain/model/Series;", "deleteEmptyCollections", "addThumbnail", "Lorg/gotson/komga/domain/model/ThumbnailSeriesCollection;", "thumbnail", "markSelectedThumbnail", "deleteThumbnail", "getThumbnailBytes", "", "thumbnailId", "userId", "thumbnailsHouseKeeping", "collectionId", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesCollectionLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesCollectionLifecycle.kt\norg/gotson/komga/domain/service/SeriesCollectionLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1869#2,2:176\n1617#2,9:178\n1869#2:187\n1870#2:189\n1626#2:190\n774#2:191\n865#2,2:192\n1563#2:194\n1634#2,3:195\n1563#2:198\n1634#2,3:199\n1#3:188\n*S KotlinDebug\n*F\n+ 1 SeriesCollectionLifecycle.kt\norg/gotson/komga/domain/service/SeriesCollectionLifecycle\n*L\n108#1:176,2\n154#1:178,9\n154#1:187\n154#1:189\n154#1:190\n162#1:191\n162#1:192,2\n104#1:194\n104#1:195,3\n105#1:198\n105#1:199,3\n154#1:188\n*E\n"})
public class SeriesCollectionLifecycle {
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final MosaicGenerator mosaicGenerator;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;

    public SeriesCollectionLifecycle(@NotNull SeriesCollectionRepository collectionRepository, @NotNull ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull MosaicGenerator mosaicGenerator, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesCollectionRepository, (String)"thumbnailSeriesCollectionRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)mosaicGenerator, (String)"mosaicGenerator");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        this.collectionRepository = collectionRepository;
        this.thumbnailSeriesCollectionRepository = thumbnailSeriesCollectionRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.mosaicGenerator = mosaicGenerator;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
    }

    @Transactional
    @NotNull
    public SeriesCollection addCollection(@NotNull SeriesCollection collection) throws DuplicateNameException {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        SeriesCollectionLifecycleKt.access$getLogger$p().info(() -> SeriesCollectionLifecycle.addCollection$lambda$0(collection));
        if (this.collectionRepository.existsByName(collection.getName())) {
            throw new DuplicateNameException("Collection name already exists", null, 2, null);
        }
        this.collectionRepository.insert(collection);
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionAdded(collection));
        SeriesCollection seriesCollection = SeriesCollectionRepository.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)collection.getId(), null, null, (int)6, null);
        Intrinsics.checkNotNull((Object)seriesCollection);
        return seriesCollection;
    }

    @Transactional
    public void updateCollection(@NotNull SeriesCollection toUpdate) {
        Intrinsics.checkNotNullParameter((Object)toUpdate, (String)"toUpdate");
        SeriesCollectionLifecycleKt.access$getLogger$p().info(() -> SeriesCollectionLifecycle.updateCollection$lambda$1(toUpdate));
        SeriesCollection seriesCollection = SeriesCollectionRepository.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)toUpdate.getId(), null, null, (int)6, null);
        if (seriesCollection == null) {
            throw new IllegalArgumentException("Cannot update collection that does not exist");
        }
        SeriesCollection existing = seriesCollection;
        if (!StringsKt.equals((String)existing.getName(), (String)toUpdate.getName(), (boolean)true) && this.collectionRepository.existsByName(toUpdate.getName())) {
            throw new DuplicateNameException("Collection name already exists", null, 2, null);
        }
        this.collectionRepository.update(toUpdate);
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionUpdated(toUpdate));
    }

    public void deleteCollection(@NotNull SeriesCollection collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesCollectionLifecycle.deleteCollection$lambda$2(this, collection, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionDeleted(collection));
    }

    @Transactional
    public void addSeriesToCollection(@NotNull String collectionName, @NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        SeriesCollection existing = this.collectionRepository.findByNameOrNull(collectionName);
        boolean bl = false;
        if (existing != null) {
            if (existing.getSeriesIds().contains(series.getId())) {
                SeriesCollectionLifecycleKt.access$getLogger$p().debug(() -> SeriesCollectionLifecycle.addSeriesToCollection$lambda$6$lambda$3(existing));
            } else {
                SeriesCollectionLifecycleKt.access$getLogger$p().debug(() -> SeriesCollectionLifecycle.addSeriesToCollection$lambda$6$lambda$4(series, existing));
                this.updateCollection(SeriesCollection.copy$default((SeriesCollection)existing, null, (boolean)false, (List)CollectionsKt.plus((Collection)existing.getSeriesIds(), (Object)series.getId()), null, null, null, (boolean)false, (int)123, null));
            }
        } else {
            SeriesCollectionLifecycleKt.access$getLogger$p().debug(() -> SeriesCollectionLifecycle.addSeriesToCollection$lambda$6$lambda$5(series, collectionName));
            this.addCollection(new SeriesCollection(collectionName, false, CollectionsKt.listOf((Object)series.getId()), null, null, null, false, 122, null));
        }
    }

    public void deleteEmptyCollections() {
        SeriesCollectionLifecycleKt.access$getLogger$p().info(SeriesCollectionLifecycle::deleteEmptyCollections$lambda$7);
        Collection toDelete = this.collectionRepository.findAllEmpty();
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesCollectionLifecycle.deleteEmptyCollections$lambda$10(this, toDelete, arg_0));
        Iterable $this$forEach$iv = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SeriesCollection it = (SeriesCollection)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionDeleted(it));
        }
    }

    @NotNull
    public ThumbnailSeriesCollection addThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        if (WhenMappings.$EnumSwitchMapping$0[thumbnail.getType().ordinal()] == 1) {
            this.thumbnailSeriesCollectionRepository.insert(thumbnail);
            if (thumbnail.getSelected()) {
                this.thumbnailSeriesCollectionRepository.markSelected(thumbnail);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(thumbnail));
        return thumbnail;
    }

    public void markSelectedThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailSeriesCollectionRepository.markSelected(thumbnail);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(ThumbnailSeriesCollection.copy$default((ThumbnailSeriesCollection)thumbnail, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
    }

    public void deleteThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailSeriesCollectionRepository.delete(thumbnail.getId());
        this.thumbnailsHouseKeeping(thumbnail.getCollectionId());
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionDeleted(thumbnail));
    }

    @Nullable
    public byte[] getThumbnailBytes(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
        return (byte[])(thumbnailSeriesCollection != null ? thumbnailSeriesCollection.getThumbnail() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] getThumbnailBytes(@NotNull SeriesCollection collection, @NotNull String userId) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findSelectedByCollectionIdOrNull(collection.getId());
        if (thumbnailSeriesCollection != null) {
            ThumbnailSeriesCollection it = thumbnailSeriesCollection;
            boolean bl = false;
            return it.getThumbnail();
        }
        List $this$getThumbnailBytes_u24lambda_u2413 = new ArrayList();
        boolean bl = false;
        while ($this$getThumbnailBytes_u24lambda_u2413.size() < 4) {
            CollectionsKt.addAll((Collection)$this$getThumbnailBytes_u24lambda_u2413, (Iterable)CollectionsKt.take((Iterable)collection.getSeriesIds(), (int)4));
        }
        List ids = CollectionsKt.take((Iterable)$this$getThumbnailBytes_u24lambda_u2413, (int)4);
        Iterable $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            byte[] it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (this.seriesLifecycle.getThumbnailBytes(it, userId) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List images = (List)destination$iv$iv;
        return this.mosaicGenerator.createMosaic(images);
    }

    /*
     * WARNING - void declaration
     */
    private void thumbnailsHouseKeeping(String collectionId) {
        void $this$filterTo$iv$iv;
        SeriesCollectionLifecycleKt.access$getLogger$p().info(() -> SeriesCollectionLifecycle.thumbnailsHouseKeeping$lambda$15(collectionId));
        Collection all = this.thumbnailSeriesCollectionRepository.findAllByCollectionId(collectionId);
        Iterable $this$filter$iv = all;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThumbnailSeriesCollection it = (ThumbnailSeriesCollection)element$iv$iv;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selected = (List)destination$iv$iv;
        if (selected.size() > 1) {
            SeriesCollectionLifecycleKt.access$getLogger$p().info(SeriesCollectionLifecycle::thumbnailsHouseKeeping$lambda$17);
            this.thumbnailSeriesCollectionRepository.markSelected((ThumbnailSeriesCollection)selected.get(0));
        } else if (selected.isEmpty() && !all.isEmpty()) {
            SeriesCollectionLifecycleKt.access$getLogger$p().info(SeriesCollectionLifecycle::thumbnailsHouseKeeping$lambda$18);
            this.thumbnailSeriesCollectionRepository.markSelected((ThumbnailSeriesCollection)CollectionsKt.first((Iterable)all));
        }
    }

    private static final Object addCollection$lambda$0(SeriesCollection $collection) {
        return "Adding new collection: " + $collection;
    }

    private static final Object updateCollection$lambda$1(SeriesCollection $toUpdate) {
        return "Update collection: " + $toUpdate;
    }

    private static final void deleteCollection$lambda$2(SeriesCollectionLifecycle this$0, SeriesCollection $collection, TransactionStatus it) {
        this$0.thumbnailSeriesCollectionRepository.deleteByCollectionId($collection.getId());
        this$0.collectionRepository.delete($collection.getId());
    }

    private static final Object addSeriesToCollection$lambda$6$lambda$3(SeriesCollection $existing) {
        return "Series is already in existing collection '" + $existing.getName() + "'";
    }

    private static final Object addSeriesToCollection$lambda$6$lambda$4(Series $series, SeriesCollection $existing) {
        return "Adding series '" + $series.getName() + "' to existing collection '" + $existing.getName() + "'";
    }

    private static final Object addSeriesToCollection$lambda$6$lambda$5(Series $series, String $collectionName) {
        return "Adding series '" + $series.getName() + "' to new collection '" + $collectionName + "'";
    }

    private static final Object deleteEmptyCollections$lambda$7() {
        return "Deleting empty collections";
    }

    private static final void deleteEmptyCollections$lambda$10(SeriesCollectionLifecycle this$0, Collection $toDelete, TransactionStatus it) {
        SeriesCollection it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $toDelete;
        ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository = this$0.thumbnailSeriesCollectionRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SeriesCollection seriesCollection = (SeriesCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailSeriesCollectionRepository.deleteByCollectionIds((Collection)((List)destination$iv$iv));
        $this$map$iv = $toDelete;
        thumbnailSeriesCollectionRepository = this$0.collectionRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (SeriesCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailSeriesCollectionRepository.delete((Collection)((List)destination$iv$iv));
    }

    private static final Object thumbnailsHouseKeeping$lambda$15(String $collectionId) {
        return "House keeping thumbnails for collection: " + $collectionId;
    }

    private static final Object thumbnailsHouseKeeping$lambda$17() {
        return "More than one thumbnail is selected, removing extra ones";
    }

    private static final Object thumbnailsHouseKeeping$lambda$18() {
        return "Collection has no selected thumbnail, choosing one automatically";
    }
}

