/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadataAggregation;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.domain.persistence.BookMetadataAggregationRepository;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.domain.service.MetadataAggregator;
import org.gotson.komga.domain.service.MetadataApplier;
import org.gotson.komga.domain.service.SeriesCollectionLifecycle;
import org.gotson.komga.domain.service.SeriesMetadataLifecycleKt;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataFromBookProvider;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataProvider;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001Bs\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010\u001f\u001a\u00020 H\u0012J\u001a\u0010!\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020 H\u0012J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gotson/komga/domain/service/SeriesMetadataLifecycle;", "", "seriesMetadataFromBookProviders", "", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataFromBookProvider;", "seriesMetadataProviders", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataProvider;", "metadataApplier", "Lorg/gotson/komga/domain/service/MetadataApplier;", "metadataAggregator", "Lorg/gotson/komga/domain/service/MetadataAggregator;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "bookMetadataAggregationRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataAggregationRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "collectionLifecycle", "Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Ljava/util/List;Ljava/util/List;Lorg/gotson/komga/domain/service/MetadataApplier;Lorg/gotson/komga/domain/service/MetadataAggregator;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/domain/persistence/BookMetadataAggregationRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;Lorg/springframework/context/ApplicationEventPublisher;)V", "refreshMetadata", "", "series", "Lorg/gotson/komga/domain/model/Series;", "handlePatchForSeriesMetadata", "patches", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "patch", "aggregateMetadata", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesMetadataLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesMetadataLifecycle.kt\norg/gotson/komga/domain/service/SeriesMetadataLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1869#2:159\n1617#2,9:160\n1869#2:169\n1870#2:171\n1626#2:172\n1374#2:173\n1460#2,5:174\n1869#2,2:179\n1870#2:181\n1869#2,2:182\n1617#2,9:184\n1869#2:193\n1870#2:195\n1626#2:196\n1617#2,9:198\n1869#2:207\n1870#2:209\n1626#2:210\n1617#2,9:211\n1869#2:220\n1870#2:222\n1626#2:223\n1#3:170\n1#3:194\n1#3:197\n1#3:208\n1#3:221\n*S KotlinDebug\n*F\n+ 1 SeriesMetadataLifecycle.kt\norg/gotson/komga/domain/service/SeriesMetadataLifecycle\n*L\n44#1:159\n54#1:160,9\n54#1:169\n54#1:171\n54#1:172\n69#1:173\n69#1:174,5\n69#1:179,2\n44#1:181\n77#1:182,2\n113#1:184,9\n113#1:193\n113#1:195\n113#1:196\n120#1:198,9\n120#1:207\n120#1:209\n120#1:210\n122#1:211,9\n122#1:220\n122#1:222\n122#1:223\n54#1:170\n113#1:194\n120#1:208\n122#1:221\n*E\n"})
public class SeriesMetadataLifecycle {
    @NotNull
    private final List<SeriesMetadataFromBookProvider> seriesMetadataFromBookProviders;
    @NotNull
    private final List<SeriesMetadataProvider> seriesMetadataProviders;
    @NotNull
    private final MetadataApplier metadataApplier;
    @NotNull
    private final MetadataAggregator metadataAggregator;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final BookMetadataAggregationRepository bookMetadataAggregationRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final SeriesCollectionLifecycle collectionLifecycle;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public SeriesMetadataLifecycle(@NotNull List<? extends SeriesMetadataFromBookProvider> seriesMetadataFromBookProviders, @NotNull List<? extends SeriesMetadataProvider> seriesMetadataProviders, @NotNull MetadataApplier metadataApplier, @NotNull MetadataAggregator metadataAggregator, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository bookMetadataRepository, @NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull BookMetadataAggregationRepository bookMetadataAggregationRepository, @NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull SeriesCollectionLifecycle collectionLifecycle, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(seriesMetadataFromBookProviders, (String)"seriesMetadataFromBookProviders");
        Intrinsics.checkNotNullParameter(seriesMetadataProviders, (String)"seriesMetadataProviders");
        Intrinsics.checkNotNullParameter((Object)metadataApplier, (String)"metadataApplier");
        Intrinsics.checkNotNullParameter((Object)metadataAggregator, (String)"metadataAggregator");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataAggregationRepository, (String)"bookMetadataAggregationRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)collectionLifecycle, (String)"collectionLifecycle");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.seriesMetadataFromBookProviders = seriesMetadataFromBookProviders;
        this.seriesMetadataProviders = seriesMetadataProviders;
        this.metadataApplier = metadataApplier;
        this.metadataAggregator = metadataAggregator;
        this.mediaRepository = mediaRepository;
        this.bookMetadataRepository = bookMetadataRepository;
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.bookMetadataAggregationRepository = bookMetadataAggregationRepository;
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.collectionLifecycle = collectionLifecycle;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - void declaration
     */
    public void refreshMetadata(@NotNull Series series) {
        Iterable iterable;
        SeriesMetadataFromBookProvider provider;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        SeriesMetadataLifecycleKt.access$getLogger$p().info(() -> SeriesMetadataLifecycle.refreshMetadata$lambda$0(series));
        Library library = this.libraryRepository.findById(series.getLibraryId());
        boolean changed = false;
        Iterable $this$forEach$iv = this.seriesMetadataFromBookProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator $this$flatMapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            provider = (SeriesMetadataFromBookProvider)element$iv;
            boolean bl = false;
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.SERIES) && !provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.COLLECTION)) {
                SeriesMetadataLifecycleKt.access$getLogger$p().info(() -> SeriesMetadataLifecycle.refreshMetadata$lambda$7$lambda$1(provider));
                continue;
            }
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.refreshMetadata$lambda$7$lambda$2(provider));
            iterable = this.bookRepository.findAllBySeriesId(series.getId());
            boolean $i$f$mapNotNull = false;
            void var12_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SeriesMetadataPatch it$iv$iv;
                SeriesMetadataPatch seriesMetadataPatch;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Book book = (Book)element$iv$iv;
                boolean bl3 = false;
                try {
                    seriesMetadataPatch = provider.getSeriesMetadataFromBook(new BookWithMedia(book, this.mediaRepository.findById(book.getId())), library.getImportComicInfoSeriesAppendVolume());
                }
                catch (Exception e) {
                    SeriesMetadataLifecycleKt.access$getLogger$p().error((Throwable)e, () -> SeriesMetadataLifecycle.refreshMetadata$lambda$7$lambda$4$lambda$3(provider, book));
                    seriesMetadataPatch = null;
                }
                if (seriesMetadataPatch == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List patches = (List)destination$iv$iv;
            if (provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.SERIES)) {
                this.handlePatchForSeriesMetadata(patches, series);
                changed = true;
            }
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.COLLECTION)) continue;
            Iterable $this$flatMap$iv = patches;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            $this$forEach$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                SeriesMetadataPatch it = (SeriesMetadataPatch)element$iv$iv;
                boolean bl5 = false;
                Iterable list$iv$iv = it.getCollections();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach3 = false;
            $this$flatMapTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$flatMapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$flatMapTo$iv$iv.next();
                String collection = (String)element$iv2;
                boolean bl6 = false;
                this.collectionLifecycle.addSeriesToCollection(collection, series);
            }
        }
        $this$forEach$iv = this.seriesMetadataProviders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            provider = (SeriesMetadataProvider)element$iv;
            boolean bl = false;
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.SERIES)) {
                SeriesMetadataLifecycleKt.access$getLogger$p().info(() -> SeriesMetadataLifecycle.refreshMetadata$lambda$11$lambda$8((SeriesMetadataProvider)provider));
                continue;
            }
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.refreshMetadata$lambda$11$lambda$9((SeriesMetadataProvider)provider));
            try {
                iterable = provider.getSeriesMetadata(series);
            }
            catch (Exception e) {
                SeriesMetadataLifecycleKt.access$getLogger$p().error((Throwable)e, () -> SeriesMetadataLifecycle.refreshMetadata$lambda$11$lambda$10((SeriesMetadataProvider)provider, series));
                iterable = null;
            }
            Iterable patch = iterable;
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.SERIES)) continue;
            this.handlePatchForSeriesMetadata((SeriesMetadataPatch)patch, series);
            changed = true;
        }
        if (changed) {
            this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesUpdated(series));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handlePatchForSeriesMetadata(List<SeriesMetadataPatch> patches, Series series) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Iterable iterable;
        void $this$mapNotNullTo$iv$iv3;
        void $this$mapNotNull$iv;
        String string = (String)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$12);
        String string2 = (String)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$13);
        SeriesMetadata.Status status = (SeriesMetadata.Status)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$14);
        Object object = patches;
        boolean $i$f$mapNotNull = false;
        Integer n = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SeriesMetadataPatch it = (SeriesMetadataPatch)element$iv$iv;
            boolean bl2 = false;
            if (it.getGenres() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        object = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        if (object.isEmpty()) {
            boolean bl = false;
            iterable = null;
        } else {
            iterable = object;
        }
        Set set = (Set)iterable;
        object = (String)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$17);
        SeriesMetadata.ReadingDirection readingDirection = (SeriesMetadata.ReadingDirection)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$18);
        Iterable $this$mapNotNull$iv2 = patches;
        boolean $i$f$mapNotNull2 = false;
        $this$forEach$iv$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator bl = $this$forEach$iv$iv$iv2.iterator();
        while (bl.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl4 = false;
            SeriesMetadataPatch it = (SeriesMetadataPatch)element$iv$iv;
            boolean bl5 = false;
            if (it.getAgeRating() == null) continue;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        String string3 = (String)LanguageUtilsKt.mostFrequent((Iterable)patches, SeriesMetadataLifecycle::handlePatchForSeriesMetadata$lambda$20);
        Iterable $this$mapNotNull$iv3 = patches;
        boolean $i$f$mapNotNull3 = false;
        Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl7 = false;
            SeriesMetadataPatch it = (SeriesMetadataPatch)element$iv$iv;
            boolean bl8 = false;
            if (it.getTotalBookCount() == null) continue;
            boolean bl9 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv3));
        Set set2 = SetsKt.emptySet();
        SeriesMetadataPatch aggregatedPatch = new SeriesMetadataPatch(string, string2, status, null, readingDirection, string3, n, (String)object, set, n2, set2);
        this.handlePatchForSeriesMetadata(aggregatedPatch, series);
    }

    private void handlePatchForSeriesMetadata(SeriesMetadataPatch patch, Series series) {
        block0: {
            SeriesMetadataPatch seriesMetadataPatch = patch;
            if (seriesMetadataPatch == null) break block0;
            SeriesMetadataPatch sPatch = seriesMetadataPatch;
            boolean bl = false;
            SeriesMetadata it = this.seriesMetadataRepository.findById(series.getId());
            boolean bl2 = false;
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$22(series));
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$23(it));
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$24(sPatch));
            SeriesMetadata patched = this.metadataApplier.apply(sPatch, it);
            SeriesMetadataLifecycleKt.access$getLogger$p().debug(() -> SeriesMetadataLifecycle.handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$25(patched));
            this.seriesMetadataRepository.update(patched);
        }
    }

    public void aggregateMetadata(@NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        SeriesMetadataLifecycleKt.access$getLogger$p().info(() -> SeriesMetadataLifecycle.aggregateMetadata$lambda$28(series));
        Collection metadatas = this.bookMetadataRepository.findAllByIds(this.bookRepository.findAllIdsBySeriesId(series.getId()));
        BookMetadataAggregation aggregation = BookMetadataAggregation.copy$default((BookMetadataAggregation)this.metadataAggregator.aggregate(metadatas), null, null, null, null, null, (String)series.getId(), null, null, (int)223, null);
        this.bookMetadataAggregationRepository.update(aggregation);
        this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesUpdated(series));
    }

    private static final Object refreshMetadata$lambda$0(Series $series) {
        return "Refresh metadata for series: " + $series;
    }

    private static final Object refreshMetadata$lambda$7$lambda$1(SeriesMetadataFromBookProvider $provider) {
        return "Library is not set to import series or collection metadata for this provider, skipping: " + $provider.getClass().getSimpleName();
    }

    private static final Object refreshMetadata$lambda$7$lambda$2(SeriesMetadataFromBookProvider $provider) {
        return "Provider: " + $provider.getClass().getSimpleName();
    }

    private static final Object refreshMetadata$lambda$7$lambda$4$lambda$3(SeriesMetadataFromBookProvider $provider, Book $book) {
        return "Error while getting metadata from " + $provider.getClass().getSimpleName() + " for book: " + $book;
    }

    private static final Object refreshMetadata$lambda$11$lambda$8(SeriesMetadataProvider $provider) {
        return "Library is not set to import series metadata for this provider, skipping: " + $provider.getClass().getSimpleName();
    }

    private static final Object refreshMetadata$lambda$11$lambda$9(SeriesMetadataProvider $provider) {
        return "Provider: " + $provider.getClass().getSimpleName();
    }

    private static final Object refreshMetadata$lambda$11$lambda$10(SeriesMetadataProvider $provider, Series $series) {
        return "Error while getting metadata from " + Reflection.getOrCreateKotlinClass($provider.getClass()).getSimpleName() + " for series: " + $series;
    }

    private static final String handlePatchForSeriesMetadata$lambda$12(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitle();
    }

    private static final String handlePatchForSeriesMetadata$lambda$13(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitleSort();
    }

    private static final SeriesMetadata.Status handlePatchForSeriesMetadata$lambda$14(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStatus();
    }

    private static final String handlePatchForSeriesMetadata$lambda$17(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLanguage();
    }

    private static final SeriesMetadata.ReadingDirection handlePatchForSeriesMetadata$lambda$18(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReadingDirection();
    }

    private static final String handlePatchForSeriesMetadata$lambda$20(SeriesMetadataPatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPublisher();
    }

    private static final Object handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$22(Series $series) {
        return "Apply metadata for series: " + $series;
    }

    private static final Object handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$23(SeriesMetadata $it) {
        return "Original metadata: " + $it;
    }

    private static final Object handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$24(SeriesMetadataPatch $sPatch) {
        return "Patch: " + $sPatch;
    }

    private static final Object handlePatchForSeriesMetadata$lambda$27$lambda$26$lambda$25(SeriesMetadata $patched) {
        return "Patched metadata: " + $patched;
    }

    private static final Object aggregateMetadata$lambda$28(Series $series) {
        return "Aggregate book metadata for series: " + $series;
    }
}

