/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.io.Closeable;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.infrastructure.jooq.BookSearchHelper;
import org.gotson.komga.infrastructure.jooq.RequiredJoin;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.TempTable;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.Media;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.ReadlistBook;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.records.BookRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0017J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001f\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0#H\u0017J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0016J(\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u0017H\u0016J\u001a\u00108\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u0017H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J$\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001f\u001a\u00020\u00172\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0016J&\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u0017H\u0016J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010F\u001a\u00020\u0017H\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001cH\u0017J\u0016\u0010G\u001a\u00020H2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0017J\u0010\u0010K\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001cH\u0017J\u0016\u0010K\u001a\u00020H2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0017J\u0010\u0010L\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001cH\u0012J\u0010\u0010M\u001a\u00020H2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0016\u0010M\u001a\u00020H2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0017J\b\u0010O\u001a\u00020HH\u0016J\b\u0010P\u001a\u00020+H\u0016J\u0014\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\u0014\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020S0\u0016H\u0016J\f\u0010T\u001a\u00020\u001c*\u00020\u0019H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u0015\u001aR\u0012\u0004\u0012\u00020\u0017\u0012H\u0012F\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00190\u0019\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a \f*\"\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00190\u0019\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00180\u00180\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/BookRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "batchSize", "", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;I)V", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "kotlin.jvm.PlatformType", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "sd", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "sorts", "", "", "Lorg/jooq/TableField;", "Lorg/gotson/komga/jooq/main/tables/records/BookRecord;", "", "findByIdOrNull", "Lorg/gotson/komga/domain/model/Book;", "bookId", "findNotDeletedByLibraryIdAndUrlOrNull", "libraryId", "url", "Ljava/net/URL;", "findAllBySeriesId", "", "seriesId", "findAllBySeriesIds", "seriesIds", "findAllNotDeletedByLibraryIdAndUrlNotIn", "urls", "findAllDeletedByFileSize", "fileSize", "", "findAll", "Lorg/springframework/data/domain/Page;", "searchCondition", "Lorg/gotson/komga/domain/model/SearchCondition$Book;", "searchContext", "Lorg/gotson/komga/domain/model/SearchContext;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getLibraryIdOrNull", "getSeriesIdOrNull", "findFirstIdInSeriesOrNull", "findLastIdInSeriesOrNull", "findFirstUnreadIdInSeriesOrNull", "userId", "findAllIdsBySeriesId", "findAllIdsByLibraryId", "existsById", "", "findAllByLibraryIdAndMediaTypes", "mediaTypes", "findAllByLibraryIdAndMismatchedExtension", "mediaType", "extension", "findAllByLibraryIdAndWithEmptyHash", "findAllByLibraryIdAndWithEmptyHashKoreader", "findAllByHashKoreader", "hashKoreader", "insert", "", "book", "books", "update", "updateBook", "delete", "bookIds", "deleteAll", "count", "countGroupedByLibraryId", "getFilesizeGroupedByLibraryId", "Ljava/math/BigDecimal;", "toDomain", "komga"})
@SourceDebugExtension(value={"SMAP\nBookDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n1563#2:440\n1634#2,3:441\n1869#2,2:444\n1869#2,2:446\n1869#2:449\n1869#2,2:450\n1870#2:452\n1563#2:453\n1634#2,3:454\n1#3:448\n*S KotlinDebug\n*F\n+ 1 BookDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDao\n*L\n95#1:440\n95#1:441,3\n132#1:444,2\n157#1:446,2\n320#1:449\n340#1:450,2\n320#1:452\n368#1:453\n368#1:454,3\n*E\n"})
public class BookDao
extends SplitDslDaoBase
implements BookRepository {
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.Book b;
    private final Media m;
    private final BookMetadata d;
    private final SeriesMetadata sd;
    private final ReadProgress r;
    @NotNull
    private final Map<String, TableField<BookRecord, ? extends Object>> sorts;

    public BookDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.batchSize = batchSize;
        this.b = Tables.BOOK;
        this.m = Tables.MEDIA;
        this.d = Tables.BOOK_METADATA;
        this.sd = Tables.SERIES_METADATA;
        this.r = Tables.READ_PROGRESS;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"createdDate", (Object)this.b.CREATED_DATE), TuplesKt.to((Object)"seriesId", (Object)this.b.SERIES_ID), TuplesKt.to((Object)"number", (Object)this.b.NUMBER)};
        this.sorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public Book findByIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        BookRecord bookRecord = (BookRecord)this.getDslRO().selectFrom((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOneInto((Table)this.b);
        return bookRecord != null ? this.toDomain(bookRecord) : null;
    }

    @Nullable
    public Book findNotDeletedByLibraryIdAndUrlOrNull(@NotNull String libraryId, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Result result = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId).and(this.b.URL.eq((Object)url.toString()))).and(this.b.DELETED_DATE.isNull()).orderBy((OrderField)this.b.LAST_MODIFIED_DATE.desc()).fetchInto((Table)this.b);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetchInto(...)");
        BookRecord bookRecord = (BookRecord)CollectionsKt.firstOrNull((List)((List)result));
        return bookRecord != null ? this.toDomain(bookRecord) : null;
    }

    @NotNull
    public Collection<Book> findAllBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.SERIES_ID.eq((Object)seriesId)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @NotNull
    public Collection<Book> findAllBySeriesIds(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        Closeable closeable = (Closeable)TempTable.Companion.withTempTable(this.getDslRO(), this.batchSize, seriesIds);
        Throwable throwable = null;
        try {
            TempTable tempTable = (TempTable)closeable;
            boolean bl = false;
            List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.SERIES_ID.in((Select)tempTable.selectTempStrings())).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
            Collection collection = list;
            return collection;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Collection<Book> findAllNotDeletedByLibraryIdAndUrlNotIn(@NotNull String libraryId, @NotNull Collection<URL> urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Object object = urls;
        int n = this.batchSize;
        DSLContext dSLContext = this.getDslRO();
        TempTable.Companion companion = TempTable.Companion;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        object = (Closeable)companion.withTempTable(dSLContext, n, (Collection)collection);
        Throwable throwable = null;
        try {
            TempTable tempTable = (TempTable)object;
            boolean bl = false;
            List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.b.DELETED_DATE.isNull()).and(this.b.URL.notIn((Select)tempTable.selectTempStrings())).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
            Collection collection2 = list;
            return collection2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public Collection<Book> findAllDeletedByFileSize(long fileSize) {
        List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.DELETED_DATE.isNotNull().and(this.b.FILE_SIZE.eq((Object)fileSize))).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAll() {
        List list = this.getDslRO().selectFrom((TableLike)this.b).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Page<Book> findAll(@Nullable SearchCondition.Book searchCondition, @NotNull SearchContext searchContext, @NotNull Pageable pageable) {
        SelectJoinStep selectJoinStep;
        Intrinsics.checkNotNullParameter((Object)searchContext, (String)"searchContext");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Pair bookCondition = new BookSearchHelper(searchContext).toCondition(searchCondition);
        SelectJoinStep $this$findAll_u24lambda_u244 = selectJoinStep = this.getDslRO().selectCount().from((TableLike)this.b);
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)bookCondition.getSecond();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SelectOnConditionStep selectOnConditionStep;
            RequiredJoin join = (RequiredJoin)element$iv;
            boolean bl2 = false;
            RequiredJoin requiredJoin = join;
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadata.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u244.innerJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.SeriesMetadata.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u244.innerJoin((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.Media.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u244.innerJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID));
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.ReadProgress) {
                selectOnConditionStep = $this$findAll_u24lambda_u244.leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.r.USER_ID.eq((Object)((RequiredJoin.ReadProgress)join).getUserId()));
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.ReadList) {
                ReadlistBook rlbAlias = UtilsKt.rlbAlias((String)((RequiredJoin.ReadList)join).getReadListId());
                selectOnConditionStep = $this$findAll_u24lambda_u244.leftJoin((TableLike)rlbAlias).on(rlbAlias.BOOK_ID.eq((Field)this.b.ID).and(rlbAlias.READLIST_ID.eq((Object)((RequiredJoin.ReadList)join).getReadListId())));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE)) {
                selectOnConditionStep = Unit.INSTANCE;
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.Collection) {
                selectOnConditionStep = Unit.INSTANCE;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Long l = (Long)selectJoinStep.where((Condition)bookCondition.getFirst()).fetchOne(0, Long.TYPE);
        long count = l != null ? l : 0L;
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        SelectJoinStep selectJoinStep2 = this.b.fields();
        SelectJoinStep $this$findAll_u24lambda_u246 = selectJoinStep2 = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectJoinStep2, ((Field[])selectJoinStep2).length)).from((TableLike)this.b);
        boolean bl3 = false;
        Iterable $this$forEach$iv2 = (Iterable)bookCondition.getSecond();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SelectOnConditionStep selectOnConditionStep;
            RequiredJoin join = (RequiredJoin)element$iv;
            boolean bl4 = false;
            RequiredJoin requiredJoin = join;
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadata.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u246.innerJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.SeriesMetadata.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u246.innerJoin((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.Media.INSTANCE)) {
                selectOnConditionStep = $this$findAll_u24lambda_u246.innerJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID));
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.ReadProgress) {
                selectOnConditionStep = $this$findAll_u24lambda_u246.leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.r.USER_ID.eq((Object)((RequiredJoin.ReadProgress)join).getUserId()));
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.ReadList) {
                ReadlistBook rlbAlias = UtilsKt.rlbAlias((String)((RequiredJoin.ReadList)join).getReadListId());
                selectOnConditionStep = $this$findAll_u24lambda_u246.leftJoin((TableLike)rlbAlias).on(rlbAlias.BOOK_ID.eq((Field)this.b.ID).and(rlbAlias.READLIST_ID.eq((Object)((RequiredJoin.ReadList)join).getReadListId())));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE)) {
                selectOnConditionStep = Unit.INSTANCE;
                continue;
            }
            if (requiredJoin instanceof RequiredJoin.Collection) {
                selectOnConditionStep = Unit.INSTANCE;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        SelectJoinStep $this$findAll_u24lambda_u247 = selectJoinStep2 = selectJoinStep2.where((Condition)bookCondition.getFirst()).orderBy((Collection)orderBy);
        boolean bl5 = false;
        if (pageable.isPaged()) {
            $this$findAll_u24lambda_u247.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectJoinStep2.fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        selectJoinStep2 = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectJoinStep2);
        SelectJoinStep pageSort = selectJoinStep2;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max((int)count, 20), (Sort)pageSort)), count);
    }

    @Nullable
    public String getLibraryIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (String)this.getDslRO().select((SelectField)this.b.LIBRARY_ID).from((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOne((Field)this.b.LIBRARY_ID);
    }

    @Nullable
    public String getSeriesIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (String)this.getDslRO().select((SelectField)this.b.SERIES_ID).from((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOne((Field)this.b.SERIES_ID);
    }

    @Nullable
    public String findFirstIdInSeriesOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (String)this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).orderBy((OrderField)this.d.NUMBER_SORT).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @Nullable
    public String findLastIdInSeriesOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (String)this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).orderBy((OrderField)this.d.NUMBER_SORT.desc()).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @Nullable
    public String findFirstUnreadIdInSeriesOrNull(@NotNull String seriesId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (String)this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.r.USER_ID.eq((Object)userId).or(this.r.USER_ID.isNull())).where(this.b.SERIES_ID.eq((Object)seriesId)).and(this.r.COMPLETED.isNull().or(this.r.COMPLETED.isFalse())).orderBy((OrderField)this.d.NUMBER_SORT).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @NotNull
    public Collection<String> findAllIdsBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).where(this.b.SERIES_ID.eq((Object)seriesId)).fetch((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    @NotNull
    public Collection<String> findAllIdsByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).fetch((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    public boolean existsById(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.getDslRO().fetchExists((Table)this.b, this.b.ID.eq((Object)bookId));
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndMediaTypes(@NotNull String libraryId, @NotNull Collection<String> mediaTypes) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
        Field[] fieldArray = this.b.fields();
        List list = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.m.MEDIA_TYPE.in(mediaTypes)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndMismatchedExtension(@NotNull String libraryId, @NotNull String mediaType, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Field[] fieldArray = this.b.fields();
        List list = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.m.MEDIA_TYPE.eq((Object)mediaType)).and((Condition)this.b.URL.notLike("%." + extension)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndWithEmptyHash(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.b.FILE_HASH.eq((Object)"")).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndWithEmptyHashKoreader(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.b.FILE_HASH_KOREADER.eq((Object)"")).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByHashKoreader(@NotNull String hashKoreader) {
        Intrinsics.checkNotNullParameter((Object)hashKoreader, (String)"hashKoreader");
        List list = this.getDslRO().selectFrom((TableLike)this.b).where(this.b.FILE_HASH_KOREADER.eq((Object)hashKoreader)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Transactional
    public void insert(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.insert((Collection)CollectionsKt.listOf((Object)book));
    }

    @Transactional
    public void insert(@NotNull Collection<Book> books) {
        Intrinsics.checkNotNullParameter(books, (String)"books");
        if (!books.isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)books, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = this.getDslRW().batch((Query)this.getDslRW().insertInto((Table)this.b, (Field)this.b.ID, (Field)this.b.NAME, (Field)this.b.URL, (Field)this.b.NUMBER, (Field)this.b.FILE_LAST_MODIFIED, (Field)this.b.FILE_SIZE, (Field)this.b.FILE_HASH, (Field)this.b.FILE_HASH_KOREADER, (Field)this.b.LIBRARY_ID, (Field)this.b.SERIES_ID, (Field)this.b.DELETED_DATE, (Field)this.b.ONESHOT).values(null, null, null, null, null, null, null, null, null, null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Book it = (Book)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it.getId(), it.getName(), it.getUrl(), it.getNumber(), it.getFileLastModified(), it.getFileSize(), it.getFileHash(), it.getFileHashKoreader(), it.getLibraryId(), it.getSeriesId(), it.getDeletedDate(), it.getOneshot()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void update(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.updateBook(book);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void update(@NotNull Collection<Book> books) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.updateBook((Book)it);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private void updateBook(Book book) {
        this.getDslRW().update((Table)this.b).set((Field)this.b.NAME, (Object)book.getName()).set((Field)this.b.URL, (Object)book.getUrl().toString()).set((Field)this.b.NUMBER, (Object)book.getNumber()).set((Field)this.b.FILE_LAST_MODIFIED, (Object)book.getFileLastModified()).set((Field)this.b.FILE_SIZE, (Object)book.getFileSize()).set((Field)this.b.FILE_HASH, (Object)book.getFileHash()).set((Field)this.b.FILE_HASH_KOREADER, (Object)book.getFileHashKoreader()).set((Field)this.b.LIBRARY_ID, (Object)book.getLibraryId()).set((Field)this.b.SERIES_ID, (Object)book.getSeriesId()).set((Field)this.b.DELETED_DATE, (Object)book.getDeletedDate()).set((Field)this.b.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).set((Field)this.b.ONESHOT, (Object)book.getOneshot()).where(this.b.ID.eq((Object)book.getId())).execute();
    }

    public void delete(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.getDslRW().deleteFrom((Table)this.b).where(this.b.ID.eq((Object)bookId)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void delete(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        Closeable closeable = (Closeable)TempTable.Companion.withTempTable(this.getDslRW(), this.batchSize, bookIds);
        Throwable throwable = null;
        try {
            TempTable tempTable = (TempTable)closeable;
            boolean bl = false;
            int n = this.getDslRW().deleteFrom((Table)this.b).where(this.b.ID.in((Select)tempTable.selectTempStrings())).execute();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void deleteAll() {
        this.getDslRW().deleteFrom((Table)this.b).execute();
    }

    public long count() {
        return this.getDslRO().fetchCount((Table)this.b);
    }

    @NotNull
    public Map<String, Integer> countGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.b.LIBRARY_ID};
        Map map = this.getDslRO().select((SelectField)this.b.LIBRARY_ID, (SelectField)DSL.count((Field)((Field)this.b.ID))).from((TableLike)this.b).groupBy(groupFieldArray).fetchMap((Field)this.b.LIBRARY_ID, (Field)DSL.count((Field)((Field)this.b.ID)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    @NotNull
    public Map<String, BigDecimal> getFilesizeGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.b.LIBRARY_ID};
        Map map = this.getDslRO().select((SelectField)this.b.LIBRARY_ID, (SelectField)DSL.sum((Field)((Field)this.b.FILE_SIZE))).from((TableLike)this.b).groupBy(groupFieldArray).fetchMap((Field)this.b.LIBRARY_ID, (Field)DSL.sum((Field)((Field)this.b.FILE_SIZE)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    private Book toDomain(BookRecord $this$toDomain) {
        String string = $this$toDomain.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        URL uRL = new URL($this$toDomain.getUrl());
        LocalDateTime localDateTime = $this$toDomain.getFileLastModified();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getFileLastModified(...)");
        LocalDateTime localDateTime2 = localDateTime;
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        String string3 = $this$toDomain.getFileHash();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileHash(...)");
        String string4 = string3;
        String string5 = $this$toDomain.getFileHashKoreader();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileHashKoreader(...)");
        String string6 = string5;
        String string7 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getId(...)");
        String string8 = string7;
        String string9 = $this$toDomain.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getLibraryId(...)");
        String string10 = string9;
        String string11 = $this$toDomain.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getSeriesId(...)");
        String string12 = string11;
        LocalDateTime localDateTime3 = $this$toDomain.getDeletedDate();
        Boolean bl = $this$toDomain.getOneshot();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOneshot(...)");
        boolean bl2 = bl;
        LocalDateTime localDateTime4 = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime4, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime5 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime4);
        LocalDateTime localDateTime6 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime6, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime7 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime6);
        Integer n = $this$toDomain.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getNumber(...)");
        int n2 = ((Number)n).intValue();
        return new Book(string2, uRL, localDateTime2, l2, string4, string6, n2, string8, string12, string10, localDateTime3, bl2, localDateTime5, localDateTime7);
    }

    public static final /* synthetic */ Book access$toDomain(BookDao $this, BookRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

