/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.io.Closeable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.BookMetadataAggregation;
import org.gotson.komga.domain.persistence.BookMetadataAggregationRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.TempTable;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.BookMetadataAggregationAuthor;
import org.gotson.komga.jooq.main.tables.BookMetadataAggregationTag;
import org.gotson.komga.jooq.main.tables.records.BookMetadataAggregationAuthorRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataAggregationRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017*\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0012J@\u0010\u001a\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00140\u0014 \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00140\u00140\u001d\u00a2\u0006\u0002\b\u001c0\u001b\u00a2\u0006\u0002\b\u001c*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0017J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0017J\u0014\u0010\"\u001a\u00020\u001f*\u00020\u00042\u0006\u0010 \u001a\u00020\u0012H\u0012J\u0014\u0010#\u001a\u00020\u001f*\u00020\u00042\u0006\u0010 \u001a\u00020\u0012H\u0012J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0016\u0010$\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0017J\b\u0010%\u001a\u00020&H\u0016J(\u0010'\u001a\u00020\u0012*\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dH\u0012J\f\u0010'\u001a\u00020**\u00020,H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookMetadataAggregationDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/BookMetadataAggregationRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "batchSize", "", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;I)V", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAggregation;", "kotlin.jvm.PlatformType", "a", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAggregationAuthor;", "t", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAggregationTag;", "findById", "Lorg/gotson/komga/domain/model/BookMetadataAggregation;", "seriesId", "", "findByIdOrNull", "findOne", "", "seriesIds", "", "findTags", "", "Lorg/jetbrains/annotations/NotNull;", "", "insert", "", "metadata", "update", "insertAuthors", "insertTags", "delete", "count", "", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataAggregationRecord;", "authors", "Lorg/gotson/komga/domain/model/Author;", "tags", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataAggregationAuthorRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookMetadataAggregationDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookMetadataAggregationDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookMetadataAggregationDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n126#2:168\n153#2,2:169\n155#2:178\n827#3:171\n855#3,2:172\n1563#3:174\n1634#3,3:175\n1869#3:179\n1869#3,2:180\n1870#3:182\n1869#3:183\n1869#3,2:184\n1870#3:186\n*S KotlinDebug\n*F\n+ 1 BookMetadataAggregationDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookMetadataAggregationDao\n*L\n45#1:168\n45#1:169,2\n45#1:178\n46#1:171\n46#1:172,2\n46#1:174\n46#1:175,3\n97#1:179\n104#1:180,2\n97#1:182\n114#1:183\n121#1:184,2\n114#1:186\n*E\n"})
public class BookMetadataAggregationDao
extends SplitDslDaoBase
implements BookMetadataAggregationRepository {
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.BookMetadataAggregation d;
    private final BookMetadataAggregationAuthor a;
    private final BookMetadataAggregationTag t;

    public BookMetadataAggregationDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.batchSize = batchSize;
        this.d = Tables.BOOK_METADATA_AGGREGATION;
        this.a = Tables.BOOK_METADATA_AGGREGATION_AUTHOR;
        this.t = Tables.BOOK_METADATA_AGGREGATION_TAG;
    }

    @NotNull
    public BookMetadataAggregation findById(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (BookMetadataAggregation)CollectionsKt.first((List)this.findOne(this.getDslRO(), (Collection)CollectionsKt.listOf((Object)seriesId)));
    }

    @Nullable
    public BookMetadataAggregation findByIdOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (BookMetadataAggregation)CollectionsKt.firstOrNull((List)this.findOne(this.getDslRO(), (Collection)CollectionsKt.listOf((Object)seriesId)));
    }

    /*
     * WARNING - void declaration
     */
    private List<BookMetadataAggregation> findOne(DSLContext $this$findOne, Collection<String> seriesIds) {
        void $this$mapTo$iv$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)this.d.fields());
        spreadBuilder.addSpread((Object)this.a.fields());
        Map map = $this$findOne.select((SelectFieldOrAsterisk[])spreadBuilder.toArray((Object[])new SelectFieldOrAsterisk[spreadBuilder.size()])).from((TableLike)this.d).leftJoin((TableLike)this.a).on(this.d.SERIES_ID.eq((Field)this.a.SERIES_ID)).where(this.d.SERIES_ID.in(seriesIds)).fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            BookMetadataAggregationAuthorRecord it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BookMetadataAggregationRecord dr = (BookMetadataAggregationRecord)entry.getKey();
            List ar = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)dr);
            Intrinsics.checkNotNull((Object)ar);
            Iterable iterable = ar;
            BookMetadataAggregationRecord bookMetadataAggregationRecord = dr;
            BookMetadataAggregationDao bookMetadataAggregationDao = this;
            boolean $i$f$filterNot = false;
            void var18_19 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (BookMetadataAggregationAuthorRecord)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<Author> collection2 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection2;
            boolean $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (BookMetadataAggregationAuthorRecord)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(this.toDomain(it));
            }
            collection2 = (List)destination$iv$iv2;
            String string = dr.getSeriesId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeriesId(...)");
            collection.add(bookMetadataAggregationDao.toDomain(bookMetadataAggregationRecord, (List)collection2, this.findTags($this$findOne, string)));
        }
        return (List)destination$iv$iv;
    }

    private @NotNull Set<String> findTags(DSLContext $this$findTags, String seriesId) {
        Set set = $this$findTags.select((SelectField)this.t.TAG).from((TableLike)this.t).where(this.t.SERIES_ID.eq((Object)seriesId)).fetchSet((Field)this.t.TAG);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    @Transactional
    public void insert(@NotNull BookMetadataAggregation metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.getDslRW().insertInto((Table)this.d).set((Field)this.d.SERIES_ID, (Object)metadata.getSeriesId()).set((Field)this.d.RELEASE_DATE, (Object)metadata.getReleaseDate()).set((Field)this.d.SUMMARY, (Object)metadata.getSummary()).set((Field)this.d.SUMMARY_NUMBER, (Object)metadata.getSummaryNumber()).execute();
        this.insertAuthors(this.getDslRW(), metadata);
        this.insertTags(this.getDslRW(), metadata);
    }

    @Transactional
    public void update(@NotNull BookMetadataAggregation metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.getDslRW().update((Table)this.d).set((Field)this.d.SUMMARY, (Object)metadata.getSummary()).set((Field)this.d.SUMMARY_NUMBER, (Object)metadata.getSummaryNumber()).set((Field)this.d.RELEASE_DATE, (Object)metadata.getReleaseDate()).set((Field)this.d.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.d.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.a).where(this.a.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.t).where(this.t.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.insertAuthors(this.getDslRW(), metadata);
        this.insertTags(this.getDslRW(), metadata);
    }

    private void insertAuthors(DSLContext $this$insertAuthors, BookMetadataAggregation metadata) {
        if (!((Collection)metadata.getAuthors()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getAuthors(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertAuthors.batch((Query)$this$insertAuthors.insertInto((Table)this.a, (Field)this.a.SERIES_ID, (Field)this.a.NAME, (Field)this.a.ROLE).values(null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Author it = (Author)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it.getName(), it.getRole()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertTags(DSLContext $this$insertTags, BookMetadataAggregation metadata) {
        if (!((Collection)metadata.getTags()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getTags(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertTags.batch((Query)$this$insertTags.insertInto((Table)this.t, (Field)this.t.SERIES_ID, (Field)this.t.TAG).values(null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void delete(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.getDslRW().deleteFrom((Table)this.a).where(this.a.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.t).where(this.t.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.d).where(this.d.SERIES_ID.eq((Object)seriesId)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void delete(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        Closeable closeable = (Closeable)TempTable.Companion.withTempTable(this.getDslRW(), this.batchSize, seriesIds);
        Throwable throwable = null;
        try {
            TempTable it = (TempTable)closeable;
            boolean bl = false;
            this.getDslRW().deleteFrom((Table)this.a).where(this.a.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            this.getDslRW().deleteFrom((Table)this.t).where(this.t.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            int n = this.getDslRW().deleteFrom((Table)this.d).where(this.d.SERIES_ID.in((Select)it.selectTempStrings())).execute();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public long count() {
        return this.getDslRO().fetchCount((Table)this.d);
    }

    private BookMetadataAggregation toDomain(BookMetadataAggregationRecord $this$toDomain, List<Author> authors, Set<String> tags) {
        LocalDate localDate = $this$toDomain.getReleaseDate();
        String string = $this$toDomain.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSummary(...)");
        String string2 = $this$toDomain.getSummaryNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSummaryNumber(...)");
        String string3 = $this$toDomain.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSeriesId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        return new BookMetadataAggregation(authors, tags, localDate, string, string2, string3, localDateTime2, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3));
    }

    private Author toDomain(BookMetadataAggregationAuthorRecord $this$toDomain) {
        String string = $this$toDomain.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $this$toDomain.getRole();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRole(...)");
        return new Author(string, string2);
    }

    public static final /* synthetic */ org.gotson.komga.jooq.main.tables.BookMetadataAggregation access$getD$p(BookMetadataAggregationDao $this) {
        return $this.d;
    }

    public static final /* synthetic */ BookMetadataAggregationAuthor access$getA$p(BookMetadataAggregationDao $this) {
        return $this.a;
    }
}

