/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import com.github.f4b6a3.tsid.TsidCreator;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SyncPoint;
import org.gotson.komga.domain.persistence.SyncPointRepository;
import org.gotson.komga.infrastructure.jooq.BookSearchHelper;
import org.gotson.komga.infrastructure.jooq.RequiredJoin;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.main.BookCommonDao;
import org.gotson.komga.infrastructure.jooq.main.SyncPointDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.Media;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.SyncPointBook;
import org.gotson.komga.jooq.main.tables.SyncPointBookRemovedSynced;
import org.gotson.komga.jooq.main.tables.SyncPointReadlist;
import org.gotson.komga.jooq.main.tables.SyncPointReadlistBook;
import org.gotson.komga.jooq.main.tables.SyncPointReadlistRemovedSynced;
import org.gotson.komga.jooq.main.tables.ThumbnailBook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStep10;
import org.jooq.Query;
import org.jooq.Record1;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J(\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010/H\u0017J\u0012\u00100\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020&H\u0016J&\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010-\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u00108\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010;\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010<\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010=\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J&\u0010>\u001a\b\u0012\u0004\u0012\u00020?022\u0006\u0010-\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010@\u001a\b\u0012\u0004\u0012\u00020?022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010A\u001a\b\u0012\u0004\u0012\u00020?022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J.\u0010B\u001a\b\u0012\u0004\u0012\u00020?022\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J$\u0010C\u001a\b\u0012\u0004\u0012\u00020D0/2\u0006\u0010-\u001a\u00020&2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020&0FH\u0016J&\u0010G\u001a\u00020,2\u0006\u0010-\u001a\u00020&2\u0006\u0010H\u001a\u0002052\f\u0010I\u001a\b\u0012\u0004\u0012\u00020&0FH\u0016J&\u0010J\u001a\u00020,2\u0006\u0010-\u001a\u00020&2\u0006\u0010K\u001a\u0002052\f\u0010E\u001a\b\u0012\u0004\u0012\u00020&0FH\u0016J\u0010\u0010L\u001a\u00020,2\u0006\u0010M\u001a\u00020&H\u0016J\u001e\u0010N\u001a\u00020,2\u0006\u0010M\u001a\u00020&2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020&0FH\u0016J \u0010P\u001a\u00020,*\u00020\u00042\u0012\u0010Q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0S0RH\u0012J\u0010\u0010T\u001a\u00020,2\u0006\u0010-\u001a\u00020&H\u0016J\b\u0010U\u001a\u00020,H\u0016J&\u0010V\u001a\b\u0012\u0004\u0012\u00020302*\u00020\u00042\n\u0010W\u001a\u0006\u0012\u0002\b\u00030R2\u0006\u00106\u001a\u000207H\u0012J&\u0010X\u001a\b\u0012\u0004\u0012\u00020?02*\u00020\u00042\n\u0010W\u001a\u0006\u0012\u0002\b\u00030R2\u0006\u00106\u001a\u000207H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00160\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \f*\u0004\u0018\u00010\u00180\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u001a0\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \f*\u0004\u0018\u00010\u001c0\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \f*\u0004\u0018\u00010\u001e0\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \f*\u0004\u0018\u00010 0 X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n \f*\u0004\u0018\u00010\"0\"X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/SyncPointDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/SyncPointRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "bookCommonDao", "Lorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;Lorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;)V", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "kotlin.jvm.PlatformType", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "bt", "Lorg/gotson/komga/jooq/main/tables/ThumbnailBook;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "sd", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "sp", "Lorg/gotson/komga/jooq/main/tables/SyncPoint;", "spb", "Lorg/gotson/komga/jooq/main/tables/SyncPointBook;", "spbs", "Lorg/gotson/komga/jooq/main/tables/SyncPointBookRemovedSynced;", "sprl", "Lorg/gotson/komga/jooq/main/tables/SyncPointReadlist;", "sprlb", "Lorg/gotson/komga/jooq/main/tables/SyncPointReadlistBook;", "sprls", "Lorg/gotson/komga/jooq/main/tables/SyncPointReadlistRemovedSynced;", "create", "Lorg/gotson/komga/domain/model/SyncPoint;", "apiKeyId", "", "search", "Lorg/gotson/komga/domain/model/BookSearch;", "context", "Lorg/gotson/komga/domain/model/SearchContext;", "addOnDeck", "", "syncPointId", "filterOnLibraryIds", "", "findByIdOrNull", "findBooksById", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/domain/model/SyncPoint$Book;", "onlyNotSynced", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findBooksAdded", "fromSyncPointId", "toSyncPointId", "findBooksRemoved", "findBooksChanged", "findBooksReadProgressChanged", "findReadListsById", "Lorg/gotson/komga/domain/model/SyncPoint$ReadList;", "findReadListsAdded", "findReadListsChanged", "findReadListsRemoved", "findBookIdsByReadListIds", "Lorg/gotson/komga/domain/model/SyncPoint$ReadList$Book;", "readListIds", "", "markBooksSynced", "forRemovedBooks", "bookIds", "markReadListsSynced", "forRemovedReadLists", "deleteByUserId", "userId", "deleteByUserIdAndApiKeyIds", "apiKeyIds", "deleteSubEntities", "condition", "Lorg/jooq/SelectConditionStep;", "Lorg/jooq/Record1;", "deleteOne", "deleteAll", "queryToPageBook", "query", "queryToPageReadList", "komga"})
@SourceDebugExtension(value={"SMAP\nSyncPointDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncPointDao.kt\norg/gotson/komga/infrastructure/jooq/main/SyncPointDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,586:1\n1#2:587\n1869#3,2:588\n1563#3:590\n1634#3,3:591\n1563#3:594\n1634#3,3:595\n*S KotlinDebug\n*F\n+ 1 SyncPointDao.kt\norg/gotson/komga/infrastructure/jooq/main/SyncPointDao\n*L\n105#1:588,2\n444#1:590\n444#1:591,3\n469#1:594\n469#1:595,3\n*E\n"})
public class SyncPointDao
extends SplitDslDaoBase
implements SyncPointRepository {
    @NotNull
    private final BookCommonDao bookCommonDao;
    private final Book b;
    private final Media m;
    private final BookMetadata d;
    private final ThumbnailBook bt;
    private final ReadProgress r;
    private final SeriesMetadata sd;
    private final org.gotson.komga.jooq.main.tables.SyncPoint sp;
    private final SyncPointBook spb;
    private final SyncPointBookRemovedSynced spbs;
    private final SyncPointReadlist sprl;
    private final SyncPointReadlistBook sprlb;
    private final SyncPointReadlistRemovedSynced sprls;

    public SyncPointDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @NotNull BookCommonDao bookCommonDao) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        Intrinsics.checkNotNullParameter((Object)bookCommonDao, (String)"bookCommonDao");
        super(dslRW, dslRO);
        this.bookCommonDao = bookCommonDao;
        this.b = Tables.BOOK;
        this.m = Tables.MEDIA;
        this.d = Tables.BOOK_METADATA;
        this.bt = Tables.THUMBNAIL_BOOK;
        this.r = Tables.READ_PROGRESS;
        this.sd = Tables.SERIES_METADATA;
        this.sp = Tables.SYNC_POINT;
        this.spb = Tables.SYNC_POINT_BOOK;
        this.spbs = Tables.SYNC_POINT_BOOK_REMOVED_SYNCED;
        this.sprl = Tables.SYNC_POINT_READLIST;
        this.sprlb = Tables.SYNC_POINT_READLIST_BOOK;
        this.sprls = Tables.SYNC_POINT_READLIST_REMOVED_SYNCED;
    }

    @Transactional
    @NotNull
    public SyncPoint create(@Nullable String apiKeyId, @NotNull BookSearch search, @NotNull SearchContext context) {
        SelectJoinStep selectJoinStep;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getUserId() == null) {
            boolean $i$a$-requireNotNull-SyncPointDao$create$22 = false;
            String $i$a$-requireNotNull-SyncPointDao$create$22 = "userId is required to create a SyncPoint";
            throw new IllegalArgumentException($i$a$-requireNotNull-SyncPointDao$create$22.toString());
        }
        Pair pair = new BookSearchHelper(context).toCondition(search.getCondition());
        Condition condition = (Condition)pair.component1();
        Set joins = (Set)pair.component2();
        String string = TsidCreator.getTsid256().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String syncPointId = string;
        LocalDateTime createdAt = LocalDateTime.now(ZoneId.of("Z"));
        this.getDslRW().insertInto((Table)this.sp, (Field)this.sp.ID, (Field)this.sp.USER_ID, (Field)this.sp.API_KEY_ID, (Field)this.sp.CREATED_DATE).values((Object)syncPointId, (Object)context.getUserId(), (Object)apiKeyId, (Object)createdAt).execute();
        SelectJoinStep selectJoinStep2 = selectJoinStep = this.getDslRW().select((SelectField)DSL.val((String)syncPointId), (SelectField)this.b.ID, (SelectField)this.b.CREATED_DATE, (SelectField)this.b.LAST_MODIFIED_DATE, (SelectField)this.b.FILE_LAST_MODIFIED, (SelectField)this.b.FILE_SIZE, (SelectField)this.b.FILE_HASH, (SelectField)this.d.LAST_MODIFIED_DATE, (SelectField)this.r.LAST_MODIFIED_DATE, (SelectField)this.bt.ID).from((TableLike)this.b);
        InsertValuesStep10 insertValuesStep10 = this.getDslRW().insertInto((Table)this.spb, (Field)this.spb.SYNC_POINT_ID, (Field)this.spb.BOOK_ID, (Field)this.spb.BOOK_CREATED_DATE, (Field)this.spb.BOOK_LAST_MODIFIED_DATE, (Field)this.spb.BOOK_FILE_LAST_MODIFIED, (Field)this.spb.BOOK_FILE_SIZE, (Field)this.spb.BOOK_FILE_HASH, (Field)this.spb.BOOK_METADATA_LAST_MODIFIED_DATE, (Field)this.spb.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE, (Field)this.spb.BOOK_THUMBNAIL_ID);
        boolean bl = false;
        Iterable $this$forEach$iv = joins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RequiredJoin it = (RequiredJoin)element$iv;
            boolean bl2 = false;
            RequiredJoin requiredJoin = it;
            if (requiredJoin instanceof RequiredJoin.ReadList || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadata.INSTANCE) || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.SeriesMetadata.INSTANCE) || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.Media.INSTANCE) || requiredJoin instanceof RequiredJoin.ReadProgress || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE) || requiredJoin instanceof RequiredJoin.Collection) continue;
            throw new NoWhenBranchMatchedException();
        }
        insertValuesStep10.select((Select)selectJoinStep.join((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).join((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).join((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.r.USER_ID.eq((Object)context.getUserId())).leftJoin((TableLike)this.bt).on(this.b.ID.eq((Field)this.bt.BOOK_ID)).and(this.bt.SELECTED.isTrue()).where(condition)).execute();
        SyncPoint syncPoint = this.findByIdOrNull(syncPointId);
        Intrinsics.checkNotNull((Object)syncPoint);
        return syncPoint;
    }

    @Transactional
    public void addOnDeck(@NotNull String syncPointId, @NotNull SearchContext context, @Nullable List<String> filterOnLibraryIds) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getUserId() == null) {
            boolean $i$a$-requireNotNull-SyncPointDao$addOnDeck$22 = false;
            String $i$a$-requireNotNull-SyncPointDao$addOnDeck$22 = "Missing userId in search context";
            throw new IllegalArgumentException($i$a$-requireNotNull-SyncPointDao$addOnDeck$22.toString());
        }
        LocalDateTime createdAt = LocalDateTime.now(ZoneId.of("Z"));
        Triple triple = new Field[3];
        Intrinsics.checkNotNullExpressionValue((Object)DSL.val((String)syncPointId), (String)"val(...)");
        Intrinsics.checkNotNullExpressionValue((Object)DSL.val((String)"KOMGA-ONDECK"), (String)"val(...)");
        Intrinsics.checkNotNullExpressionValue((Object)this.b.ID, (String)"ID");
        Triple onDeckFields = triple;
        triple = this.bookCommonDao.getBooksOnDeckQuery(context.getUserId(), context.getRestrictions(), (Collection)filterOnLibraryIds, (Field[])onDeckFields);
        SelectConditionStep query = (SelectConditionStep)triple.component1();
        SelectJoinStep queryMostRecentDate = (SelectJoinStep)triple.component3();
        int count = this.getDslRW().insertInto((Table)this.sprlb).select((Select)query).execute();
        if (count > 0) {
            List list = this.getDslRW().fetch((ResultQuery)queryMostRecentDate).into(LocalDateTime.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"into(...)");
            LocalDateTime localDateTime = (LocalDateTime)CollectionsKt.firstOrNull((List)list);
            if (localDateTime == null) {
                localDateTime = createdAt;
            }
            LocalDateTime mostRecentDate = localDateTime;
            this.getDslRW().insertInto((Table)this.sprl, (Field)this.sprl.SYNC_POINT_ID, (Field)this.sprl.READLIST_ID, (Field)this.sprl.READLIST_NAME, (Field)this.sprl.READLIST_CREATED_DATE, (Field)this.sprl.READLIST_LAST_MODIFIED_DATE).values((Object)syncPointId, (Object)"KOMGA-ONDECK", (Object)"On Deck", (Object)createdAt, (Object)mostRecentDate).execute();
        }
    }

    @Nullable
    public SyncPoint findByIdOrNull(@NotNull String syncPointId) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        List list = this.getDslRO().selectFrom((TableLike)this.sp).where(this.sp.ID.eq((Object)syncPointId)).fetchInto((Table)this.sp).map((RecordMapper)findByIdOrNull.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (SyncPoint)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public Page<SyncPoint.Book> findBooksById(@NotNull String syncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep $this$findBooksById_u24lambda_u244 = selectConditionStep = this.getDslRO().selectFrom((TableLike)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)syncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findBooksById_u24lambda_u244.and(this.spb.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep;
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"apply(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageBook(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.Book> findBooksAdded(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep $this$findBooksAdded_u24lambda_u245 = selectConditionStep = this.getDslRO().selectFrom((TableLike)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)toSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findBooksAdded_u24lambda_u245.and(this.spb.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(this.spb.BOOK_ID.notIn((Select)this.getDslRO().select((SelectField)this.spb.BOOK_ID).from((TableLike)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)fromSyncPointId))));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageBook(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.Book> findBooksRemoved(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep $this$findBooksRemoved_u24lambda_u246 = selectConditionStep = this.getDslRO().selectFrom((TableLike)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)fromSyncPointId)).and(this.spb.BOOK_ID.notIn((Select)this.getDslRO().select((SelectField)this.spb.BOOK_ID).from((TableLike)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)toSyncPointId))));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findBooksRemoved_u24lambda_u246.and(this.spb.BOOK_ID.notIn((Select)this.getDslRO().select((SelectField)this.spbs.BOOK_ID).from((TableLike)this.spbs).where(this.spbs.SYNC_POINT_ID.eq((Object)toSyncPointId))));
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep;
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"apply(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageBook(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.Book> findBooksChanged(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SyncPointBook syncPointBook = this.spb.as("spbFrom");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointBook, (String)"as(...)");
        SyncPointBook spbFrom = syncPointBook;
        SelectConditionStep selectConditionStep = this.spb.fields();
        SelectConditionStep $this$findBooksChanged_u24lambda_u247 = selectConditionStep = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectConditionStep, ((Field[])selectConditionStep).length)).from((TableLike)this.spb).join((TableLike)spbFrom).on(this.spb.BOOK_ID.eq((Field)spbFrom.BOOK_ID)).where(this.spb.SYNC_POINT_ID.eq((Object)toSyncPointId)).and(spbFrom.SYNC_POINT_ID.eq((Object)fromSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findBooksChanged_u24lambda_u247.and(this.spb.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(this.spb.BOOK_FILE_LAST_MODIFIED.ne((Field)spbFrom.BOOK_FILE_LAST_MODIFIED).or(this.spb.BOOK_FILE_SIZE.ne((Field)spbFrom.BOOK_FILE_SIZE)).or(this.spb.BOOK_FILE_HASH.ne((Field)spbFrom.BOOK_FILE_HASH).and(spbFrom.BOOK_FILE_HASH.isNotNull())).or(this.spb.BOOK_METADATA_LAST_MODIFIED_DATE.ne((Field)spbFrom.BOOK_METADATA_LAST_MODIFIED_DATE)).or(this.spb.BOOK_THUMBNAIL_ID.ne((Field)spbFrom.BOOK_THUMBNAIL_ID)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageBook(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.Book> findBooksReadProgressChanged(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SyncPointBook syncPointBook = this.spb.as("spbFrom");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointBook, (String)"as(...)");
        SyncPointBook spbFrom = syncPointBook;
        SelectConditionStep selectConditionStep = this.spb.fields();
        SelectConditionStep $this$findBooksReadProgressChanged_u24lambda_u248 = selectConditionStep = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectConditionStep, ((Field[])selectConditionStep).length)).from((TableLike)this.spb).join((TableLike)spbFrom).on(this.spb.BOOK_ID.eq((Field)spbFrom.BOOK_ID)).where(this.spb.SYNC_POINT_ID.eq((Object)toSyncPointId)).and(spbFrom.SYNC_POINT_ID.eq((Object)fromSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findBooksReadProgressChanged_u24lambda_u248.and(this.spb.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(this.spb.BOOK_FILE_LAST_MODIFIED.eq((Field)spbFrom.BOOK_FILE_LAST_MODIFIED).and(this.spb.BOOK_FILE_SIZE.eq((Field)spbFrom.BOOK_FILE_SIZE)).and(this.spb.BOOK_FILE_HASH.eq((Field)spbFrom.BOOK_FILE_HASH).or(spbFrom.BOOK_FILE_HASH.isNull())).and(this.spb.BOOK_METADATA_LAST_MODIFIED_DATE.eq((Field)spbFrom.BOOK_METADATA_LAST_MODIFIED_DATE)).and(this.spb.BOOK_THUMBNAIL_ID.eq((Field)spbFrom.BOOK_THUMBNAIL_ID)).and(this.spb.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE.ne((Field)spbFrom.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE).or(this.spb.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE.isNull().and(spbFrom.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE.isNotNull())).or(this.spb.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE.isNotNull().and(spbFrom.BOOK_READ_PROGRESS_LAST_MODIFIED_DATE.isNull()))));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageBook(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.ReadList> findReadListsById(@NotNull String syncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep $this$findReadListsById_u24lambda_u249 = selectConditionStep = this.getDslRO().selectFrom((TableLike)this.sprl).where(this.sprl.SYNC_POINT_ID.eq((Object)syncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findReadListsById_u24lambda_u249.and(this.sprl.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep;
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"apply(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageReadList(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.ReadList> findReadListsAdded(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SyncPointReadlist syncPointReadlist = this.sprl.as("to");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointReadlist, (String)"as(...)");
        SyncPointReadlist to = syncPointReadlist;
        SyncPointReadlist syncPointReadlist2 = this.sprl.as("from");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointReadlist2, (String)"as(...)");
        SyncPointReadlist from = syncPointReadlist2;
        SelectConditionStep selectConditionStep = to.fields();
        SelectConditionStep $this$findReadListsAdded_u24lambda_u2410 = selectConditionStep = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectConditionStep, ((Field[])selectConditionStep).length)).from((TableLike)to).leftOuterJoin((TableLike)from).on(to.READLIST_ID.eq((Field)from.READLIST_ID).and(from.SYNC_POINT_ID.eq((Object)fromSyncPointId))).where(to.SYNC_POINT_ID.eq((Object)toSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findReadListsAdded_u24lambda_u2410.and(to.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(from.READLIST_ID.isNull());
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageReadList(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.ReadList> findReadListsChanged(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SyncPointReadlist syncPointReadlist = this.sprl.as("from");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointReadlist, (String)"as(...)");
        SyncPointReadlist from = syncPointReadlist;
        SelectConditionStep selectConditionStep = this.sprl.fields();
        SelectConditionStep $this$findReadListsChanged_u24lambda_u2411 = selectConditionStep = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectConditionStep, ((Field[])selectConditionStep).length)).from((TableLike)this.sprl).join((TableLike)from).on(this.sprl.READLIST_ID.eq((Field)from.READLIST_ID)).where(this.sprl.SYNC_POINT_ID.eq((Object)toSyncPointId)).and(from.SYNC_POINT_ID.eq((Object)fromSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findReadListsChanged_u24lambda_u2411.and(this.sprl.SYNCED.isFalse());
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(this.sprl.READLIST_LAST_MODIFIED_DATE.ne((Field)from.READLIST_LAST_MODIFIED_DATE).or(this.sprl.READLIST_NAME.ne((Field)from.READLIST_NAME)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageReadList(this.getDslRO(), query, pageable);
    }

    @NotNull
    public Page<SyncPoint.ReadList> findReadListsRemoved(@NotNull String fromSyncPointId, @NotNull String toSyncPointId, boolean onlyNotSynced, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromSyncPointId, (String)"fromSyncPointId");
        Intrinsics.checkNotNullParameter((Object)toSyncPointId, (String)"toSyncPointId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SyncPointReadlist syncPointReadlist = this.sprl.as("from");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointReadlist, (String)"as(...)");
        SyncPointReadlist from = syncPointReadlist;
        SyncPointReadlist syncPointReadlist2 = this.sprl.as("to");
        Intrinsics.checkNotNullExpressionValue((Object)syncPointReadlist2, (String)"as(...)");
        SyncPointReadlist to = syncPointReadlist2;
        SelectConditionStep selectConditionStep = from.fields();
        SelectConditionStep $this$findReadListsRemoved_u24lambda_u2412 = selectConditionStep = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(selectConditionStep, ((Field[])selectConditionStep).length)).from((TableLike)from).leftOuterJoin((TableLike)to).on(from.READLIST_ID.eq((Field)to.READLIST_ID).and(to.SYNC_POINT_ID.eq((Object)toSyncPointId))).where(from.SYNC_POINT_ID.eq((Object)fromSyncPointId));
        boolean bl = false;
        if (onlyNotSynced) {
            $this$findReadListsRemoved_u24lambda_u2412.and(from.READLIST_ID.notIn((Select)this.getDslRO().select((SelectField)this.sprls.READLIST_ID).from((TableLike)this.sprls).where(this.sprls.SYNC_POINT_ID.eq((Object)toSyncPointId))));
        }
        SelectConditionStep selectConditionStep2 = selectConditionStep.and(to.READLIST_ID.isNull());
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"and(...)");
        SelectConditionStep query = selectConditionStep2;
        return this.queryToPageReadList(this.getDslRO(), query, pageable);
    }

    @NotNull
    public List<SyncPoint.ReadList.Book> findBookIdsByReadListIds(@NotNull String syncPointId, @NotNull Collection<String> readListIds) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter(readListIds, (String)"readListIds");
        Field[] fieldArray = this.sprlb.fields();
        List list = this.getDslRO().select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.sprlb).where(this.sprlb.SYNC_POINT_ID.eq((Object)syncPointId)).and(this.sprlb.READLIST_ID.in(readListIds)).fetchInto((Table)this.sprlb).map((RecordMapper)findBookIdsByReadListIds.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public void markBooksSynced(@NotNull String syncPointId, boolean forRemovedBooks, @NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        if (!bookIds.isEmpty()) {
            if (forRemovedBooks) {
                void $this$mapTo$iv$iv;
                BatchBindStep batchBindStep;
                BatchBindStep step = batchBindStep = this.getDslRW().batch((Query)this.getDslRW().insertInto((Table)this.spbs, (Field)this.spbs.SYNC_POINT_ID, (Field)this.spbs.BOOK_ID).values(null, null).onDuplicateKeyIgnore());
                boolean bl = false;
                Iterable $this$map$iv = bookIds;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{syncPointId, it};
                    collection.add(step.bind(objectArray));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                int[] nArray = batchBindStep.execute();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"execute(...)");
                v0 = (Serializable)nArray;
            } else {
                v0 = Integer.valueOf(this.getDslRW().update((Table)this.spb).set((Field)this.spb.SYNCED, (Object)true).where(this.spb.SYNC_POINT_ID.eq((Object)syncPointId)).and(this.spb.BOOK_ID.in(bookIds)).execute());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markReadListsSynced(@NotNull String syncPointId, boolean forRemovedReadLists, @NotNull Collection<String> readListIds) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        Intrinsics.checkNotNullParameter(readListIds, (String)"readListIds");
        if (!readListIds.isEmpty()) {
            if (forRemovedReadLists) {
                void $this$mapTo$iv$iv;
                BatchBindStep batchBindStep;
                BatchBindStep step = batchBindStep = this.getDslRW().batch((Query)this.getDslRW().insertInto((Table)this.sprls, (Field)this.sprls.SYNC_POINT_ID, (Field)this.sprls.READLIST_ID).values(null, null).onDuplicateKeyIgnore());
                boolean bl = false;
                Iterable $this$map$iv = readListIds;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{syncPointId, it};
                    collection.add(step.bind(objectArray));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                int[] nArray = batchBindStep.execute();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"execute(...)");
                v0 = (Serializable)nArray;
            } else {
                v0 = Integer.valueOf(this.getDslRW().update((Table)this.sprl).set((Field)this.sprl.SYNCED, (Object)true).where(this.sprl.SYNC_POINT_ID.eq((Object)syncPointId)).and(this.sprl.READLIST_ID.in(readListIds)).execute());
            }
        }
    }

    public void deleteByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        DSLContext dSLContext = this.getDslRW();
        SelectConditionStep selectConditionStep = this.getDslRW().select((SelectField)this.sp.ID).from((TableLike)this.sp).where(this.sp.USER_ID.eq((Object)userId));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        this.deleteSubEntities(dSLContext, selectConditionStep);
        this.getDslRW().deleteFrom((Table)this.sp).where(this.sp.USER_ID.eq((Object)userId)).execute();
    }

    public void deleteByUserIdAndApiKeyIds(@NotNull String userId, @NotNull Collection<String> apiKeyIds) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(apiKeyIds, (String)"apiKeyIds");
        DSLContext dSLContext = this.getDslRW();
        SelectConditionStep selectConditionStep = this.getDslRW().select((SelectField)this.sp.ID).from((TableLike)this.sp).where(this.sp.USER_ID.eq((Object)userId).and(this.sp.API_KEY_ID.in(apiKeyIds)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        this.deleteSubEntities(dSLContext, selectConditionStep);
        this.getDslRW().deleteFrom((Table)this.sp).where(this.sp.USER_ID.eq((Object)userId).and(this.sp.API_KEY_ID.in(apiKeyIds))).execute();
    }

    private void deleteSubEntities(DSLContext $this$deleteSubEntities, SelectConditionStep<Record1<String>> condition) {
        $this$deleteSubEntities.deleteFrom((Table)this.sprls).where(this.sprls.SYNC_POINT_ID.in((Select)condition)).execute();
        $this$deleteSubEntities.deleteFrom((Table)this.sprlb).where(this.sprlb.SYNC_POINT_ID.in((Select)condition)).execute();
        $this$deleteSubEntities.deleteFrom((Table)this.sprl).where(this.sprl.SYNC_POINT_ID.in((Select)condition)).execute();
        $this$deleteSubEntities.deleteFrom((Table)this.spbs).where(this.spbs.SYNC_POINT_ID.in((Select)condition)).execute();
        $this$deleteSubEntities.deleteFrom((Table)this.spb).where(this.spb.SYNC_POINT_ID.in((Select)condition)).execute();
    }

    public void deleteOne(@NotNull String syncPointId) {
        Intrinsics.checkNotNullParameter((Object)syncPointId, (String)"syncPointId");
        this.getDslRW().deleteFrom((Table)this.sprls).where(this.sprls.SYNC_POINT_ID.eq((Object)syncPointId)).execute();
        this.getDslRW().deleteFrom((Table)this.sprlb).where(this.sprlb.SYNC_POINT_ID.eq((Object)syncPointId)).execute();
        this.getDslRW().deleteFrom((Table)this.sprl).where(this.sprl.SYNC_POINT_ID.eq((Object)syncPointId)).execute();
        this.getDslRW().deleteFrom((Table)this.spbs).where(this.spbs.SYNC_POINT_ID.eq((Object)syncPointId)).execute();
        this.getDslRW().deleteFrom((Table)this.spb).where(this.spb.SYNC_POINT_ID.eq((Object)syncPointId)).execute();
        this.getDslRW().deleteFrom((Table)this.sp).where(this.sp.ID.eq((Object)syncPointId)).execute();
    }

    public void deleteAll() {
        this.getDslRW().deleteFrom((Table)this.sprls).execute();
        this.getDslRW().deleteFrom((Table)this.sprlb).execute();
        this.getDslRW().deleteFrom((Table)this.sprl).execute();
        this.getDslRW().deleteFrom((Table)this.spbs).execute();
        this.getDslRW().deleteFrom((Table)this.spb).execute();
        this.getDslRW().deleteFrom((Table)this.sp).execute();
    }

    private Page<SyncPoint.Book> queryToPageBook(DSLContext $this$queryToPageBook, SelectConditionStep<?> query, Pageable pageable) {
        SelectConditionStep<?> selectConditionStep;
        int count = $this$queryToPageBook.fetchCount((Select)query);
        SelectConditionStep<?> $this$queryToPageBook_u24lambda_u2417 = selectConditionStep = query;
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$queryToPageBook_u24lambda_u2417.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.spb).map((RecordMapper)queryToPageBook.items.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted()) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)Sort.unsorted())), (long)count);
    }

    private Page<SyncPoint.ReadList> queryToPageReadList(DSLContext $this$queryToPageReadList, SelectConditionStep<?> query, Pageable pageable) {
        SelectConditionStep<?> selectConditionStep;
        int count = $this$queryToPageReadList.fetchCount((Select)query);
        SelectConditionStep<?> $this$queryToPageReadList_u24lambda_u2418 = selectConditionStep = query;
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$queryToPageReadList_u24lambda_u2418.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.sprl).map((RecordMapper)queryToPageReadList.items.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted()) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)Sort.unsorted())), (long)count);
    }
}

