/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailReadList;
import org.gotson.komga.domain.persistence.ThumbnailReadListRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.ThumbnailReadlist;
import org.gotson.komga.jooq.main.tables.records.ThumbnailReadlistRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016J\f\u0010\u001d\u001a\u00020\r*\u00020\u001eH\u0012R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ThumbnailReadListDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "tr", "Lorg/gotson/komga/jooq/main/tables/ThumbnailReadlist;", "kotlin.jvm.PlatformType", "findAllByReadListId", "", "Lorg/gotson/komga/domain/model/ThumbnailReadList;", "readListId", "", "findByIdOrNull", "thumbnailId", "findSelectedByReadListIdOrNull", "insert", "", "thumbnail", "update", "markSelected", "delete", "thumbnailReadListId", "deleteByReadListId", "deleteByReadListIds", "readListIds", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/ThumbnailReadlistRecord;", "komga"})
public class ThumbnailReadListDao
extends SplitDslDaoBase
implements ThumbnailReadListRepository {
    private final ThumbnailReadlist tr;

    public ThumbnailReadListDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.tr = Tables.THUMBNAIL_READLIST;
    }

    @NotNull
    public Collection<ThumbnailReadList> findAllByReadListId(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        List list = this.getDslRO().selectFrom((TableLike)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).fetchInto((Table)this.tr).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public ThumbnailReadList findByIdOrNull(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailReadlistRecord thumbnailReadlistRecord = (ThumbnailReadlistRecord)this.getDslRO().selectFrom((TableLike)this.tr).where(this.tr.ID.eq((Object)thumbnailId)).fetchOneInto((Table)this.tr);
        return thumbnailReadlistRecord != null ? this.toDomain(thumbnailReadlistRecord) : null;
    }

    @Nullable
    public ThumbnailReadList findSelectedByReadListIdOrNull(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        List list = this.getDslRO().selectFrom((TableLike)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).and(this.tr.SELECTED.isTrue()).limit((Number)1).fetchInto((Table)this.tr).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (ThumbnailReadList)CollectionsKt.firstOrNull((List)list);
    }

    public void insert(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().insertInto((Table)this.tr).set((Field)this.tr.ID, (Object)thumbnail.getId()).set((Field)this.tr.READLIST_ID, (Object)thumbnail.getReadListId()).set((Field)this.tr.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tr.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tr.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tr.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tr.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tr.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tr.FILE_SIZE, (Object)thumbnail.getFileSize()).execute();
    }

    public void update(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().update((Table)this.tr).set((Field)this.tr.READLIST_ID, (Object)thumbnail.getReadListId()).set((Field)this.tr.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tr.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tr.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tr.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tr.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tr.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tr.FILE_SIZE, (Object)thumbnail.getFileSize()).where(this.tr.ID.eq((Object)thumbnail.getId())).execute();
    }

    @Transactional
    public void markSelected(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().update((Table)this.tr).set((Field)this.tr.SELECTED, (Object)false).where(this.tr.READLIST_ID.eq((Object)thumbnail.getReadListId())).and(this.tr.ID.ne((Object)thumbnail.getId())).execute();
        this.getDslRW().update((Table)this.tr).set((Field)this.tr.SELECTED, (Object)true).where(this.tr.READLIST_ID.eq((Object)thumbnail.getReadListId())).and(this.tr.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void delete(@NotNull String thumbnailReadListId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailReadListId, (String)"thumbnailReadListId");
        this.getDslRW().deleteFrom((Table)this.tr).where(this.tr.ID.eq((Object)thumbnailReadListId)).execute();
    }

    public void deleteByReadListId(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        this.getDslRW().deleteFrom((Table)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).execute();
    }

    public void deleteByReadListIds(@NotNull Collection<String> readListIds) {
        Intrinsics.checkNotNullParameter(readListIds, (String)"readListIds");
        this.getDslRW().deleteFrom((Table)this.tr).where(this.tr.READLIST_ID.in(readListIds)).execute();
    }

    private ThumbnailReadList toDomain(ThumbnailReadlistRecord $this$toDomain) {
        byte[] byArray = $this$toDomain.getThumbnail();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getThumbnail(...)");
        Boolean bl = $this$toDomain.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSelected(...)");
        boolean bl2 = bl;
        String string = $this$toDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        ThumbnailReadList.Type type = ThumbnailReadList.Type.valueOf((String)string);
        String string2 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMediaType(...)");
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        Integer n = $this$toDomain.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = $this$toDomain.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
        Dimension dimension = new Dimension(n2, ((Number)n3).intValue());
        String string3 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        String string4 = $this$toDomain.getReadlistId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getReadlistId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        return new ThumbnailReadList(byArray, bl2, type, string2, l2, dimension, string3, string4, localDateTime, localDateTime2);
    }

    public static final /* synthetic */ ThumbnailReadList access$toDomain(ThumbnailReadListDao $this, ThumbnailReadlistRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

