/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.ThumbnailCollection;
import org.gotson.komga.jooq.main.tables.records.ThumbnailCollectionRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\f\u0010\u001d\u001a\u00020\f*\u00020\u001eH\u0012R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ThumbnailSeriesCollectionDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "tc", "Lorg/gotson/komga/jooq/main/tables/ThumbnailCollection;", "kotlin.jvm.PlatformType", "findByIdOrNull", "Lorg/gotson/komga/domain/model/ThumbnailSeriesCollection;", "thumbnailId", "", "findSelectedByCollectionIdOrNull", "collectionId", "findAllByCollectionId", "", "insert", "", "thumbnail", "update", "markSelected", "delete", "thumbnailCollectionId", "deleteByCollectionId", "deleteByCollectionIds", "collectionIds", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/ThumbnailCollectionRecord;", "komga"})
public class ThumbnailSeriesCollectionDao
extends SplitDslDaoBase
implements ThumbnailSeriesCollectionRepository {
    private final ThumbnailCollection tc;

    public ThumbnailSeriesCollectionDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.tc = Tables.THUMBNAIL_COLLECTION;
    }

    @Nullable
    public ThumbnailSeriesCollection findByIdOrNull(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailCollectionRecord thumbnailCollectionRecord = (ThumbnailCollectionRecord)this.getDslRO().selectFrom((TableLike)this.tc).where(this.tc.ID.eq((Object)thumbnailId)).fetchOneInto((Table)this.tc);
        return thumbnailCollectionRecord != null ? this.toDomain(thumbnailCollectionRecord) : null;
    }

    @Nullable
    public ThumbnailSeriesCollection findSelectedByCollectionIdOrNull(@NotNull String collectionId) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        List list = this.getDslRO().selectFrom((TableLike)this.tc).where(this.tc.COLLECTION_ID.eq((Object)collectionId)).and(this.tc.SELECTED.isTrue()).limit((Number)1).fetchInto((Table)this.tc).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (ThumbnailSeriesCollection)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public Collection<ThumbnailSeriesCollection> findAllByCollectionId(@NotNull String collectionId) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        List list = this.getDslRO().selectFrom((TableLike)this.tc).where(this.tc.COLLECTION_ID.eq((Object)collectionId)).fetchInto((Table)this.tc).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    public void insert(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().insertInto((Table)this.tc).set((Field)this.tc.ID, (Object)thumbnail.getId()).set((Field)this.tc.COLLECTION_ID, (Object)thumbnail.getCollectionId()).set((Field)this.tc.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tc.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tc.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tc.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tc.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tc.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tc.FILE_SIZE, (Object)thumbnail.getFileSize()).execute();
    }

    public void update(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().update((Table)this.tc).set((Field)this.tc.COLLECTION_ID, (Object)thumbnail.getCollectionId()).set((Field)this.tc.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tc.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tc.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tc.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tc.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tc.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tc.FILE_SIZE, (Object)thumbnail.getFileSize()).where(this.tc.ID.eq((Object)thumbnail.getId())).execute();
    }

    @Transactional
    public void markSelected(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.getDslRW().update((Table)this.tc).set((Field)this.tc.SELECTED, (Object)false).where(this.tc.COLLECTION_ID.eq((Object)thumbnail.getCollectionId())).and(this.tc.ID.ne((Object)thumbnail.getId())).execute();
        this.getDslRW().update((Table)this.tc).set((Field)this.tc.SELECTED, (Object)true).where(this.tc.COLLECTION_ID.eq((Object)thumbnail.getCollectionId())).and(this.tc.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void delete(@NotNull String thumbnailCollectionId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailCollectionId, (String)"thumbnailCollectionId");
        this.getDslRW().deleteFrom((Table)this.tc).where(this.tc.ID.eq((Object)thumbnailCollectionId)).execute();
    }

    public void deleteByCollectionId(@NotNull String collectionId) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        this.getDslRW().deleteFrom((Table)this.tc).where(this.tc.COLLECTION_ID.eq((Object)collectionId)).execute();
    }

    public void deleteByCollectionIds(@NotNull Collection<String> collectionIds) {
        Intrinsics.checkNotNullParameter(collectionIds, (String)"collectionIds");
        this.getDslRW().deleteFrom((Table)this.tc).where(this.tc.COLLECTION_ID.in(collectionIds)).execute();
    }

    private ThumbnailSeriesCollection toDomain(ThumbnailCollectionRecord $this$toDomain) {
        byte[] byArray = $this$toDomain.getThumbnail();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getThumbnail(...)");
        Boolean bl = $this$toDomain.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSelected(...)");
        boolean bl2 = bl;
        String string = $this$toDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        ThumbnailSeriesCollection.Type type = ThumbnailSeriesCollection.Type.valueOf((String)string);
        String string2 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMediaType(...)");
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        Integer n = $this$toDomain.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = $this$toDomain.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
        Dimension dimension = new Dimension(n2, ((Number)n3).intValue());
        String string3 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        String string4 = $this$toDomain.getCollectionId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCollectionId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        return new ThumbnailSeriesCollection(byArray, bl2, type, string2, l2, dimension, string3, string4, localDateTime, localDateTime2);
    }

    public static final /* synthetic */ ThumbnailSeriesCollection access$toDomain(ThumbnailSeriesCollectionDao $this, ThumbnailCollectionRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

