/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.configuration.SettingChangedEvent;
import org.gotson.komga.infrastructure.kobo.KepubConverterKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0013J\b\u0010\u0018\u001a\u00020\u0017H\u0013J\u001c\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000bH\u0012J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u000bH\u0016J\u001e\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u000b2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u000b8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "", "settingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "kepubifyConfigurationPath", "", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Ljava/lang/String;)V", "getKepubifyConfigurationPath", "()Ljava/lang/String;", "value", "Ljava/nio/file/Path;", "kepubifyPath", "getKepubifyPath", "()Ljava/nio/file/Path;", "", "isAvailable", "()Z", "tmpDir", "getTmpDir", "tmpDir$delegate", "Lkotlin/Lazy;", "configureKepubifyOnStartup", "", "configureKepubifyOnSettingsChange", "configureKepubify", "newValue", "fallback", "isExecutable", "path", "convertEpubToKepub", "bookWithMedia", "Lorg/gotson/komga/domain/model/BookWithMedia;", "destinationDir", "convertEpubToKepubWithoutChecks", "epub", "komga"})
@SourceDebugExtension(value={"SMAP\nKepubConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KepubConverter.kt\norg/gotson/komga/infrastructure/kobo/KepubConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,170:1\n1#2:171\n1#2:173\n1#2:175\n57#3:172\n57#3:174\n*S KotlinDebug\n*F\n+ 1 KepubConverter.kt\norg/gotson/komga/infrastructure/kobo/KepubConverter\n*L\n154#1:173\n159#1:175\n154#1:172\n159#1:174\n*E\n"})
public class KepubConverter {
    @NotNull
    private final KomgaSettingsProvider settingsProvider;
    @Nullable
    private final String kepubifyConfigurationPath;
    @Nullable
    private Path kepubifyPath;
    private boolean isAvailable;
    @NotNull
    private final Lazy tmpDir$delegate;

    public KepubConverter(@NotNull KomgaSettingsProvider settingsProvider, @Value(value="${komga.kobo.kepubify-path:#{null}}") @Nullable String kepubifyConfigurationPath) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        this.settingsProvider = settingsProvider;
        this.kepubifyConfigurationPath = kepubifyConfigurationPath;
        this.tmpDir$delegate = LazyKt.lazy(KepubConverter::tmpDir_delegate$lambda$0);
    }

    @Nullable
    public String getKepubifyConfigurationPath() {
        return this.kepubifyConfigurationPath;
    }

    @Nullable
    public final Path getKepubifyPath() {
        return this.kepubifyPath;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    private Path getTmpDir() {
        Lazy lazy = this.tmpDir$delegate;
        return (Path)lazy.getValue();
    }

    @PostConstruct
    private void configureKepubifyOnStartup() {
        CharSequence charSequence = this.settingsProvider.getKepubifyPath();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.configureKepubify(this.settingsProvider.getKepubifyPath(), true);
        } else {
            charSequence = this.getKepubifyConfigurationPath();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
            } else {
                KepubConverterKt.access$getLogger$p().info(KepubConverter::configureKepubifyOnStartup$lambda$1);
            }
        }
    }

    @EventListener(value={SettingChangedEvent.KepubifyPath.class})
    private void configureKepubifyOnSettingsChange() {
        this.configureKepubify(this.settingsProvider.getKepubifyPath(), true);
    }

    public void configureKepubify(@Nullable String newValue, boolean fallback) {
        CharSequence charSequence = newValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.isAvailable = false;
            this.kepubifyPath = null;
            if (fallback && !((charSequence = (CharSequence)this.getKepubifyConfigurationPath()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
            }
        } else {
            Path path = Paths.get(newValue, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path newPath = path;
            if (!this.isExecutable(newPath)) {
                CharSequence charSequence2;
                KepubConverterKt.access$getLogger$p().warn(() -> KepubConverter.configureKepubify$lambda$2(newPath));
                this.isAvailable = false;
                if (fallback && !((charSequence2 = (CharSequence)this.getKepubifyConfigurationPath()) == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    KepubConverter.configureKepubify$default((KepubConverter)this, (String)this.getKepubifyConfigurationPath(), (boolean)false, (int)2, null);
                }
            } else {
                KepubConverterKt.access$getLogger$p().info(() -> KepubConverter.configureKepubify$lambda$3(newPath));
                this.isAvailable = true;
            }
            this.kepubifyPath = newPath;
        }
    }

    public static /* synthetic */ void configureKepubify$default(KepubConverter kepubConverter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureKepubify");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        kepubConverter.configureKepubify(string, bl);
    }

    private boolean isExecutable(Path path) {
        try {
            if (Files.isExecutable(path)) {
                return true;
            }
            Process process = Runtime.getRuntime().exec(((Object)path).toString());
            process.waitFor(3L, TimeUnit.SECONDS);
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            KepubConverterKt.access$getLogger$p().warn((Throwable)e, () -> KepubConverter.isExecutable$lambda$4(path));
            return false;
        }
    }

    @Nullable
    public Path convertEpubToKepub(@NotNull BookWithMedia bookWithMedia, @Nullable Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)bookWithMedia, (String)"bookWithMedia");
        if (!Intrinsics.areEqual((Object)bookWithMedia.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
            boolean $i$a$-require-KepubConverter$convertEpubToKepub$42 = false;
            String $i$a$-require-KepubConverter$convertEpubToKepub$42 = "Cannot convert, not an EPUB: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepub$42.toString());
        }
        if (!(!bookWithMedia.getMedia().getEpubIsKepub())) {
            boolean $i$a$-require-KepubConverter$convertEpubToKepub$52 = false;
            String $i$a$-require-KepubConverter$convertEpubToKepub$52 = "Cannot convert, EPUB is already a KEPUB: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepub$52.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(bookWithMedia.getBook().getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "Source file does not exist: " + bookWithMedia.getBook().getPath();
            throw new IllegalArgumentException(string.toString());
        }
        return this.convertEpubToKepubWithoutChecks(bookWithMedia.getBook().getPath(), destinationDir);
    }

    public static /* synthetic */ Path convertEpubToKepub$default(KepubConverter kepubConverter, BookWithMedia bookWithMedia, Path path, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertEpubToKepub");
        }
        if ((n & 2) != 0) {
            path = null;
        }
        return kepubConverter.convertEpubToKepub(bookWithMedia, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path convertEpubToKepubWithoutChecks(@NotNull Path epub, @Nullable Path destinationDir) {
        Process process;
        Path path;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        if (!this.isAvailable) {
            boolean $i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22 = false;
            String $i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22 = "Kepub conversion is not available, kepubify path may not be set, or may be invalid";
            throw new IllegalStateException($i$a$-check-KepubConverter$convertEpubToKepubWithoutChecks$22.toString());
        }
        if (destinationDir != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(destinationDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32 = false;
                String $i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32 = "Destination directory does not exist: " + destinationDir;
                throw new IllegalArgumentException($i$a$-require-KepubConverter$convertEpubToKepubWithoutChecks$32.toString());
            }
        }
        if ((path = destinationDir) == null) {
            path = this.getTmpDir();
        }
        Path destinationPath = path.resolve(PathsKt.getNameWithoutExtension((Path)epub) + ".kepub.epub");
        Intrinsics.checkNotNull((Object)destinationPath);
        Files.deleteIfExists(destinationPath);
        String[] stringArray = new String[]{String.valueOf(this.kepubifyPath), ((Object)epub).toString(), "-o", ((Object)destinationPath).toString()};
        String[] command = stringArray;
        KepubConverterKt.access$getLogger$p().debug(() -> KepubConverter.convertEpubToKepubWithoutChecks$lambda$10(command));
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            KepubConverterKt.access$getLogger$p().error((Throwable)e, KepubConverter::convertEpubToKepubWithoutChecks$lambda$11);
            return null;
        }
        Process process2 = process;
        if (!process2.waitFor(10L, TimeUnit.SECONDS)) {
            KepubConverterKt.access$getLogger$p().error(() -> KepubConverter.convertEpubToKepubWithoutChecks$lambda$12(command));
            return null;
        }
        if (process2.exitValue() != 0) {
            String string;
            BufferedReader bufferedReader = process2.errorReader();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"errorReader(...)");
            Reader $this$useLines$iv = bufferedReader;
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            closeable = (BufferedReader)closeable;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                string = SequencesKt.joinToString$default((Sequence)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String error = string;
            KepubConverterKt.access$getLogger$p().error(() -> KepubConverter.convertEpubToKepubWithoutChecks$lambda$14(command, error));
            return null;
        }
        KepubConverterKt.access$getLogger$p().debug(() -> KepubConverter.convertEpubToKepubWithoutChecks$lambda$16(process2));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(destinationPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            KepubConverterKt.access$getLogger$p().error(() -> KepubConverter.convertEpubToKepubWithoutChecks$lambda$17(destinationPath));
            return null;
        }
        return destinationPath;
    }

    public static /* synthetic */ Path convertEpubToKepubWithoutChecks$default(KepubConverter kepubConverter, Path path, Path path2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertEpubToKepubWithoutChecks");
        }
        if ((n & 2) != 0) {
            path2 = null;
        }
        return kepubConverter.convertEpubToKepubWithoutChecks(path, path2);
    }

    private static final Path tmpDir_delegate$lambda$0() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    private static final Object configureKepubifyOnStartup$lambda$1() {
        return "Kepub conversion unavailable. kepubify path is not set";
    }

    private static final Object configureKepubify$lambda$2(Path $newPath) {
        return "kepubify path is not executable, not found or not valid: " + $newPath;
    }

    private static final Object configureKepubify$lambda$3(Path $newPath) {
        return "Kepub conversion available. kepubify path: " + $newPath;
    }

    private static final Object isExecutable$lambda$4(Path $path) {
        return "Error while verifying executable: " + $path;
    }

    private static final Object convertEpubToKepubWithoutChecks$lambda$10(String[] $command) {
        return "Starting conversion with: " + ArraysKt.joinToString$default((Object[])$command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final Object convertEpubToKepubWithoutChecks$lambda$11() {
        return "Failed to create process";
    }

    private static final Object convertEpubToKepubWithoutChecks$lambda$12(String[] $command) {
        return "Kepub conversion timeout. Command: " + ArraysKt.joinToString$default((Object[])$command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final Object convertEpubToKepubWithoutChecks$lambda$14(String[] $command, String $error) {
        return "Kepub conversion failed. Command: " + ArraysKt.joinToString$default((Object[])$command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ". Error: " + $error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object convertEpubToKepubWithoutChecks$lambda$16(Process $process) {
        String string;
        BufferedReader bufferedReader = $process.inputReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"inputReader(...)");
        Reader $this$useLines$iv = bufferedReader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        closeable = (BufferedReader)closeable;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            string = SequencesKt.joinToString$default((Sequence)it, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return "kepubify output: " + string;
    }

    private static final Object convertEpubToKepubWithoutChecks$lambda$17(Path $destinationPath) {
        return "Converted file not found: " + $destinationPath;
    }
}

