/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.epub;

import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.ISBNValidator;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.BCP47TagValidator;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataFromBookProvider;
import org.gotson.komga.infrastructure.metadata.epub.EpubMetadataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\tH\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider;", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataFromBookProvider;", "isbnValidator", "Lorg/apache/commons/validator/routines/ISBNValidator;", "<init>", "(Lorg/apache/commons/validator/routines/ISBNValidator;)V", "relators", "", "", "capabilities", "", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "getCapabilities", "()Ljava/util/Set;", "getBookMetadataFromBook", "Lorg/gotson/komga/domain/model/BookMetadataPatch;", "book", "Lorg/gotson/komga/domain/model/BookWithMedia;", "supportsAppendVolume", "", "getSupportsAppendVolume", "()Z", "getSeriesMetadataFromBook", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "appendVolumeToTitle", "shouldLibraryHandlePatch", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "parseDate", "Ljava/time/LocalDate;", "date", "komga"})
@SourceDebugExtension(value={"SMAP\nEpubMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubMetadataProvider.kt\norg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1#2:181\n1#2:198\n1#2:215\n1193#3,2:182\n1267#3,4:184\n1617#3,9:188\n1869#3:197\n1870#3:199\n1626#3:200\n1563#3:201\n1634#3,3:202\n1617#3,9:205\n1869#3:214\n1870#3:216\n1626#3:217\n*S KotlinDebug\n*F\n+ 1 EpubMetadataProvider.kt\norg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider\n*L\n70#1:198\n125#1:215\n66#1:182,2\n66#1:184,4\n70#1:188,9\n70#1:197\n70#1:199\n70#1:200\n85#1:201\n85#1:202,3\n125#1:205,9\n125#1:214\n125#1:216\n125#1:217\n*E\n"})
public class EpubMetadataProvider
implements BookMetadataProvider,
SeriesMetadataFromBookProvider {
    @NotNull
    private final ISBNValidator isbnValidator;
    @NotNull
    private final Map<String, String> relators;
    @NotNull
    private final Set<BookMetadataPatchCapability> capabilities;
    private final boolean supportsAppendVolume;

    public EpubMetadataProvider(@NotNull ISBNValidator isbnValidator) {
        Intrinsics.checkNotNullParameter((Object)isbnValidator, (String)"isbnValidator");
        this.isbnValidator = isbnValidator;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"aut", (Object)"writer"), TuplesKt.to((Object)"clr", (Object)"colorist"), TuplesKt.to((Object)"cov", (Object)"cover"), TuplesKt.to((Object)"edt", (Object)"editor"), TuplesKt.to((Object)"art", (Object)"penciller"), TuplesKt.to((Object)"ill", (Object)"penciller"), TuplesKt.to((Object)"trl", (Object)"translator")};
        this.relators = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new BookMetadataPatchCapability[]{BookMetadataPatchCapability.TITLE, BookMetadataPatchCapability.SUMMARY, BookMetadataPatchCapability.RELEASE_DATE, BookMetadataPatchCapability.AUTHORS, BookMetadataPatchCapability.ISBN};
        this.capabilities = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public Set<BookMetadataPatchCapability> getCapabilities() {
        return this.capabilities;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public BookMetadataPatch getBookMetadataFromBook(@NotNull BookWithMedia book) {
        block36: {
            block35: {
                Intrinsics.checkNotNullParameter((Object)book, (String)"book");
                if (!Intrinsics.areEqual((Object)book.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
                    return null;
                }
                var2_2 = EpubKt.getPackageFileContent((Path)book.getBook().getPath());
                if (var2_2 == null) break block36;
                packageFile = var2_2;
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1 = false;
                v0 = Jsoup.parse((String)packageFile, (String)"", (Parser)Parser.xmlParser());
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"parse(...)");
                opf = v0;
                v1 /* !! */  = opf.selectFirst("*|metadata > *|title");
                if (v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .text()) != null) {
                    var6_6 = (CharSequence)v1 /* !! */ ;
                    if (StringsKt.isBlank((CharSequence)var6_6)) {
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = false;
                        v2 = null;
                    } else {
                        v2 = var6_6;
                    }
                    v3 = (String)v2;
                } else {
                    v3 = null;
                }
                title = v3;
                var9_11 = opf.selectFirst("*|metadata > *|description");
                if (var9_11 == null || (var6_6 = var9_11.text()) == null) ** GOTO lbl-1000
                it = var6_6;
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$description$1 = false;
                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = Jsoup.clean((String)it, (Safelist)Safelist.none());
                if ($i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 != null) {
                    var12_21 = $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1;
                    if (StringsKt.isBlank((CharSequence)var12_21)) {
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$description$2 = false;
                        v4 = null;
                    } else {
                        v4 = var12_21;
                    }
                    v5 = (String)v4;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = description = null;
                }
                if ((v6 /* !! */  = opf.selectFirst("*|metadata > *|date")) != null && (v6 /* !! */  = v6 /* !! */ .text()) != null) {
                    it /* !! */  = v6 /* !! */ ;
                    $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$date$1 = false;
                    v7 = this.parseDate((String)it /* !! */ );
                } else {
                    v7 = null;
                }
                date = v7;
                v8 = opf.select("*|metadata > *|meta[property=role][scheme=marc:relators]");
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"select(...)");
                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = (Iterable)v8;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$date$1 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var18_36 = destination$iv$iv;
                    it = (Element)element$iv$iv;
                    $i$a$-associate-EpubMetadataProvider$getBookMetadataFromBook$1$authorRoles$1 = false;
                    v9 = it.attr("refines");
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"attr(...)");
                    it = TuplesKt.to((Object)StringsKt.removePrefix((String)v9, (CharSequence)"#"), (Object)it.text());
                    var18_36.put(it.getFirst(), it.getSecond());
                }
                authorRoles = destination$iv$iv;
                v10 = opf.select("*|metadata > *|creator");
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"select(...)");
                $i$f$associate = (Iterable)v10;
                $i$f$mapNotNull = false;
                $this$associateTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var18_36 = $this$forEach$iv$iv$iv.iterator();
                while (var18_36.hasNext()) {
                    element$iv$iv = element$iv$iv$iv /* !! */  = var18_36.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    el = (Element)element$iv$iv;
                    $i$a$-mapNotNull-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1 = false;
                    v11 = el.text();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"text(...)");
                    name = StringsKt.trim((CharSequence)v11).toString();
                    if (StringsKt.isBlank((CharSequence)name)) {
                        v12 = null;
                    } else {
                        var25_46 = el.attr("opf:role");
                        if (StringsKt.isBlank((CharSequence)var25_46)) {
                            $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1 = false;
                            v13 = null;
                        } else {
                            v13 = var25_46;
                        }
                        opfRole = (String)v13;
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1 = el.attr("id");
                        if (StringsKt.isBlank((CharSequence)$i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1)) {
                            $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$id$1 = false;
                            v14 = null;
                        } else {
                            v14 = $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1;
                        }
                        id = (String)v14;
                        v15 = (String)authorRoles.get(id);
                        if (v15 != null) {
                            var29_51 = v15;
                            if (StringsKt.isBlank((CharSequence)var29_51)) {
                                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$refineRole$1 = false;
                                v16 = null;
                            } else {
                                v16 = var29_51;
                            }
                            v17 = (String)v16;
                        } else {
                            v17 = refineRole = null;
                        }
                        if ((v18 = opfRole) == null) {
                            v18 = refineRole;
                        }
                        if ((v19 = (String)this.relators.get(v18)) == null) {
                            v19 = "writer";
                        }
                        v12 = new Author(name, v19);
                    }
                    if (v12 == null) continue;
                    it$iv$iv = v12;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                if ($this$mapNotNull$iv.isEmpty()) {
                    $i$a$-ifEmpty-EpubMetadataProvider$getBookMetadataFromBook$1$authors$2 = false;
                    v20 = null;
                } else {
                    v20 = $this$mapNotNull$iv;
                }
                authors = (List)v20;
                v21 = opf.select("*|metadata > *|identifier");
                Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"select(...)");
                $i$a$-ifEmpty-EpubMetadataProvider$getBookMetadataFromBook$1$authors$2 = (Iterable)v21;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    element$iv$iv$iv /* !! */  = (Element)item$iv$iv;
                    var33_55 = destination$iv$iv;
                    $i$a$-map-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$1 = false;
                    v22 = it.text();
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"text(...)");
                    v23 = v22.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"toLowerCase(...)");
                    var33_55.add(StringsKt.removePrefix((String)v23, (CharSequence)"isbn:"));
                }
                for (String it : (Iterable)((List)destination$iv$iv)) {
                    $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 = false;
                    var14_25 = this.isbnValidator.validate(it);
                    if (var14_25 == null) continue;
                    v24 = var14_25;
                    break block35;
                }
                v24 = null;
            }
            isbn = v24;
            var11_20 = opf.selectFirst("*|metadata > *|meta[property=belongs-to-collection]");
            if (var11_20 == null || (var14_25 = var11_20.attr("id")) == null) ** GOTO lbl-1000
            id = var14_25;
            $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$seriesIndex$1 = false;
            $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 = opf.selectFirst("*|metadata > *|meta[refines=#" + id + "][property=group-position]");
            if ($i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 != null) {
                v25 = $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2.text();
            } else lbl-1000:
            // 2 sources

            {
                v25 = null;
            }
            v26 = seriesIndex = v25;
            if (v26 != null) {
                var14_25 = v26;
                if (StringsKt.isBlank((CharSequence)var14_25)) {
                    $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$1 = false;
                    v27 /* !! */  = null;
                } else {
                    v27 /* !! */  = var14_25;
                }
                v28 /* !! */  = v27 /* !! */ ;
            } else {
                v28 /* !! */  = null;
            }
            var11_20 = v28 /* !! */ ;
            v29 = seriesIndex;
            var14_25 = v29 != null ? StringsKt.toFloatOrNull(v29) : null;
            return new BookMetadataPatch(title, description, (String)var11_20, (Float)var14_25, date, authors, isbn, null, null, null, 896, null);
        }
        return null;
    }

    public boolean getSupportsAppendVolume() {
        return this.supportsAppendVolume;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SeriesMetadataPatch getSeriesMetadataFromBook(@NotNull BookWithMedia book, boolean appendVolumeToTitle) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!Intrinsics.areEqual((Object)book.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
            return null;
        }
        String string = EpubKt.getPackageFileContent((Path)book.getBook().getPath());
        if (string != null) {
            Object object;
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            Collection $this$mapNotNull$iv;
            String string2;
            Object object2;
            String publisher;
            Object object3;
            String series;
            String packageFile = string;
            boolean bl = false;
            Document document = Jsoup.parse((String)packageFile, (String)"", (Parser)Parser.xmlParser());
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document opf = document;
            Object object4 = opf.selectFirst("*|metadata > *|meta[property=belongs-to-collection]");
            if (object4 != null && (object4 = object4.text()) != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = (CharSequence)object4;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                v3 = (String)charSequence;
            } else {
                v3 = series = null;
            }
            if ((object3 = opf.selectFirst("*|metadata > *|publisher")) != null && (object3 = object3.text()) != null) {
                CharSequence charSequence;
                CharSequence bl2 = (CharSequence)object3;
                if (StringsKt.isBlank((CharSequence)bl2)) {
                    boolean bl3 = false;
                    charSequence = null;
                } else {
                    charSequence = bl2;
                }
                v6 = (String)charSequence;
            } else {
                v6 = publisher = null;
            }
            if ((object2 = opf.selectFirst("*|metadata > *|language")) != null && (object2 = object2.text()) != null) {
                CharSequence charSequence;
                CharSequence bl3 = (CharSequence)object2;
                if (StringsKt.isBlank((CharSequence)bl3)) {
                    boolean bl4 = false;
                    charSequence = null;
                } else {
                    charSequence = bl3;
                }
                string2 = (String)charSequence;
            } else {
                string2 = null;
            }
            String language = string2;
            Elements elements = opf.select("*|metadata > *|subject");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable bl2 = (Iterable)elements;
            boolean $i$f$mapNotNull = false;
            void bl4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                CharSequence charSequence;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                Element it = (Element)element$iv$iv;
                boolean bl6 = false;
                String string3 = it.text();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text(...)");
                CharSequence charSequence3 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    boolean bl7 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence3;
                }
                if ((String)charSequence == null) continue;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if ($this$mapNotNull$iv.isEmpty()) {
                boolean bl9 = false;
                collection = null;
            } else {
                collection = $this$mapNotNull$iv;
            }
            Set genres = (Set)collection;
            Object object5 = opf.selectFirst("*|spine");
            if (object5 != null && (object5 = object5.attr("page-progression-direction")) != null) {
                Object it = object5;
                boolean bl10 = false;
                Object object6 = it;
                object = Intrinsics.areEqual((Object)object6, (Object)"rtl") ? SeriesMetadata.ReadingDirection.RIGHT_TO_LEFT : (Intrinsics.areEqual((Object)object6, (Object)"ltr") ? SeriesMetadata.ReadingDirection.LEFT_TO_RIGHT : null);
            } else {
                object = null;
            }
            SeriesMetadata.ReadingDirection direction = object;
            String string4 = language != null && BCP47TagValidator.INSTANCE.isValid(language) ? BCP47TagValidator.INSTANCE.normalize(language) : null;
            Set set = SetsKt.emptySet();
            return new SeriesMetadataPatch(series, series, null, null, direction, publisher, null, string4, genres, null, set);
        }
        return null;
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1 -> library.getImportEpubBook();
            case 2 -> library.getImportEpubSeries();
            default -> false;
        };
    }

    private LocalDate parseDate(String date) {
        LocalDate localDate;
        try {
            localDate = LocalDate.parse(date, DateTimeFormatter.ISO_DATE);
        }
        catch (Exception e) {
            LocalDate localDate2;
            try {
                localDate2 = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (Exception e2) {
                LocalDate localDate3;
                try {
                    localDate3 = LocalDate.parse(date, DateTimeFormatter.ISO_DATE_TIME);
                }
                catch (Exception e3) {
                    localDate3 = null;
                }
                localDate2 = localDate3;
            }
            localDate = localDate2;
        }
        return localDate;
    }
}

