/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.localartwork;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.metadata.localartwork.LocalArtworkProviderKt;
import org.gotson.komga.infrastructure.sidecar.SidecarBookConsumer;
import org.gotson.komga.infrastructure.sidecar.SidecarSeriesConsumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\""}, d2={"Lorg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider;", "Lorg/gotson/komga/infrastructure/sidecar/SidecarSeriesConsumer;", "Lorg/gotson/komga/infrastructure/sidecar/SidecarBookConsumer;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "<init>", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "supportedExtensions", "", "", "getSupportedExtensions", "()Ljava/util/List;", "supportedSeriesFiles", "getSupportedSeriesFiles", "getBookThumbnails", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "book", "Lorg/gotson/komga/domain/model/Book;", "getSeriesThumbnails", "Lorg/gotson/komga/domain/model/ThumbnailSeries;", "series", "Lorg/gotson/komga/domain/model/Series;", "getSidecarBookType", "Lorg/gotson/komga/domain/model/Sidecar$Type;", "getSidecarBookPrefilter", "Lkotlin/text/Regex;", "isSidecarBookMatch", "", "basename", "sidecar", "getSidecarSeriesType", "getSidecarSeriesFilenames", "komga"})
@SourceDebugExtension(value={"SMAP\nLocalArtworkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtworkProvider.kt\norg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1563#2:110\n1634#2,3:111\n1374#2:114\n1460#2,2:115\n1563#2:117\n1634#2,3:118\n1462#2,3:121\n*S KotlinDebug\n*F\n+ 1 LocalArtworkProvider.kt\norg/gotson/komga/infrastructure/metadata/localartwork/LocalArtworkProvider\n*L\n95#1:110\n95#1:111,3\n105#1:114\n105#1:115,2\n106#1:117\n106#1:118,3\n105#1:121,3\n*E\n"})
public class LocalArtworkProvider
implements SidecarSeriesConsumer,
SidecarBookConsumer {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final List<String> supportedExtensions;
    @NotNull
    private final List<String> supportedSeriesFiles;

    public LocalArtworkProvider(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        Object[] objectArray = new String[]{"png", "jpeg", "jpg", "tbn", "webp", "gif"};
        this.supportedExtensions = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"cover", "default", "folder", "poster", "series"};
        this.supportedSeriesFiles = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    @NotNull
    public List<String> getSupportedSeriesFiles() {
        return this.supportedSeriesFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ThumbnailBook> getBookThumbnails(@NotNull Book book) {
        List list;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        LocalArtworkProviderKt.access$getLogger$p().info(() -> LocalArtworkProvider.getBookThumbnails$lambda$0(book));
        Path bookPath = book.getPath();
        String baseName = PathsKt.getNameWithoutExtension((Path)bookPath);
        Regex regex = new Regex(Regex.Companion.escape(baseName) + "(-\\d+)?", RegexOption.IGNORE_CASE);
        AutoCloseable autoCloseable = Files.list(bookPath.getParent());
        Throwable throwable = null;
        try {
            Stream dirStream = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dirStream);
            list = SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), LocalArtworkProvider::getBookThumbnails$lambda$7$lambda$1), arg_0 -> LocalArtworkProvider.getBookThumbnails$lambda$7$lambda$2(regex, arg_0)), arg_0 -> LocalArtworkProvider.getBookThumbnails$lambda$7$lambda$3(this, arg_0)), arg_0 -> LocalArtworkProvider.getBookThumbnails$lambda$7$lambda$4(this, arg_0)), (arg_0, arg_1) -> LocalArtworkProvider.getBookThumbnails$lambda$7$lambda$6(book, this, arg_0, arg_1)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ThumbnailSeries> getSeriesThumbnails(@NotNull Series series) {
        List list;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        if (series.getOneshot()) {
            LocalArtworkProviderKt.access$getLogger$p().debug(LocalArtworkProvider::getSeriesThumbnails$lambda$8);
            return CollectionsKt.emptyList();
        }
        LocalArtworkProviderKt.access$getLogger$p().info(() -> LocalArtworkProvider.getSeriesThumbnails$lambda$9(series));
        AutoCloseable autoCloseable = Files.list(series.getPath());
        Throwable throwable = null;
        try {
            Stream dirStream = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dirStream);
            list = SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), LocalArtworkProvider::getSeriesThumbnails$lambda$16$lambda$10), arg_0 -> LocalArtworkProvider.getSeriesThumbnails$lambda$16$lambda$11(this, arg_0)), arg_0 -> LocalArtworkProvider.getSeriesThumbnails$lambda$16$lambda$12(this, arg_0)), arg_0 -> LocalArtworkProvider.getSeriesThumbnails$lambda$16$lambda$13(this, arg_0)), (arg_0, arg_1) -> LocalArtworkProvider.getSeriesThumbnails$lambda$16$lambda$15(series, this, arg_0, arg_1)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public Sidecar.Type getSidecarBookType() {
        return Sidecar.Type.ARTWORK;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Regex> getSidecarBookPrefilter() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSupportedExtensions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ext;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(".*(-\\d+)?\\." + (String)ext, RegexOption.IGNORE_CASE));
        }
        return (List)destination$iv$iv;
    }

    public boolean isSidecarBookMatch(@NotNull String basename, @NotNull String sidecar) {
        Intrinsics.checkNotNullParameter((Object)basename, (String)"basename");
        Intrinsics.checkNotNullParameter((Object)sidecar, (String)"sidecar");
        Regex regex = new Regex(Regex.Companion.escape(basename) + "(-\\d+)?", RegexOption.IGNORE_CASE);
        String string = FilenameUtils.getBaseName((String)sidecar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        return regex.matches((CharSequence)string);
    }

    @NotNull
    public Sidecar.Type getSidecarSeriesType() {
        return Sidecar.Type.ARTWORK;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSidecarSeriesFilenames() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getSupportedSeriesFiles();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String filename = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.getSupportedExtensions();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void ext;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(filename + "." + (String)ext);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Object getBookThumbnails$lambda$0(Book $book) {
        return "Looking for local thumbnails for book: " + $book;
    }

    private static final boolean getBookThumbnails$lambda$7$lambda$1(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean getBookThumbnails$lambda$7$lambda$2(Regex $regex, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return $regex.matches((CharSequence)PathsKt.getNameWithoutExtension((Path)it));
    }

    private static final boolean getBookThumbnails$lambda$7$lambda$3(LocalArtworkProvider this$0, Path it) {
        List list = this$0.getSupportedExtensions();
        Intrinsics.checkNotNull((Object)it);
        String string = PathsKt.getExtension((Path)it).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return list.contains(string);
    }

    private static final boolean getBookThumbnails$lambda$7$lambda$4(LocalArtworkProvider this$0, Path it) {
        ContentDetector contentDetector = this$0.contentDetector;
        ContentDetector contentDetector2 = this$0.contentDetector;
        Intrinsics.checkNotNull((Object)it);
        return contentDetector.isImage(contentDetector2.detectMediaType(it));
    }

    private static final Object getBookThumbnails$lambda$7$lambda$6$lambda$5(Path $path) {
        return "Found file: " + $path;
    }

    private static final ThumbnailBook getBookThumbnails$lambda$7$lambda$6(Book $book, LocalArtworkProvider this$0, int index, Path path) {
        LocalArtworkProviderKt.access$getLogger$p().info(() -> LocalArtworkProvider.getBookThumbnails$lambda$7$lambda$6$lambda$5(path));
        URL uRL = path.toUri().toURL();
        ThumbnailBook.Type type = ThumbnailBook.Type.SIDECAR;
        String string = $book.getId();
        boolean bl = index == 0;
        Intrinsics.checkNotNull((Object)path);
        long l = Files.size(path);
        String string2 = this$0.contentDetector.detectMediaType(path);
        ImageAnalyzer imageAnalyzer = this$0.imageAnalyzer;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Dimension dimension = imageAnalyzer.getDimension(inputStream);
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        return new ThumbnailBook(null, uRL, bl, type, string2, l, dimension2, null, string, null, null, 1665, null);
    }

    private static final Object getSeriesThumbnails$lambda$8() {
        return "Disabled for oneshot series, skipping";
    }

    private static final Object getSeriesThumbnails$lambda$9(Series $series) {
        return "Looking for local thumbnails for series: " + $series;
    }

    private static final boolean getSeriesThumbnails$lambda$16$lambda$10(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean getSeriesThumbnails$lambda$16$lambda$11(LocalArtworkProvider this$0, Path it) {
        List list = this$0.getSupportedSeriesFiles();
        Intrinsics.checkNotNull((Object)it);
        String string = PathsKt.getNameWithoutExtension((Path)it).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return list.contains(string);
    }

    private static final boolean getSeriesThumbnails$lambda$16$lambda$12(LocalArtworkProvider this$0, Path it) {
        List list = this$0.getSupportedExtensions();
        Intrinsics.checkNotNull((Object)it);
        String string = PathsKt.getExtension((Path)it).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return list.contains(string);
    }

    private static final boolean getSeriesThumbnails$lambda$16$lambda$13(LocalArtworkProvider this$0, Path it) {
        ContentDetector contentDetector = this$0.contentDetector;
        ContentDetector contentDetector2 = this$0.contentDetector;
        Intrinsics.checkNotNull((Object)it);
        return contentDetector.isImage(contentDetector2.detectMediaType(it));
    }

    private static final Object getSeriesThumbnails$lambda$16$lambda$15$lambda$14(Path $path) {
        return "Found file: " + $path;
    }

    private static final ThumbnailSeries getSeriesThumbnails$lambda$16$lambda$15(Series $series, LocalArtworkProvider this$0, int index, Path path) {
        LocalArtworkProviderKt.access$getLogger$p().info(() -> LocalArtworkProvider.getSeriesThumbnails$lambda$16$lambda$15$lambda$14(path));
        URL uRL = path.toUri().toURL();
        String string = $series.getId();
        boolean bl = index == 0;
        ThumbnailSeries.Type type = ThumbnailSeries.Type.SIDECAR;
        Intrinsics.checkNotNull((Object)path);
        long l = Files.size(path);
        String string2 = this$0.contentDetector.detectMediaType(path);
        ImageAnalyzer imageAnalyzer = this$0.imageAnalyzer;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Dimension dimension = imageAnalyzer.getDimension(inputStream);
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        return new ThumbnailSeries(null, uRL, bl, type, string2, l, dimension2, null, string, null, null, 1665, null);
    }
}

