/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.SearcherManager;
import org.gotson.komga.infrastructure.search.LuceneCommitter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/infrastructure/search/LuceneAsyncCommitter;", "Lorg/gotson/komga/infrastructure/search/LuceneCommitter;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "commitDelay", "Ljava/time/Duration;", "<init>", "(Lorg/apache/lucene/index/IndexWriter;Lorg/apache/lucene/search/SearcherManager;Lorg/springframework/scheduling/TaskScheduler;Ljava/time/Duration;)V", "commitFuture", "Ljava/util/concurrent/ScheduledFuture;", "commitRunnable", "Ljava/lang/Runnable;", "commitAndMaybeRefresh", "", "komga"})
public class LuceneAsyncCommitter
implements LuceneCommitter {
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final SearcherManager searcherManager;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final Duration commitDelay;
    @Nullable
    private volatile ScheduledFuture<?> commitFuture;
    @NotNull
    private final Runnable commitRunnable;

    public LuceneAsyncCommitter(@NotNull IndexWriter indexWriter, @NotNull SearcherManager searcherManager, @NotNull TaskScheduler taskScheduler, @Value(value="#{@komgaProperties.lucene.commitDelay}") @NotNull Duration commitDelay) {
        Intrinsics.checkNotNullParameter((Object)indexWriter, (String)"indexWriter");
        Intrinsics.checkNotNullParameter((Object)searcherManager, (String)"searcherManager");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)commitDelay, (String)"commitDelay");
        this.indexWriter = indexWriter;
        this.searcherManager = searcherManager;
        this.taskScheduler = taskScheduler;
        this.commitDelay = commitDelay;
        this.commitRunnable = () -> LuceneAsyncCommitter.commitRunnable$lambda$0(this);
    }

    public void commitAndMaybeRefresh() {
        block3: {
            block2: {
                if (this.commitFuture == null) break block2;
                ScheduledFuture scheduledFuture = this.commitFuture;
                Intrinsics.checkNotNull((Object)scheduledFuture);
                if (!scheduledFuture.isDone()) break block3;
            }
            this.commitFuture = this.taskScheduler.schedule(this.commitRunnable, ZonedDateTime.now().plus(this.commitDelay).toInstant());
        }
    }

    private static final void commitRunnable$lambda$0(LuceneAsyncCommitter this$0) {
        this$0.indexWriter.commit();
        this$0.searcherManager.maybeRefresh();
    }
}

