/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security.apikey;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationToken;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "authenticationConverter", "Lorg/springframework/security/web/authentication/AuthenticationConverter;", "<init>", "(Lorg/springframework/security/authentication/AuthenticationManager;Lorg/springframework/security/web/authentication/AuthenticationConverter;)V", "securityContextHolderStrategy", "Lorg/springframework/security/core/context/SecurityContextHolderStrategy;", "securityContextRepository", "Lorg/springframework/security/web/context/SecurityContextRepository;", "failureHandler", "Lorg/springframework/security/web/authentication/AuthenticationFailureHandler;", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "unsuccessfulAuthentication", "failed", "Lorg/springframework/security/core/AuthenticationException;", "successfulAuthentication", "authentication", "Lorg/springframework/security/core/Authentication;", "authenticationIsRequired", "", "username", "", "komga"})
public final class ApiKeyAuthenticationFilter
extends OncePerRequestFilter {
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final AuthenticationConverter authenticationConverter;
    @NotNull
    private final SecurityContextHolderStrategy securityContextHolderStrategy;
    @NotNull
    private final SecurityContextRepository securityContextRepository;
    @NotNull
    private final AuthenticationFailureHandler failureHandler;

    public ApiKeyAuthenticationFilter(@NotNull AuthenticationManager authenticationManager, @NotNull AuthenticationConverter authenticationConverter) {
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)authenticationConverter, (String)"authenticationConverter");
        this.authenticationManager = authenticationManager;
        this.authenticationConverter = authenticationConverter;
        SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)securityContextHolderStrategy, (String)"getContextHolderStrategy(...)");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
        this.securityContextRepository = (SecurityContextRepository)new RequestAttributeSecurityContextRepository();
        this.failureHandler = (AuthenticationFailureHandler)new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED));
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        try {
            Authentication authRequest = this.authenticationConverter.convert(request);
            if (authRequest == null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response2);
                return;
            }
            String string = authRequest.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.authenticationIsRequired(string)) {
                Authentication authResult = this.authenticationManager.authenticate(authRequest);
                if (authResult == null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response2);
                    return;
                }
                this.successfulAuthentication(request, response2, filterChain, authResult);
            }
        }
        catch (AuthenticationException ex) {
            this.unsuccessfulAuthentication(request, response2, ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response2);
    }

    private final void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response2, AuthenticationException failed) {
        this.securityContextHolderStrategy.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response2, failed);
    }

    private final void successfulAuthentication(HttpServletRequest request, HttpServletResponse response2, FilterChain filterChain, Authentication authentication) {
        SecurityContext securityContext;
        SecurityContext $this$successfulAuthentication_u24lambda_u240 = securityContext = this.securityContextHolderStrategy.createEmptyContext();
        boolean bl = false;
        $this$successfulAuthentication_u24lambda_u240.setAuthentication(authentication);
        SecurityContext context = securityContext;
        this.securityContextHolderStrategy.setContext(context);
        this.securityContextRepository.saveContext(context, request, response2);
    }

    private final boolean authenticationIsRequired(String username) {
        Authentication existingAuth = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (existingAuth == null || !Intrinsics.areEqual((Object)existingAuth.getName(), (Object)username) || !existingAuth.isAuthenticated()) {
            return true;
        }
        return existingAuth instanceof AnonymousAuthenticationToken || !(existingAuth instanceof ApiKeyAuthenticationToken);
    }
}

