/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security.apikey;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0014J&\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0014J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider;", "Lorg/springframework/security/authentication/dao/AbstractUserDetailsAuthenticationProvider;", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/KomgaUserRepository;)V", "additionalAuthenticationChecks", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "authentication", "Lorg/springframework/security/authentication/UsernamePasswordAuthenticationToken;", "retrieveUser", "username", "", "createSuccessAuthentication", "Lorg/springframework/security/core/Authentication;", "principal", "", "user", "supports", "", "Ljava/lang/Class;", "komga"})
@SourceDebugExtension(value={"SMAP\nApiKeyAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiKeyAuthenticationProvider.kt\norg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public class ApiKeyAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @NotNull
    private final KomgaUserRepository userRepository;

    public ApiKeyAuthenticationProvider(@NotNull KomgaUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.userRepository = userRepository;
    }

    protected void additionalAuthenticationChecks(@Nullable UserDetails userDetails, @Nullable UsernamePasswordAuthenticationToken authentication) {
    }

    @NotNull
    protected UserDetails retrieveUser(@NotNull String username, @NotNull UsernamePasswordAuthenticationToken authentication) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Pair pair = this.userRepository.findByApiKeyOrNull(authentication.getCredentials().toString());
        if (pair == null) {
            throw new BadCredentialsException("Bad credentials");
        }
        Pair pair2 = pair;
        boolean bl = false;
        KomgaUser user = (KomgaUser)pair2.component1();
        ApiKey apiKey = (ApiKey)pair2.component2();
        String string = authentication.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (UserDetails)new KomgaPrincipal(user, null, null, apiKey, string, 6, null);
    }

    @NotNull
    protected Authentication createSuccessAuthentication(@Nullable Object principal, @Nullable Authentication authentication, @Nullable UserDetails user) {
        ApiKeyAuthenticationToken apiKeyAuthenticationToken;
        Authentication authentication2 = authentication;
        Object object = authentication2 != null ? authentication2.getCredentials() : null;
        UserDetails userDetails = user;
        Intrinsics.checkNotNull((Object)userDetails);
        ApiKeyAuthenticationToken $this$createSuccessAuthentication_u24lambda_u241 = apiKeyAuthenticationToken = ApiKeyAuthenticationToken.Companion.authenticated(principal, object, userDetails.getAuthorities());
        boolean bl = false;
        Authentication authentication3 = authentication;
        $this$createSuccessAuthentication_u24lambda_u241.setDetails(authentication3 != null ? authentication3.getDetails() : null);
        ApiKeyAuthenticationToken it = apiKeyAuthenticationToken;
        boolean bl2 = false;
        this.logger.debug((Object)"Authenticated user");
        return (Authentication)apiKeyAuthenticationToken;
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return ApiKeyAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

