/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.web;

import jakarta.servlet.ServletContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/gotson/komga/infrastructure/web/WebServerEffectiveSettings;", "", "servletContext", "Ljakarta/servlet/ServletContext;", "<init>", "(Ljakarta/servlet/ServletContext;)V", "effectiveServerPort", "", "getEffectiveServerPort", "()Ljava/lang/Integer;", "setEffectiveServerPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "effectiveServletContextPath", "", "getEffectiveServletContextPath", "()Ljava/lang/String;", "onApplicationEvent", "", "event", "Lorg/springframework/boot/web/servlet/context/ServletWebServerInitializedEvent;", "komga"})
public class WebServerEffectiveSettings {
    @Nullable
    private Integer effectiveServerPort;
    @NotNull
    private final String effectiveServletContextPath;

    public WebServerEffectiveSettings(@NotNull ServletContext servletContext) {
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        String string = servletContext.getContextPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContextPath(...)");
        this.effectiveServletContextPath = string;
    }

    @Nullable
    public Integer getEffectiveServerPort() {
        return this.effectiveServerPort;
    }

    public void setEffectiveServerPort(@Nullable Integer n) {
        this.effectiveServerPort = n;
    }

    @NotNull
    public String getEffectiveServletContextPath() {
        return this.effectiveServletContextPath;
    }

    @EventListener
    public void onApplicationEvent(@NotNull ServletWebServerInitializedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setEffectiveServerPort(Integer.valueOf(event.getWebServer().getPort()));
    }
}

