/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/json"})
@Tag(name="User session")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gotson/komga/interfaces/api/rest/LoginController;", "", "cookieSerializer", "Lorg/springframework/session/web/http/CookieSerializer;", "<init>", "(Lorg/springframework/session/web/http/CookieSerializer;)V", "convertHeaderSessionToCookie", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "session", "Ljakarta/servlet/http/HttpSession;", "komga"})
public class LoginController {
    @NotNull
    private final CookieSerializer cookieSerializer;

    public LoginController(@NotNull CookieSerializer cookieSerializer) {
        Intrinsics.checkNotNullParameter((Object)cookieSerializer, (String)"cookieSerializer");
        this.cookieSerializer = cookieSerializer;
    }

    @Operation(summary="Set cookie", description="Forcefully return Set-Cookie header, even if the session is contained in the X-Auth-Token header.")
    @GetMapping(value={"api/v1/login/set-cookie"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void convertHeaderSessionToCookie(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response2, session.getId()));
    }
}

