/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gotson.komga.domain.model.ThumbnailSize;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.web.WebServerEffectiveSettings;
import org.gotson.komga.interfaces.api.rest.dto.SettingMultiSource;
import org.gotson.komga.interfaces.api.rest.dto.SettingsDto;
import org.gotson.komga.interfaces.api.rest.dto.SettingsUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSizeDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSizeDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/settings"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Tag(name="Server settings")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SettingsController;", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "configServerPort", "", "configServerContextPath", "", "serverSettings", "Lorg/gotson/komga/infrastructure/web/WebServerEffectiveSettings;", "kepubConverter", "Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Ljava/lang/Integer;Ljava/lang/String;Lorg/gotson/komga/infrastructure/web/WebServerEffectiveSettings;Lorg/gotson/komga/infrastructure/kobo/KepubConverter;)V", "Ljava/lang/Integer;", "getServerSettings", "Lorg/gotson/komga/interfaces/api/rest/dto/SettingsDto;", "updateServerSettings", "", "newSettings", "Lorg/gotson/komga/interfaces/api/rest/dto/SettingsUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsController.kt\norg/gotson/komga/interfaces/api/rest/SettingsController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public class SettingsController {
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @Nullable
    private final Integer configServerPort;
    @Nullable
    private final String configServerContextPath;
    @NotNull
    private final WebServerEffectiveSettings serverSettings;
    @NotNull
    private final KepubConverter kepubConverter;

    public SettingsController(@NotNull KomgaSettingsProvider komgaSettingsProvider, @Value(value="${server.port:#{null}}") @Nullable Integer configServerPort, @Value(value="${server.servlet.context-path:#{null}}") @Nullable String configServerContextPath, @NotNull WebServerEffectiveSettings serverSettings, @NotNull KepubConverter kepubConverter) {
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)serverSettings, (String)"serverSettings");
        Intrinsics.checkNotNullParameter((Object)kepubConverter, (String)"kepubConverter");
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.configServerPort = configServerPort;
        this.configServerContextPath = configServerContextPath;
        this.serverSettings = serverSettings;
        this.kepubConverter = kepubConverter;
    }

    @GetMapping
    @Operation(summary="Retrieve server settings")
    @NotNull
    public SettingsDto getServerSettings() {
        Path path = this.kepubConverter.getKepubifyPath();
        return new SettingsDto(this.komgaSettingsProvider.getDeleteEmptyCollections(), this.komgaSettingsProvider.getDeleteEmptyReadLists(), Duration.getInWholeDays-impl((long)this.komgaSettingsProvider.getRememberMeDuration-UwyO8pc()), ThumbnailSizeDtoKt.toDto((ThumbnailSize)this.komgaSettingsProvider.getThumbnailSize()), this.komgaSettingsProvider.getTaskPoolSize(), new SettingMultiSource((Object)this.configServerPort, (Object)this.komgaSettingsProvider.getServerPort(), (Object)this.serverSettings.getEffectiveServerPort()), new SettingMultiSource((Object)this.configServerContextPath, (Object)this.komgaSettingsProvider.getServerContextPath(), (Object)this.serverSettings.getEffectiveServletContextPath()), this.komgaSettingsProvider.getKoboProxy(), this.komgaSettingsProvider.getKoboPort(), new SettingMultiSource((Object)this.kepubConverter.getKepubifyConfigurationPath(), (Object)this.komgaSettingsProvider.getKepubifyPath(), (Object)(path != null ? ((Object)path).toString() : null)));
    }

    @PatchMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Update server settings", description="You can omit fields you don't want to update")
    public void updateServerSettings(@Valid @RequestBody @Parameter(description="Fields to update. You can omit fields you don't want to update.") @NotNull SettingsUpdateDto newSettings) {
        boolean it;
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        Boolean bl = newSettings.getDeleteEmptyCollections();
        if (bl != null) {
            it = bl;
            boolean bl2 = false;
            this.komgaSettingsProvider.setDeleteEmptyCollections(it);
        }
        Boolean bl3 = newSettings.getDeleteEmptyReadLists();
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            this.komgaSettingsProvider.setDeleteEmptyReadLists(it);
        }
        Long l = newSettings.getRememberMeDurationDays();
        if (l != null) {
            long it2 = ((Number)l).longValue();
            boolean bl5 = false;
            this.komgaSettingsProvider.setRememberMeDuration-LRDsOJo(DurationKt.toDuration((long)it2, (DurationUnit)DurationUnit.DAYS));
        }
        if (Intrinsics.areEqual((Object)newSettings.getRenewRememberMeKey(), (Object)true)) {
            this.komgaSettingsProvider.renewRememberMeKey();
        }
        ThumbnailSizeDto thumbnailSizeDto = newSettings.getThumbnailSize();
        if (thumbnailSizeDto != null) {
            ThumbnailSizeDto it3 = thumbnailSizeDto;
            boolean bl6 = false;
            this.komgaSettingsProvider.setThumbnailSize(ThumbnailSizeDtoKt.toDomain((ThumbnailSizeDto)it3));
        }
        Integer n = newSettings.getTaskPoolSize();
        if (n != null) {
            int it4 = ((Number)n).intValue();
            boolean bl7 = false;
            this.komgaSettingsProvider.setTaskPoolSize(it4);
        }
        if (newSettings.isSet("serverPort")) {
            this.komgaSettingsProvider.setServerPort(newSettings.getServerPort());
        }
        if (newSettings.isSet("serverContextPath")) {
            this.komgaSettingsProvider.setServerContextPath(newSettings.getServerContextPath());
        }
        Boolean bl8 = newSettings.getKoboProxy();
        if (bl8 != null) {
            boolean it5 = bl8;
            boolean bl9 = false;
            this.komgaSettingsProvider.setKoboProxy(it5);
        }
        if (newSettings.isSet("koboPort")) {
            this.komgaSettingsProvider.setKoboPort(newSettings.getKoboPort());
        }
        if (newSettings.isSet("kepubifyPath")) {
            this.komgaSettingsProvider.setKepubifyPath(newSettings.getKepubifyPath());
        }
    }
}

