/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.AuthenticationActivity;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.UserEmailAlreadyExistsException;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.AllowExcludeDto;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyDto;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ApiKeyRequestDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthenticationActivityDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthenticationActivityDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.PasswordUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.UserCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.UserUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springdoc.core.converters.models.PageableAsQueryParam;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v2/users"}, produces={"application/json"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0017\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0017J\u0012\u0010\u001c\u001a\u00020\u00112\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0017J\u001c\u0010\u001f\u001a\u00020\u00172\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\"\u001a\u00020\u00172\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010%\u001a\u00020\u00172\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J,\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0003\u0010)\u001a\u00020\u000f2\b\b\u0001\u0010*\u001a\u00020+H\u0017J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020(0'2\b\b\u0003\u0010)\u001a\u00020\u000f2\b\b\u0001\u0010*\u001a\u00020+H\u0017J(\u0010-\u001a\u00020(2\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010.\u001a\u0004\u0018\u00010!H\u0017J\u0018\u0010/\u001a\b\u0012\u0004\u0012\u000201002\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001c\u00102\u001a\u0002012\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00103\u001a\u000204H\u0017J\u001c\u00105\u001a\u00020\u00172\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u00106\u001a\u00020!H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gotson/komga/interfaces/api/rest/UserController;", "", "userLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "authenticationActivityRepository", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "env", "Lorg/springframework/core/env/Environment;", "<init>", "(Lorg/gotson/komga/domain/service/KomgaUserLifecycle;Lorg/gotson/komga/domain/persistence/KomgaUserRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;Lorg/springframework/core/env/Environment;)V", "demo", "", "getCurrentUser", "Lorg/gotson/komga/interfaces/api/rest/dto/UserDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "rememberMe", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/Boolean;)Lorg/gotson/komga/interfaces/api/rest/dto/UserDto;", "updatePasswordForCurrentUser", "", "newPasswordDto", "Lorg/gotson/komga/interfaces/api/rest/dto/PasswordUpdateDto;", "getUsers", "", "addUser", "newUser", "Lorg/gotson/komga/interfaces/api/rest/dto/UserCreationDto;", "deleteUserById", "id", "", "updateUserById", "patch", "Lorg/gotson/komga/interfaces/api/rest/dto/UserUpdateDto;", "updatePasswordByUserId", "getAuthenticationActivityForCurrentUser", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthenticationActivityDto;", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getAuthenticationActivity", "getLatestAuthenticationActivityByUserId", "apiKeyId", "getApiKeysForCurrentUser", "", "Lorg/gotson/komga/interfaces/api/rest/dto/ApiKeyDto;", "createApiKeyForCurrentUser", "apiKeyRequest", "Lorg/gotson/komga/interfaces/api/rest/dto/ApiKeyRequestDto;", "deleteApiKeyByKeyId", "keyId", "komga"})
@SourceDebugExtension(value={"SMAP\nUserController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserController.kt\norg/gotson/komga/interfaces/api/rest/UserController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1563#2:318\n1634#2,3:319\n1563#2:322\n1634#2,3:323\n1563#2:326\n1634#2,3:327\n1563#2:330\n1634#2,3:331\n*S KotlinDebug\n*F\n+ 1 UserController.kt\norg/gotson/komga/interfaces/api/rest/UserController\n*L\n86#1:318\n86#1:319,3\n110#1:322\n110#1:323,3\n163#1:326\n163#1:327,3\n287#1:330\n287#1:331,3\n*E\n"})
public class UserController {
    @NotNull
    private final KomgaUserLifecycle userLifecycle;
    @NotNull
    private final KomgaUserRepository userRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final AuthenticationActivityRepository authenticationActivityRepository;
    private final boolean demo;

    public UserController(@NotNull KomgaUserLifecycle userLifecycle, @NotNull KomgaUserRepository userRepository, @NotNull LibraryRepository libraryRepository, @NotNull AuthenticationActivityRepository authenticationActivityRepository, @NotNull Environment env) {
        Intrinsics.checkNotNullParameter((Object)userLifecycle, (String)"userLifecycle");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)authenticationActivityRepository, (String)"authenticationActivityRepository");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.userLifecycle = userLifecycle;
        this.userRepository = userRepository;
        this.libraryRepository = libraryRepository;
        this.authenticationActivityRepository = authenticationActivityRepository;
        String[] stringArray = env.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        this.demo = ArraysKt.contains((Object[])stringArray, (Object)"demo");
    }

    @GetMapping(value={"me"})
    @Operation(tags={"Current user"}, summary="Retrieve current user")
    @NotNull
    public UserDto getCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="remember-me", required=false) @Nullable Boolean rememberMe) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return UserDtoKt.toDto((KomgaPrincipal)principal);
    }

    @PatchMapping(value={"me/password"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(tags={"Current user"}, summary="Update current user's password")
    public void updatePasswordForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull PasswordUpdateDto newPasswordDto) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)newPasswordDto, (String)"newPasswordDto");
        if (this.demo) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        KomgaUser komgaUser = this.userRepository.findByEmailIgnoreCaseOrNull(principal.getUsername());
        if (komgaUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        KomgaUser user = komgaUser;
        boolean bl = false;
        this.userLifecycle.updatePassword(user, newPasswordDto.getPassword(), false);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="List users")
    @NotNull
    public List<UserDto> getUsers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.userRepository.findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KomgaUser komgaUser = (KomgaUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UserDtoKt.toDto((KomgaUser)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="Create user")
    @NotNull
    public UserDto addUser(@Valid @RequestBody @NotNull UserCreationDto newUser) {
        UserCreationDto userCreationDto;
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        try {
            Set set;
            Set set2;
            boolean bl;
            void $this$addUser_u24lambda_u243;
            userCreationDto = newUser;
            KomgaUserLifecycle komgaUserLifecycle = this.userLifecycle;
            boolean bl2 = false;
            String string = $this$addUser_u24lambda_u243.getEmail();
            String string2 = $this$addUser_u24lambda_u243.getPassword();
            Set set3 = UserRoles.Companion.valuesOf((Iterable)$this$addUser_u24lambda_u243.getRoles());
            boolean bl3 = bl = $this$addUser_u24lambda_u243.getSharedLibraries() == null || $this$addUser_u24lambda_u243.getSharedLibraries().getAll();
            if ($this$addUser_u24lambda_u243.getSharedLibraries() == null || $this$addUser_u24lambda_u243.getSharedLibraries().getAll()) {
                set2 = SetsKt.emptySet();
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.libraryRepository.findAllByIds((Collection)$this$addUser_u24lambda_u243.getSharedLibraries().getLibraryIds());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Library library = (Library)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getId());
                }
                set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            Set set4 = set2;
            AgeRestriction ageRestriction = $this$addUser_u24lambda_u243.getAgeRestriction() == null || $this$addUser_u24lambda_u243.getAgeRestriction().getRestriction() == AllowExcludeDto.NONE ? null : new AgeRestriction($this$addUser_u24lambda_u243.getAgeRestriction().getAge(), $this$addUser_u24lambda_u243.getAgeRestriction().getRestriction().toDomain());
            Set set5 = $this$addUser_u24lambda_u243.getLabelsAllow();
            if (set5 == null) {
                set5 = SetsKt.emptySet();
            }
            if ((set = $this$addUser_u24lambda_u243.getLabelsExclude()) == null) {
                set = SetsKt.emptySet();
            }
            ContentRestrictions contentRestrictions = new ContentRestrictions(ageRestriction, set5, set);
            userCreationDto = UserDtoKt.toDto((KomgaUser)komgaUserLifecycle.createUser(new KomgaUser(string, string2, set3, set4, bl, contentRestrictions, null, null, null, 448, null)));
        }
        catch (UserEmailAlreadyExistsException userEmailAlreadyExistsException) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "A user with this email already exists");
        }
        return userCreationDto;
    }

    @DeleteMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') and #principal.user.id != #id")
    @Operation(tags={"Users"}, summary="Delete user")
    public void deleteUserById(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        KomgaUser komgaUser = this.userRepository.findByIdOrNull(id);
        if (komgaUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        KomgaUser it = komgaUser;
        boolean bl = false;
        this.userLifecycle.deleteUser(it);
    }

    /*
     * Unable to fully structure code
     */
    @PatchMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') and #principal.user.id != #id")
    @Operation(tags={"Users"}, summary="Update user")
    public void updateUserById(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull UserUpdateDto patch, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        block20: {
            block17: {
                block19: {
                    block18: {
                        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
                        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                        v0 = this.userRepository.findByIdOrNull(id);
                        if (v0 == null) break block17;
                        existing = v0;
                        $i$a$-let-UserController$updateUserById$1 = false;
                        $this$updateUserById_u24lambda_u247_u24lambda_u246 = patch;
                        $i$a$-with-UserController$updateUserById$1$updatedUser$1 = false;
                        if ($this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("roles")) {
                            v1 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getRoles();
                            Intrinsics.checkNotNull((Object)v1);
                            v2 = UserRoles.Companion.valuesOf((Iterable)v1);
                        } else {
                            v2 = var8_8 = existing.getRoles();
                        }
                        if ($this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("sharedLibraries")) {
                            v3 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getSharedLibraries();
                            Intrinsics.checkNotNull((Object)v3);
                            v4 = v3.getAll();
                        } else {
                            v4 = var9_9 = existing.getSharedAllLibraries();
                        }
                        if ($this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("sharedLibraries")) {
                            v5 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getSharedLibraries();
                            Intrinsics.checkNotNull((Object)v5);
                            if (v5.getAll()) {
                                v6 = SetsKt.emptySet();
                            } else {
                                v7 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getSharedLibraries();
                                Intrinsics.checkNotNull((Object)v7);
                                $this$map$iv = this.libraryRepository.findAllByIds((Collection)v7.getLibraryIds());
                                $i$f$map = false;
                                var12_12 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var17_17 = (Library)item$iv$iv;
                                    var18_18 = destination$iv$iv;
                                    $i$a$-map-UserController$updateUserById$1$updatedUser$1$1 = false;
                                    var18_18.add(it.getId());
                                }
                                v6 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            }
                        } else {
                            v6 = var20_20 = existing.getSharedLibrariesIds();
                        }
                        if (!$this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("ageRestriction")) break block18;
                        if ($this$updateUserById_u24lambda_u247_u24lambda_u246.getAgeRestriction() == null) ** GOTO lbl-1000
                        v8 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getAgeRestriction();
                        if ((v8 != null ? v8.getRestriction() : null) == AllowExcludeDto.NONE) lbl-1000:
                        // 2 sources

                        {
                            v9 = null;
                        } else {
                            v10 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getAgeRestriction();
                            Intrinsics.checkNotNull((Object)v10);
                            v11 = v10.getAge();
                            v12 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getAgeRestriction();
                            Intrinsics.checkNotNull((Object)v12);
                            v9 = new AgeRestriction(v11, v12.getRestriction().toDomain());
                        }
                        break block19;
                    }
                    v9 = existing.getRestrictions().getAgeRestriction();
                }
                if ($this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("labelsAllow")) {
                    v13 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getLabelsAllow();
                    if (v13 == null) {
                        v13 = SetsKt.emptySet();
                    }
                } else {
                    v13 = existing.getRestrictions().getLabelsAllow();
                }
                if ($this$updateUserById_u24lambda_u247_u24lambda_u246.isSet("labelsExclude")) {
                    v14 = $this$updateUserById_u24lambda_u247_u24lambda_u246.getLabelsExclude();
                    if (v14 == null) {
                        v14 = SetsKt.emptySet();
                    }
                } else {
                    v14 = existing.getRestrictions().getLabelsExclude();
                }
                break block20;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        var10_10 = new ContentRestrictions(v9, v13, v14);
        updatedUser = KomgaUser.copy$default((KomgaUser)existing, null, null, (Set)var8_8, (Set)var20_20, (boolean)var9_9, (ContentRestrictions)var10_10, null, null, null, (int)451, null);
        this.userLifecycle.updateUser(updatedUser);
    }

    @PatchMapping(value={"{id}/password"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN') or #principal.user.id == #id")
    @Operation(tags={"Users"}, summary="Update user's password")
    public void updatePasswordByUserId(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull PasswordUpdateDto newPasswordDto) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)newPasswordDto, (String)"newPasswordDto");
        if (this.demo) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        KomgaUser komgaUser = this.userRepository.findByIdOrNull(id);
        if (komgaUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        KomgaUser user = komgaUser;
        boolean bl = false;
        this.userLifecycle.updatePassword(user, newPasswordDto.getPassword(), !Intrinsics.areEqual((Object)user.getId(), (Object)principal.getUser().getId()));
    }

    @GetMapping(value={"me/authentication-activity"})
    @PageableAsQueryParam
    @Operation(tags={"Current user"}, summary="Retrieve authentication activity for the current user")
    @NotNull
    public Page<AuthenticationActivityDto> getAuthenticationActivityForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"dateTime")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.authenticationActivityRepository.findAllByUser(principal.getUser(), pageRequest).map(arg_0 -> UserController.getAuthenticationActivityForCurrentUser$lambda$10(UserController::getAuthenticationActivityForCurrentUser$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAuthenticationActivityForCurrentUser$default(UserController userController, KomgaPrincipal komgaPrincipal, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAuthenticationActivityForCurrentUser");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return userController.getAuthenticationActivityForCurrentUser(komgaPrincipal, bl, pageable);
    }

    @GetMapping(value={"authentication-activity"})
    @PageableAsQueryParam
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(tags={"Users"}, summary="Retrieve authentication activity")
    @NotNull
    public Page<AuthenticationActivityDto> getAuthenticationActivity(@RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"dateTime")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.authenticationActivityRepository.findAll(pageRequest).map(arg_0 -> UserController.getAuthenticationActivity$lambda$12(UserController::getAuthenticationActivity$lambda$11, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAuthenticationActivity$default(UserController userController, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAuthenticationActivity");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return userController.getAuthenticationActivity(bl, pageable);
    }

    @GetMapping(value={"{id}/authentication-activity/latest"})
    @PreAuthorize(value="hasRole('ADMIN') or #principal.user.id == #id")
    @Operation(tags={"Users"}, summary="Retrieve latest authentication activity for a user")
    @NotNull
    public AuthenticationActivityDto getLatestAuthenticationActivityByUserId(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="apikey_id", required=false) @Nullable String apiKeyId) {
        KomgaUser komgaUser;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                komgaUser = this.userRepository.findByIdOrNull(id);
                if (komgaUser == null) break block4;
                KomgaUser user = komgaUser;
                boolean bl = false;
                AuthenticationActivity authenticationActivity = this.authenticationActivityRepository.findMostRecentByUser(user, apiKeyId);
                if (authenticationActivity == null || (authenticationActivity = AuthenticationActivityDtoKt.toDto((AuthenticationActivity)authenticationActivity)) == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                komgaUser = authenticationActivity;
                if (authenticationActivity != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return komgaUser;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"me/api-keys"})
    @Operation(tags={"API Keys"}, summary="Retrieve API keys")
    @NotNull
    public Collection<ApiKeyDto> getApiKeysForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        Iterable $this$map$iv = this.userRepository.findApiKeyByUserId(principal.getUser().getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApiKey apiKey = (ApiKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiKeyDtoKt.redacted((ApiKeyDto)ApiKeyDtoKt.toDto((ApiKey)it)));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"me/api-keys"})
    @Operation(tags={"API Keys"}, summary="Create API key")
    @NotNull
    public ApiKeyDto createApiKeyForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Valid @RequestBody @NotNull ApiKeyRequestDto apiKeyRequest) {
        ApiKeyDto apiKeyDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)apiKeyRequest, (String)"apiKeyRequest");
        if (this.demo && !principal.getUser().isAdmin()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ApiKey apiKey = this.userLifecycle.createApiKey(principal.getUser(), apiKeyRequest.getComment());
            apiKeyDto = apiKey != null ? ApiKeyDtoKt.toDto((ApiKey)apiKey) : null;
        }
        catch (DuplicateNameException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getCode());
        }
        ApiKeyDto apiKeyDto2 = apiKeyDto;
        if (apiKeyDto2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Failed to generate API key");
        }
        return apiKeyDto2;
    }

    @DeleteMapping(value={"me/api-keys/{keyId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(tags={"API Keys"}, summary="Delete API key")
    public void deleteApiKeyByKeyId(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        if (!this.userRepository.existsApiKeyByIdAndUserId(keyId, principal.getUser().getId())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        this.userRepository.deleteApiKeyByIdAndUserId(keyId, principal.getUser().getId());
    }

    private static final AuthenticationActivityDto getAuthenticationActivityForCurrentUser$lambda$9(AuthenticationActivity it) {
        Intrinsics.checkNotNull((Object)it);
        return AuthenticationActivityDtoKt.toDto((AuthenticationActivity)it);
    }

    private static final AuthenticationActivityDto getAuthenticationActivityForCurrentUser$lambda$10(Function1 $tmp0, Object p0) {
        return (AuthenticationActivityDto)$tmp0.invoke(p0);
    }

    private static final AuthenticationActivityDto getAuthenticationActivity$lambda$11(AuthenticationActivity it) {
        Intrinsics.checkNotNull((Object)it);
        return AuthenticationActivityDtoKt.toDto((AuthenticationActivity)it);
    }

    private static final AuthenticationActivityDto getAuthenticationActivity$lambda$12(Function1 $tmp0, Object p0) {
        return (AuthenticationActivityDto)$tmp0.invoke(p0);
    }
}

