/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.scheduler;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.interfaces.scheduler.InitialUserControllerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Profile(value={"!test & noclaim"})
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gotson/komga/interfaces/scheduler/InitialUserController;", "", "userLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "initialUsers", "", "Lorg/gotson/komga/domain/model/KomgaUser;", "<init>", "(Lorg/gotson/komga/domain/service/KomgaUserLifecycle;Ljava/util/List;)V", "createInitialUserOnStartupIfNoneExist", "", "komga"})
@SourceDebugExtension(value={"SMAP\nInitialUserController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitialUserController.kt\norg/gotson/komga/interfaces/scheduler/InitialUserController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1869#2,2:58\n*S KotlinDebug\n*F\n+ 1 InitialUserController.kt\norg/gotson/komga/interfaces/scheduler/InitialUserController\n*L\n29#1:58,2\n*E\n"})
public class InitialUserController {
    @NotNull
    private final KomgaUserLifecycle userLifecycle;
    @NotNull
    private final List<KomgaUser> initialUsers;

    public InitialUserController(@NotNull KomgaUserLifecycle userLifecycle, @NotNull List<KomgaUser> initialUsers) {
        Intrinsics.checkNotNullParameter((Object)userLifecycle, (String)"userLifecycle");
        Intrinsics.checkNotNullParameter(initialUsers, (String)"initialUsers");
        this.userLifecycle = userLifecycle;
        this.initialUsers = initialUsers;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void createInitialUserOnStartupIfNoneExist() {
        if (this.userLifecycle.countUsers() == 0L) {
            InitialUserControllerKt.access$getLogger$p().info(InitialUserController::createInitialUserOnStartupIfNoneExist$lambda$0);
            Iterable $this$forEach$iv = this.initialUsers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KomgaUser it = (KomgaUser)element$iv;
                boolean bl = false;
                this.userLifecycle.createUser(it);
                InitialUserControllerKt.access$getLogger$p().info(() -> InitialUserController.createInitialUserOnStartupIfNoneExist$lambda$2$lambda$1(it));
            }
        }
    }

    private static final Object createInitialUserOnStartupIfNoneExist$lambda$0() {
        return "No users exist in database, creating initial users";
    }

    private static final Object createInitialUserOnStartupIfNoneExist$lambda$2$lambda$1(KomgaUser $it) {
        return "Initial user created. Login: " + $it.getEmail() + ", Password: " + $it.getPassword();
    }
}

