/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.configuration;

import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.Positive;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="komga")
@Validated
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0005=>?@AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0013R\u001e\u0010\u0006\u001a\u00020\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006B"}, d2={"Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "", "<init>", "()V", "makeDirs", "", "pageHashing", "", "getPageHashing", "()I", "setPageHashing", "(I)V", "epubDivinaLetterCountThreshold", "getEpubDivinaLetterCountThreshold", "setEpubDivinaLetterCountThreshold", "oauth2AccountCreation", "", "getOauth2AccountCreation", "()Z", "setOauth2AccountCreation", "(Z)V", "oidcEmailVerification", "getOidcEmailVerification", "setOidcEmailVerification", "database", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "getDatabase", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "setDatabase", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;)V", "tasksDb", "getTasksDb", "setTasksDb", "cors", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;", "getCors", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;", "setCors", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;)V", "lucene", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;", "getLucene", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;", "setLucene", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;)V", "configDir", "", "getConfigDir", "()Ljava/lang/String;", "setConfigDir", "(Ljava/lang/String;)V", "kobo", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;", "getKobo", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;", "setKobo", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;)V", "fonts", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Fonts;", "getFonts", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Fonts;", "Cors", "Database", "Fonts", "Lucene", "Kobo", "komga"})
public class KomgaProperties {
    @Positive
    private int pageHashing = 3;
    @Positive
    private int epubDivinaLetterCountThreshold = 15;
    private boolean oauth2AccountCreation;
    private boolean oidcEmailVerification = true;
    @NotNull
    private Database database = new Database();
    @NotNull
    private Database tasksDb = new Database();
    @NotNull
    private Cors cors = new Cors();
    @NotNull
    private Lucene lucene = new Lucene();
    @Nullable
    private String configDir;
    @NotNull
    private Kobo kobo = new Kobo();
    @NotNull
    private final Fonts fonts = new Fonts();

    @PostConstruct
    private void makeDirs() {
        try {
            Path path = Paths.get(this.getDatabase().getFile(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            Path path3 = path2;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            Path path4 = Paths.get(this.getTasksDb().getFile(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
            Path path5 = path4.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getParent(...)");
            path3 = path5;
            fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPageHashing() {
        return this.pageHashing;
    }

    public void setPageHashing(int n) {
        this.pageHashing = n;
    }

    public int getEpubDivinaLetterCountThreshold() {
        return this.epubDivinaLetterCountThreshold;
    }

    public void setEpubDivinaLetterCountThreshold(int n) {
        this.epubDivinaLetterCountThreshold = n;
    }

    public boolean getOauth2AccountCreation() {
        return this.oauth2AccountCreation;
    }

    public void setOauth2AccountCreation(boolean bl) {
        this.oauth2AccountCreation = bl;
    }

    public boolean getOidcEmailVerification() {
        return this.oidcEmailVerification;
    }

    public void setOidcEmailVerification(boolean bl) {
        this.oidcEmailVerification = bl;
    }

    @NotNull
    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.database = database;
    }

    @NotNull
    public Database getTasksDb() {
        return this.tasksDb;
    }

    public void setTasksDb(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.tasksDb = database;
    }

    @NotNull
    public Cors getCors() {
        return this.cors;
    }

    public void setCors(@NotNull Cors cors) {
        Intrinsics.checkNotNullParameter((Object)cors, (String)"<set-?>");
        this.cors = cors;
    }

    @NotNull
    public Lucene getLucene() {
        return this.lucene;
    }

    public void setLucene(@NotNull Lucene lucene) {
        Intrinsics.checkNotNullParameter((Object)lucene, (String)"<set-?>");
        this.lucene = lucene;
    }

    @Nullable
    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(@Nullable String string) {
        this.configDir = string;
    }

    @NotNull
    public Kobo getKobo() {
        return this.kobo;
    }

    public void setKobo(@NotNull Kobo kobo) {
        Intrinsics.checkNotNullParameter((Object)kobo, (String)"<set-?>");
        this.kobo = kobo;
    }

    @NotNull
    public Fonts getFonts() {
        return this.fonts;
    }
}

